/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.generator.handler.shared;

import com.javonet.core.generator.handler.Handlers;
import com.javonet.core.generator.handler.shared.IHandler;
import com.javonet.sdk.core.JvmCommand;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;

public class SharedMethodNameHandler
implements IHandler {
    @Override
    public Object generateCommand(Object analyzedObject, JvmCommand parentCommand, Handlers handlers) {
        return analyzedObject;
    }

    @Override
    public void generateCode(StringBuilder existingStringBuilder, JvmCommand commonCommand, Object usedObject, Handlers handlers) {
        String methodName = usedObject.toString();
        methodName = methodName.replaceAll("@", "");
        methodName = methodName.replaceAll("-", "_");
        methodName = this.replaceGroup("(?m)^(\\d+).*", methodName, 1, 1, "");
        StringBuilder sb = new StringBuilder(methodName);
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        if (SourceVersion.isKeyword(sb.toString())) {
            sb.append(sb.charAt(sb.length() - 1));
        }
        if (!SourceVersion.isIdentifier(sb.toString())) {
            throw new IllegalArgumentException("Unable to generate correct method name for: " + usedObject.toString());
        }
        existingStringBuilder.append((CharSequence)sb);
    }

    private String replaceGroup(String regex, String source, int groupToReplace, int groupOccurrence, String replacement) {
        Matcher m = Pattern.compile(regex).matcher(source);
        for (int i = 0; i < groupOccurrence; ++i) {
            if (m.find()) continue;
            return source;
        }
        return new StringBuilder(source).replace(m.start(groupToReplace), m.end(groupToReplace), replacement).toString();
    }
}

