/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.CastingHandler;
import com.javonet.core.handler.CreateInstanceHandler;
import com.javonet.core.handler.DestructReferenceHandler;
import com.javonet.core.handler.GenerateLibraryHandler;
import com.javonet.core.handler.GetInstanceFieldHandler;
import com.javonet.core.handler.GetStaticFieldHandler;
import com.javonet.core.handler.GetTypeHandler;
import com.javonet.core.handler.Handler;
import com.javonet.core.handler.InvokeInstanceMethodHandler;
import com.javonet.core.handler.InvokeStaticMethodHandler;
import com.javonet.core.handler.LoadLibraryHandler;
import com.javonet.core.handler.OptimizeHandler;
import com.javonet.core.handler.ReferencesCache;
import com.javonet.core.handler.ResolveInstanceHandler;
import com.javonet.core.handler.SetStaticFieldHandler;
import com.javonet.sdk.core.JvmCommand;
import com.javonet.sdk.core.JvmCommandType;
import com.javonet.utils.exceptions.ExceptionSerializer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class JvmHandler {
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();
    Map<JvmCommandType, Handler> HANDLERS = new HashMap<JvmCommandType, Handler>();

    public JvmHandler() {
        this.HANDLERS.put(JvmCommandType.LOAD_LIBRARY, new LoadLibraryHandler());
        this.HANDLERS.put(JvmCommandType.INVOKE_STATIC_METHOD, new InvokeStaticMethodHandler());
        this.HANDLERS.put(JvmCommandType.GET_STATIC_FIELD, new GetStaticFieldHandler());
        this.HANDLERS.put(JvmCommandType.SET_STATIC_FIELD, new SetStaticFieldHandler());
        this.HANDLERS.put(JvmCommandType.CREATE_INSTANCE, new CreateInstanceHandler());
        this.HANDLERS.put(JvmCommandType.GET_TYPE, new GetTypeHandler());
        this.HANDLERS.put(JvmCommandType.REFERENCE, new ResolveInstanceHandler());
        this.HANDLERS.put(JvmCommandType.INVOKE_INSTANCE_METHOD, new InvokeInstanceMethodHandler());
        this.HANDLERS.put(JvmCommandType.CAST, new CastingHandler());
        this.HANDLERS.put(JvmCommandType.OPTIMIZE, new OptimizeHandler());
        this.HANDLERS.put(JvmCommandType.GENERATE_LIB, new GenerateLibraryHandler());
        this.HANDLERS.put(JvmCommandType.GET_INSTANCE_FIELD, new GetInstanceFieldHandler());
        this.HANDLERS.put(JvmCommandType.DESTRUCT_REFERENCE, new DestructReferenceHandler());
    }

    private static boolean isPrimitiveOrWrapper(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.isPrimitive() || JvmHandler.isPrimitiveWrapper(type);
    }

    private static boolean isPrimitiveWrapper(Class<?> type) {
        return primitiveWrapperMap.containsKey(type);
    }

    public JvmCommand handleCommand(JvmCommand jvmCommand) {
        Object result = Optional.of(this.HANDLERS.get((Object)jvmCommand.getCommandType())).map(handler -> {
            try {
                return handler.handleCommand(jvmCommand);
            }
            catch (Exception e) {
                if (e.getCause() != null) {
                    return ExceptionSerializer.serializeException(e.getCause(), jvmCommand);
                }
                return ExceptionSerializer.serializeException(e, jvmCommand);
            }
        }).orElse(new JvmCommand(jvmCommand.getTargetRuntime(), JvmCommandType.RESPONSE, new String[]{"Empty Response"}));
        if (JvmHandler.isResponseSimpleType(result)) {
            return jvmCommand.createResponse(result);
        }
        if (JvmHandler.isResponseArray(result)) {
            return jvmCommand.createArrayResponse(result);
        }
        if (JvmHandler.isCommandGenerateLibType(result) || JvmHandler.isCommandExceptionType(result)) {
            return (JvmCommand)result;
        }
        ReferencesCache cache = ReferencesCache.getInstance();
        String uuid = cache.cacheReference(result);
        return jvmCommand.createReference(uuid);
    }

    private static boolean isCommandGenerateLibType(Object result) {
        if (result.getClass() == JvmCommand.class) {
            return ((JvmCommand)result).getCommandType().equals((Object)JvmCommandType.GENERATE_LIB);
        }
        return false;
    }

    private static boolean isCommandExceptionType(Object result) {
        if (result.getClass() == JvmCommand.class) {
            return ((JvmCommand)result).getCommandType().equals((Object)JvmCommandType.EXCEPTION);
        }
        return false;
    }

    private static boolean isResponseSimpleType(Object result) {
        Class<?> resultClass = result.getClass();
        return resultClass.isPrimitive() || resultClass == String.class || resultClass == Long.class || resultClass == Integer.class || resultClass == Boolean.class || resultClass == Byte.class || resultClass == Float.class || resultClass == Double.class;
    }

    private static boolean isResponseArray(Object result) {
        return result.getClass().isArray();
    }

    private static boolean testIfArrayContainsOnlyPrimitives(Object[] arr) {
        for (Object el : arr) {
            if (JvmHandler.isPrimitiveOrWrapper(el.getClass())) continue;
            return false;
        }
        return true;
    }

    static {
        primitiveWrapperMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperMap.put(Character.class, Character.TYPE);
        primitiveWrapperMap.put(Short.class, Short.TYPE);
        primitiveWrapperMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperMap.put(Long.class, Long.TYPE);
        primitiveWrapperMap.put(Double.class, Double.TYPE);
        primitiveWrapperMap.put(Float.class, Float.TYPE);
        primitiveWrapperMap.put(Void.class, Void.TYPE);
        primitiveWrapperMap.put(String.class, String.class);
    }
}

