/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.generator.handler.shared;

import com.javonet.core.generator.handler.GeneratorHandler;
import com.javonet.core.generator.handler.Handlers;
import com.javonet.core.generator.handler.shared.IHandler;
import com.javonet.core.generator.internal.SharedHandlerType;
import com.javonet.sdk.core.JvmCommand;
import com.javonet.sdk.core.Type;
import java.io.File;

public class SharedTypeHandler
implements IHandler {
    @Override
    public Object generateCommand(Object analyzedObject, JvmCommand parentCommand, Handlers handlers) {
        String type;
        switch (type = (String)analyzedObject) {
            case "void": {
                return Type.COMMAND.ordinal();
            }
            case "java.lang.String": {
                return Type.STRING.ordinal();
            }
            case "int": 
            case "UNSIGNED_INTEGER": {
                return Type.INTEGER.ordinal();
            }
            case "boolean": {
                return Type.BOOLEAN.ordinal();
            }
            case "float": {
                return Type.FLOAT.ordinal();
            }
            case "byte": {
                return Type.BYTE.ordinal();
            }
            case "char": {
                return Type.CHAR.ordinal();
            }
            case "long": 
            case "UNSIGNED_LONG_LONG": {
                return Type.LONG.ordinal();
            }
            case "double": {
                return Type.DOUBLE.ordinal();
            }
            case "[Z": {
                return Type.COMMAND.ordinal();
            }
            case "[B": {
                return Type.COMMAND.ordinal();
            }
            case "[S": {
                return Type.COMMAND.ordinal();
            }
            case "[I": {
                return Type.COMMAND.ordinal();
            }
            case "[J": {
                return Type.COMMAND.ordinal();
            }
            case "[F": {
                return Type.COMMAND.ordinal();
            }
            case "[D": {
                return Type.COMMAND.ordinal();
            }
            case "[C": {
                return Type.COMMAND.ordinal();
            }
            case "[Ljava.lang.String;": {
                return Type.COMMAND.ordinal();
            }
            case "[Ljava.lang.Double;": {
                return Type.COMMAND.ordinal();
            }
            case "[[I": {
                return Type.COMMAND.ordinal();
            }
            case "[[[I": {
                return Type.COMMAND.ordinal();
            }
        }
        this.complexCommandTypeGenerator(handlers, analyzedObject);
        return analyzedObject.toString();
    }

    @Override
    public void generateCode(StringBuilder existingStringBuilder, JvmCommand commonCommand, Object usedObject, Handlers handlers) {
        if (Type.COMMAND.equals(usedObject)) {
            existingStringBuilder.append("void");
            existingStringBuilder.append(" ");
        } else if (Type.STRING.equals(usedObject)) {
            existingStringBuilder.append("String");
            existingStringBuilder.append(" ");
        } else if (Type.INTEGER.equals(usedObject) || Type.UNSIGNED_INTEGER.equals(usedObject)) {
            existingStringBuilder.append("int");
            existingStringBuilder.append(" ");
        } else if (Type.BOOLEAN.equals(usedObject)) {
            existingStringBuilder.append("boolean");
            existingStringBuilder.append(" ");
        } else if (Type.FLOAT.equals(usedObject)) {
            existingStringBuilder.append("float");
            existingStringBuilder.append(" ");
        } else if (Type.BYTE.equals(usedObject)) {
            existingStringBuilder.append("byte");
            existingStringBuilder.append(" ");
        } else if (Type.CHAR.equals(usedObject)) {
            existingStringBuilder.append("char");
            existingStringBuilder.append(" ");
        } else if (Type.LONG.equals(usedObject) || Type.UNSIGNED_LONG_LONG.equals(usedObject)) {
            existingStringBuilder.append("long");
            existingStringBuilder.append(" ");
        } else if (Type.DOUBLE.equals(usedObject)) {
            existingStringBuilder.append("double");
            existingStringBuilder.append(" ");
        } else {
            handlers.SHARED_HANDLER.get((Object)SharedHandlerType.CLASS_NAME).generateCode(existingStringBuilder, commonCommand, usedObject, handlers);
            existingStringBuilder.append(" ");
        }
    }

    private void complexCommandTypeGenerator(Handlers handlers, Object analyzedObject) {
        String clazzName = analyzedObject.toString();
        if (analyzedObject.toString().startsWith("[L")) {
            clazzName = clazzName.replace("[L", "");
        }
        String finalClazzName = clazzName;
        if (handlers.typesToAnalyze.stream().noneMatch(clazz -> clazz.getName().equals(finalClazzName))) {
            Class<?> classToBeGenerated = GeneratorHandler.getClass(finalClazzName, new File(System.getProperty("user.dir")));
            handlers.typesToAnalyze.add(classToBeGenerated);
        }
    }
}

