/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.internal;

import com.javonet.core.runtime.IEmbeddedRuntime;
import com.javonet.core.transmitter.JvmTransmitter;
import com.javonet.sdk.core.RuntimeLib;
import com.javonet.sdk.internal.AbstractRuntimeFactory;
import com.javonet.sdk.internal.BinariesUnloader;
import com.javonet.sdk.internal.ConnectionType;
import com.javonet.sdk.internal.RuntimeContext;
import com.javonet.utils.TcpConnectionData;
import java.io.IOException;
import java.util.Optional;

public class RuntimeFactory
implements AbstractRuntimeFactory {
    private final ConnectionType connectionType;
    private final Optional<TcpConnectionData> tcpAddress;

    public RuntimeFactory(ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress) {
        this.connectionType = connectionType;
        this.tcpAddress = tcpAddress;
    }

    public RuntimeFactory(ConnectionType connectionType) {
        this.connectionType = connectionType;
        this.tcpAddress = Optional.empty();
    }

    @Override
    public RuntimeContext clr() {
        return RuntimeContext.getInstance(RuntimeLib.Clr, this.connectionType, this.tcpAddress);
    }

    @Override
    public RuntimeContext go() {
        return RuntimeContext.getInstance(RuntimeLib.Go, this.connectionType, this.tcpAddress);
    }

    @Override
    public RuntimeContext jvm() {
        return RuntimeContext.getInstance(RuntimeLib.Jvm, this.connectionType, this.tcpAddress);
    }

    @Override
    public RuntimeContext netcore() {
        return RuntimeContext.getInstance(RuntimeLib.Netcore, this.connectionType, this.tcpAddress);
    }

    @Override
    public RuntimeContext perl() {
        return RuntimeContext.getInstance(RuntimeLib.Perl, this.connectionType, this.tcpAddress);
    }

    @Override
    public RuntimeContext ruby() {
        return RuntimeContext.getInstance(RuntimeLib.Ruby, this.connectionType, this.tcpAddress);
    }

    @Override
    public RuntimeContext nodejs() {
        return RuntimeContext.getInstance(RuntimeLib.Nodejs, this.connectionType, this.tcpAddress);
    }

    @Override
    public RuntimeContext python() {
        return RuntimeContext.getInstance(RuntimeLib.Python, this.connectionType, this.tcpAddress);
    }

    public RuntimeContext setEmbeddedRuntime(IEmbeddedRuntime runtime, String path) throws IOException {
        BinariesUnloader.extractBinariesFromJar(runtime.getRuntimeLib());
        byte[] bytes = runtime.getRuntimeBytes();
        JvmTransmitter.deployRuntime(bytes, path, (byte)runtime.getRuntimeVersion());
        JvmTransmitter.setEmbeddedRuntime((byte)runtime.getRuntimeLib().ordinal(), (byte)runtime.getRuntimeVersion(), path);
        return RuntimeContext.getInstance(runtime.getRuntimeLib(), this.connectionType, this.tcpAddress);
    }
}

