# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class FinancialEventGroup(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'financial_event_group_id': 'str',
        'processing_status': 'str',
        'fund_transfer_status': 'str',
        'original_total': 'Currency',
        'converted_total': 'Currency',
        'fund_transfer_date': 'ModelDate',
        'trace_id': 'str',
        'account_tail': 'str',
        'beginning_balance': 'Currency',
        'financial_event_group_start': 'ModelDate',
        'financial_event_group_end': 'ModelDate'
    }

    attribute_map = {
        'financial_event_group_id': 'FinancialEventGroupId',
        'processing_status': 'ProcessingStatus',
        'fund_transfer_status': 'FundTransferStatus',
        'original_total': 'OriginalTotal',
        'converted_total': 'ConvertedTotal',
        'fund_transfer_date': 'FundTransferDate',
        'trace_id': 'TraceId',
        'account_tail': 'AccountTail',
        'beginning_balance': 'BeginningBalance',
        'financial_event_group_start': 'FinancialEventGroupStart',
        'financial_event_group_end': 'FinancialEventGroupEnd'
    }

    def __init__(self, financial_event_group_id=None, processing_status=None, fund_transfer_status=None, original_total=None, converted_total=None, fund_transfer_date=None, trace_id=None, account_tail=None, beginning_balance=None, financial_event_group_start=None, financial_event_group_end=None):  # noqa: E501
        """FinancialEventGroup - a model defined in Swagger"""  # noqa: E501
        self._financial_event_group_id = None
        self._processing_status = None
        self._fund_transfer_status = None
        self._original_total = None
        self._converted_total = None
        self._fund_transfer_date = None
        self._trace_id = None
        self._account_tail = None
        self._beginning_balance = None
        self._financial_event_group_start = None
        self._financial_event_group_end = None
        self.discriminator = None
        if financial_event_group_id is not None:
            self.financial_event_group_id = financial_event_group_id
        if processing_status is not None:
            self.processing_status = processing_status
        if fund_transfer_status is not None:
            self.fund_transfer_status = fund_transfer_status
        if original_total is not None:
            self.original_total = original_total
        if converted_total is not None:
            self.converted_total = converted_total
        if fund_transfer_date is not None:
            self.fund_transfer_date = fund_transfer_date
        if trace_id is not None:
            self.trace_id = trace_id
        if account_tail is not None:
            self.account_tail = account_tail
        if beginning_balance is not None:
            self.beginning_balance = beginning_balance
        if financial_event_group_start is not None:
            self.financial_event_group_start = financial_event_group_start
        if financial_event_group_end is not None:
            self.financial_event_group_end = financial_event_group_end

    @property
    def financial_event_group_id(self):
        """Gets the financial_event_group_id of this FinancialEventGroup.  # noqa: E501

        A unique identifier for the financial event group.  # noqa: E501

        :return: The financial_event_group_id of this FinancialEventGroup.  # noqa: E501
        :rtype: str
        """
        return self._financial_event_group_id

    @financial_event_group_id.setter
    def financial_event_group_id(self, financial_event_group_id):
        """Sets the financial_event_group_id of this FinancialEventGroup.

        A unique identifier for the financial event group.  # noqa: E501

        :param financial_event_group_id: The financial_event_group_id of this FinancialEventGroup.  # noqa: E501
        :type: str
        """

        self._financial_event_group_id = financial_event_group_id

    @property
    def processing_status(self):
        """Gets the processing_status of this FinancialEventGroup.  # noqa: E501

        The processing status of the financial event group indicates whether the balance of the financial event group is settled.  Possible values:  * Open  * Closed  # noqa: E501

        :return: The processing_status of this FinancialEventGroup.  # noqa: E501
        :rtype: str
        """
        return self._processing_status

    @processing_status.setter
    def processing_status(self, processing_status):
        """Sets the processing_status of this FinancialEventGroup.

        The processing status of the financial event group indicates whether the balance of the financial event group is settled.  Possible values:  * Open  * Closed  # noqa: E501

        :param processing_status: The processing_status of this FinancialEventGroup.  # noqa: E501
        :type: str
        """

        self._processing_status = processing_status

    @property
    def fund_transfer_status(self):
        """Gets the fund_transfer_status of this FinancialEventGroup.  # noqa: E501

        The status of the fund transfer.  # noqa: E501

        :return: The fund_transfer_status of this FinancialEventGroup.  # noqa: E501
        :rtype: str
        """
        return self._fund_transfer_status

    @fund_transfer_status.setter
    def fund_transfer_status(self, fund_transfer_status):
        """Sets the fund_transfer_status of this FinancialEventGroup.

        The status of the fund transfer.  # noqa: E501

        :param fund_transfer_status: The fund_transfer_status of this FinancialEventGroup.  # noqa: E501
        :type: str
        """

        self._fund_transfer_status = fund_transfer_status

    @property
    def original_total(self):
        """Gets the original_total of this FinancialEventGroup.  # noqa: E501


        :return: The original_total of this FinancialEventGroup.  # noqa: E501
        :rtype: Currency
        """
        return self._original_total

    @original_total.setter
    def original_total(self, original_total):
        """Sets the original_total of this FinancialEventGroup.


        :param original_total: The original_total of this FinancialEventGroup.  # noqa: E501
        :type: Currency
        """

        self._original_total = original_total

    @property
    def converted_total(self):
        """Gets the converted_total of this FinancialEventGroup.  # noqa: E501


        :return: The converted_total of this FinancialEventGroup.  # noqa: E501
        :rtype: Currency
        """
        return self._converted_total

    @converted_total.setter
    def converted_total(self, converted_total):
        """Sets the converted_total of this FinancialEventGroup.


        :param converted_total: The converted_total of this FinancialEventGroup.  # noqa: E501
        :type: Currency
        """

        self._converted_total = converted_total

    @property
    def fund_transfer_date(self):
        """Gets the fund_transfer_date of this FinancialEventGroup.  # noqa: E501


        :return: The fund_transfer_date of this FinancialEventGroup.  # noqa: E501
        :rtype: ModelDate
        """
        return self._fund_transfer_date

    @fund_transfer_date.setter
    def fund_transfer_date(self, fund_transfer_date):
        """Sets the fund_transfer_date of this FinancialEventGroup.


        :param fund_transfer_date: The fund_transfer_date of this FinancialEventGroup.  # noqa: E501
        :type: ModelDate
        """

        self._fund_transfer_date = fund_transfer_date

    @property
    def trace_id(self):
        """Gets the trace_id of this FinancialEventGroup.  # noqa: E501

        The trace identifier used by sellers to look up transactions externally.  # noqa: E501

        :return: The trace_id of this FinancialEventGroup.  # noqa: E501
        :rtype: str
        """
        return self._trace_id

    @trace_id.setter
    def trace_id(self, trace_id):
        """Sets the trace_id of this FinancialEventGroup.

        The trace identifier used by sellers to look up transactions externally.  # noqa: E501

        :param trace_id: The trace_id of this FinancialEventGroup.  # noqa: E501
        :type: str
        """

        self._trace_id = trace_id

    @property
    def account_tail(self):
        """Gets the account_tail of this FinancialEventGroup.  # noqa: E501

        The account tail of the payment instrument.  # noqa: E501

        :return: The account_tail of this FinancialEventGroup.  # noqa: E501
        :rtype: str
        """
        return self._account_tail

    @account_tail.setter
    def account_tail(self, account_tail):
        """Sets the account_tail of this FinancialEventGroup.

        The account tail of the payment instrument.  # noqa: E501

        :param account_tail: The account_tail of this FinancialEventGroup.  # noqa: E501
        :type: str
        """

        self._account_tail = account_tail

    @property
    def beginning_balance(self):
        """Gets the beginning_balance of this FinancialEventGroup.  # noqa: E501


        :return: The beginning_balance of this FinancialEventGroup.  # noqa: E501
        :rtype: Currency
        """
        return self._beginning_balance

    @beginning_balance.setter
    def beginning_balance(self, beginning_balance):
        """Sets the beginning_balance of this FinancialEventGroup.


        :param beginning_balance: The beginning_balance of this FinancialEventGroup.  # noqa: E501
        :type: Currency
        """

        self._beginning_balance = beginning_balance

    @property
    def financial_event_group_start(self):
        """Gets the financial_event_group_start of this FinancialEventGroup.  # noqa: E501


        :return: The financial_event_group_start of this FinancialEventGroup.  # noqa: E501
        :rtype: ModelDate
        """
        return self._financial_event_group_start

    @financial_event_group_start.setter
    def financial_event_group_start(self, financial_event_group_start):
        """Sets the financial_event_group_start of this FinancialEventGroup.


        :param financial_event_group_start: The financial_event_group_start of this FinancialEventGroup.  # noqa: E501
        :type: ModelDate
        """

        self._financial_event_group_start = financial_event_group_start

    @property
    def financial_event_group_end(self):
        """Gets the financial_event_group_end of this FinancialEventGroup.  # noqa: E501


        :return: The financial_event_group_end of this FinancialEventGroup.  # noqa: E501
        :rtype: ModelDate
        """
        return self._financial_event_group_end

    @financial_event_group_end.setter
    def financial_event_group_end(self, financial_event_group_end):
        """Sets the financial_event_group_end of this FinancialEventGroup.


        :param financial_event_group_end: The financial_event_group_end of this FinancialEventGroup.  # noqa: E501
        :type: ModelDate
        """

        self._financial_event_group_end = financial_event_group_end

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FinancialEventGroup, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FinancialEventGroup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
