import { CommonAwsActionProps, IStage, ActionBindOptions, ActionConfig } from '@aws-cdk/aws-codepipeline';
import { Action } from '@aws-cdk/aws-codepipeline-actions';
import { IRole } from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/core';
export interface RegExp {
    readonly source: string;
}
export interface CommonCodePipelineCheckParameterActionProps extends CommonAwsActionProps {
    /**
     * The name of the parameter.
     */
    readonly parameterName: string;
    /**
     * Parameter is logged after successful check.
     *
     * @default false The parameter is not logged
     */
    readonly logParameter?: boolean;
    /**
     * Role for crossAccount permission.
     */
    readonly crossAccountRole?: IRole;
}
export interface CodePipelineCheckParameterActionProps extends CommonCodePipelineCheckParameterActionProps {
    /**
     * Regular expression to validate the parameter.
     */
    readonly regExp?: RegExp;
}
/**
 * Represents a reference to a CodePipelineCheckParameterAction.
 */
export declare class CodePipelineCheckParameterAction extends Action {
    private readonly props;
    constructor(props: CodePipelineCheckParameterActionProps);
    /**
     * The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     */
    protected bound(scope: Construct, _stage: IStage, options: ActionBindOptions): ActionConfig;
}
