# 8.0 {: #\8.0}

## Overview

In general, there are a couple things to be aware of when upgrading to 8.0.

- Some previously deprecated features are now removed: tabbed code blocks via SuperFences and ExtraRawHTML. These were
  originally deprecated as they are now redundant, and information is provided to allow you to get the same behavior
  as before.

- One of the most invasive changes was adding the support of defining arbitrary attributes on code blocks in SuperFences
  via the brace header format. This caused numerous changes that affects those who define their own custom fences. If
  you are only using the builtin fences provided by SuperFences, you will likely notice no adverse affects, but will be
  able to take advantage of new the new features being offered.

## Better Support for JS Highlighters

- SuperFences adds the ability, when using the brace header format (` ```{.lang .class #id attr=value} `) to add
  arbitrary HTML attributes to code blocks. By default, all classes, IDs and and attributes are added to the `code`
  block of the generated output. The one exception is that the default `highlight` class is always added to the top
  level element.

    For instance, if a user needed to specify that a line number starts with an attribute `data-linenum-start`, they
    could simply use the brace header format to define this new attribute:

    ````
    ```{.python data-linenum-start="30"}
    import sys
    ```
    ````

    Attributes will only be used when Python Markdown's [`attr_list`][attr-list] extension is enabled. Attributes will
    also be ignored when using Pygments as Pygments doesn't directly support adding IDs or arbitrary attributes.

    This allows for more extensive configuration when using JavaScript highlighters. Now users can set the appropriate
    attributes to configure line numbers and other highlighter specific features without the Highlight extension getting
    in the way.

- Some JS highlighters may require attributes and classes to be assigned to the `pre` element, so the
  [Highlight](../../extensions/highlight.md) extension has added a new feature called `code_attr_on_pre`. This new
  option will ensure that custom classes, IDs, and attributes are applied to the `pre` element instead.

- By default, JavaScript ready code blocks would normally have the specified language class prefixed with `language-`.
  This follows the HTML 5 specification, but some highlighters may prefer something different. The prefix can now be
  changed with the new [Highlight](../../extensions/highlight.md) option called `language_prefix`.

## Retired Features

- The legacy tab feature has been removed from SuperFences. This does not mean tab support is dead as the
  [Tabbed](../../extensions/tabbed.md) extension actually provides an even more useful, general purpose, solution. It
  was impossible to keep this legacy feature around, in its current implementation, after the restructure of for
  attribute list support, so we decided to officially retire this already deprecated feature.

- ExtraRawHTML has officially been removed. This extension only existed because Python Markdown did not have the feature
  exposed in a manner that allowed you to use it without including all of their "Extra" extension, now that Python
  Markdown has exposed this extension by itself, there is no longer a reason for us expose it via ExtraRawHTML. Please
  use Python Markdown's [`md_in_html`][md-in-html] extension instead to get the same exact functionality.

## Custom Fence Changes

SuperFences made numerous changes so that users who wish not to use Pygments can set arbitrary attributes via the brace
header format so that can more extensively configure their code blocks for JavaScript syntax highlighters. This required
changes to how custom fences were handled.

- Custom fence formatters are now expected to take a new keyword attribute called `attrs`. `attrs` contains a dictionary
  of key/value pairs defining attributes that should be attached to the main block element generated by a given
  formatter. In general, custom formatters *should* handle these, but are not required to.  At the very least, they
  should be updated to take the argument even if they don't do anything with them. Custom fences that do not accept this
  parameter will silently fail. If your custom fence already accepts `**kwargs` (as recommended in the 7.0 release),
  your fence should continue to work even you do not do anything with the attributes. No use and apply the new,
  attributes, you will have to read the `attrs` parameter and set those to one of the elements in your generated HTML.

- Custom fence validators have been updated to handle validation of inputs by assigning valid inputs to either an
  `options` dictionary or an `attrs` dictionary. The new function signature looks like this:
  `#!py3 validator(language, inputs, options, attrs, md):`.

  - `inputs` contains all the parsed key/value pairs and should **never** be modified. `options` should have inputs
    added to it that configure a formatter's features. You should parse, format and assign all inputs that are
    considered options to the `option` dictionary.

  - `attrs` normally would contain copies of any non-option key/value pairs from inputs, unaltered. These would usually
    be applied to HTML elements as attributes.

  - `md` is the `Markdown` class instance and is useful if you want to access meta data or anything else in your
    validator.

    SuperFences will detect if you are using an older validator and should gracefully transition and use the old format,
    but it is strongly recommended to use the new format. If you run into any issues, you are required to update to the
    new format. In a future version, the graceful transition will be removed.

- Since attributes and options are now parsed via the [`attr_list`][attr-list] extension, custom fences can no longer
  allow inputs in the form `key=` (with no value), they must be in the form `key`, `key="value"` or `key=value`. When
  defining an input in the form `key` (with no value), the value will be the `key` name (this is how
  [`attr_list`][attr-list] handles such cases). To specify an empty `key`, please use `key=""`.

- If a custom validator fails, SuperFences will now gracefully handle the error and try the next custom fence in the
  queue. If a custom formatter fails. If you suspect your custom validator is not working, you should add your own debug
  code to your custom fence to verify whether it is failing or not.

- SuperFences will gracefully handle the error and abort processing the fence. If you suspect your custom formatter is
  not working, you should add your own debug code to your custom fence to verify whether it is failing or not.

## New Extension

[SaneHeaders](../../extensions/saneheaders.md) implements Markdown headers more like CommonMark. Headers require a space
after the `#` symbol in order for the line to be treated as a header. This allows you to use
[MagicLink](../../extensions/magiclink.md) issues at the start of a line. See
[SaneHeaders documentation](../../extensions/saneheaders.md) for more information.
