# generated by datamodel-codegen:
#   filename:  v3
#   timestamp: 2022-07-06T09:40:03+00:00

from __future__ import annotations

from datetime import datetime
from typing import Dict, List, Optional

from pydantic import BaseModel, Field

from ... import runtime


class APIResource(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceList(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResource] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1(BaseModel):
    pass


class ListMeta(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReference(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class Patch(BaseModel):
    pass


class Preconditions(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCause(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetails(BaseModel):
    causes: Optional[List[StatusCause]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class Time(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class GroupVersionForDiscovery(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDR(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class APIResourceModel(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model(BaseModel):
    pass


class LabelSelectorRequirement(BaseModel):
    key: str = Field(
        ..., description='key is the label key that the selector applies to.'
    )
    operator: str = Field(
        ...,
        description="operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
    )
    values: Optional[List[str]] = Field(
        None,
        description='values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
    )


class ListMetaModel(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel(BaseModel):
    pass


class PreconditionsModel(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel(BaseModel):
    causes: Optional[List[StatusCauseModel]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class APIResourceModel1(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel1(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel1] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model1(BaseModel):
    pass


class LabelSelectorRequirementModel(BaseModel):
    key: str = Field(
        ..., description='key is the label key that the selector applies to.'
    )
    operator: str = Field(
        ...,
        description="operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
    )
    values: Optional[List[str]] = Field(
        None,
        description='values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
    )


class ListMetaModel1(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel1(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel1(BaseModel):
    pass


class PreconditionsModel1(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel1(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel1(BaseModel):
    causes: Optional[List[StatusCauseModel1]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel1(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class APIResourceModel2(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel2(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel2] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model2(BaseModel):
    pass


class LabelSelectorRequirementModel1(BaseModel):
    key: str = Field(
        ..., description='key is the label key that the selector applies to.'
    )
    operator: str = Field(
        ...,
        description="operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
    )
    values: Optional[List[str]] = Field(
        None,
        description='values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
    )


class ListMetaModel2(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel2(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel2(BaseModel):
    pass


class PreconditionsModel2(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel2(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel2(BaseModel):
    causes: Optional[List[StatusCauseModel2]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel2(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class GroupVersionForDiscoveryModel(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class APIResourceModel3(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel3(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel3] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model3(BaseModel):
    pass


class LabelSelectorRequirementModel2(BaseModel):
    key: str = Field(
        ..., description='key is the label key that the selector applies to.'
    )
    operator: str = Field(
        ...,
        description="operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
    )
    values: Optional[List[str]] = Field(
        None,
        description='values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
    )


class ListMetaModel3(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel3(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel3(BaseModel):
    pass


class PreconditionsModel3(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel3(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel3(BaseModel):
    causes: Optional[List[StatusCauseModel3]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel3(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class GroupVersionForDiscoveryModel1(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel1(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class APIResourceModel4(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel4(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel4] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model4(BaseModel):
    pass


class ListMetaModel4(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel4(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel4(BaseModel):
    pass


class PreconditionsModel4(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel4(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel4(BaseModel):
    causes: Optional[List[StatusCauseModel4]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel4(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class APIResourceModel5(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel5(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel5] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model5(BaseModel):
    pass


class ListMetaModel5(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel5(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel5(BaseModel):
    pass


class PreconditionsModel5(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel5(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel5(BaseModel):
    causes: Optional[List[StatusCauseModel5]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel5(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class APIResourceModel6(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel6(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel6] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model6(BaseModel):
    pass


class LabelSelectorRequirementModel3(BaseModel):
    key: str = Field(
        ..., description='key is the label key that the selector applies to.'
    )
    operator: str = Field(
        ...,
        description="operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
    )
    values: Optional[List[str]] = Field(
        None,
        description='values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
    )


class ListMetaModel6(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel6(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel6(BaseModel):
    pass


class PreconditionsModel6(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel6(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel6(BaseModel):
    causes: Optional[List[StatusCauseModel6]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel6(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class GroupVersionForDiscoveryModel2(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel2(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class GroupVersionForDiscoveryModel3(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel3(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class APIResourceModel7(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel7(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel7] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model7(BaseModel):
    pass


class LabelSelectorRequirementModel4(BaseModel):
    key: str = Field(
        ..., description='key is the label key that the selector applies to.'
    )
    operator: str = Field(
        ...,
        description="operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
    )
    values: Optional[List[str]] = Field(
        None,
        description='values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
    )


class ListMetaModel7(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel7(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel7(BaseModel):
    pass


class PreconditionsModel7(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel7(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel7(BaseModel):
    causes: Optional[List[StatusCauseModel7]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel7(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class APIResourceModel8(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel8(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel8] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model8(BaseModel):
    pass


class ListMetaModel8(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel8(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel8(BaseModel):
    pass


class PreconditionsModel8(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel8(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel8(BaseModel):
    causes: Optional[List[StatusCauseModel8]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel8(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class APIResourceModel9(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel9(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel9] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model9(BaseModel):
    pass


class LabelSelectorRequirementModel5(BaseModel):
    key: str = Field(
        ..., description='key is the label key that the selector applies to.'
    )
    operator: str = Field(
        ...,
        description="operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
    )
    values: Optional[List[str]] = Field(
        None,
        description='values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
    )


class ListMetaModel9(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel9(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel9(BaseModel):
    pass


class PreconditionsModel9(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel9(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel9(BaseModel):
    causes: Optional[List[StatusCauseModel9]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel9(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class GroupVersionForDiscoveryModel4(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel4(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class GroupVersionForDiscoveryModel5(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel5(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class APIResourceModel10(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel10(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel10] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model10(BaseModel):
    pass


class ListMetaModel10(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel10(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel10(BaseModel):
    pass


class PreconditionsModel10(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel10(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel10(BaseModel):
    causes: Optional[List[StatusCauseModel10]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel10(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class GroupVersionForDiscoveryModel6(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel6(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class GroupVersionForDiscoveryModel7(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel7(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class APIResourceModel11(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel11(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel11] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model11(BaseModel):
    pass


class OwnerReferenceModel11(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel11(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class GroupVersionForDiscoveryModel8(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel8(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class APIResourceModel12(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel12(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel12] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model12(BaseModel):
    pass


class ListMetaModel11(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel12(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel11(BaseModel):
    pass


class PreconditionsModel11(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel11(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel11(BaseModel):
    causes: Optional[List[StatusCauseModel11]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel12(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class GroupVersionForDiscoveryModel9(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel9(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class APIResourceModel13(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel13(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel13] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model13(BaseModel):
    pass


class OwnerReferenceModel13(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel13(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class APIResourceModel14(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel14(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel14] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model14(BaseModel):
    pass


class LabelSelectorRequirementModel6(BaseModel):
    key: str = Field(
        ..., description='key is the label key that the selector applies to.'
    )
    operator: str = Field(
        ...,
        description="operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
    )
    values: Optional[List[str]] = Field(
        None,
        description='values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
    )


class ListMetaModel12(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel14(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel12(BaseModel):
    pass


class PreconditionsModel12(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel12(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel12(BaseModel):
    causes: Optional[List[StatusCauseModel12]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel14(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class APIResourceModel15(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel15(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel15] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model15(BaseModel):
    pass


class ListMetaModel13(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class MicroTime(BaseModel):
    __root__: datetime = Field(
        ...,
        description='MicroTime is version of Time with microsecond level precision.',
    )


class OwnerReferenceModel15(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel13(BaseModel):
    pass


class PreconditionsModel13(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel13(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel13(BaseModel):
    causes: Optional[List[StatusCauseModel13]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel15(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class GroupVersionForDiscoveryModel10(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel10(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class GroupVersionForDiscoveryModel11(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel11(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class GroupVersionForDiscoveryModel12(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel12(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class GroupVersionForDiscoveryModel13(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel13(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class GroupVersionForDiscoveryModel14(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel14(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class GroupVersionForDiscoveryModel15(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel15(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class APIResourceModel16(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel16(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel16] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model16(BaseModel):
    pass


class LabelSelectorRequirementModel7(BaseModel):
    key: str = Field(
        ..., description='key is the label key that the selector applies to.'
    )
    operator: str = Field(
        ...,
        description="operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
    )
    values: Optional[List[str]] = Field(
        None,
        description='values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
    )


class ListMetaModel14(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel16(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel14(BaseModel):
    pass


class PreconditionsModel14(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel14(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel14(BaseModel):
    causes: Optional[List[StatusCauseModel14]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel16(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class GroupVersionForDiscoveryModel16(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel16(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class APIResourceModel17(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel17(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel17] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model17(BaseModel):
    pass


class ListMetaModel15(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel17(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel15(BaseModel):
    pass


class PreconditionsModel15(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel15(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel15(BaseModel):
    causes: Optional[List[StatusCauseModel15]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel17(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class APIResourceModel18(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel18(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel18] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model18(BaseModel):
    pass


class LabelSelectorRequirementModel8(BaseModel):
    key: str = Field(
        ..., description='key is the label key that the selector applies to.'
    )
    operator: str = Field(
        ...,
        description="operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
    )
    values: Optional[List[str]] = Field(
        None,
        description='values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
    )


class ListMetaModel16(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class MicroTimeModel(BaseModel):
    __root__: datetime = Field(
        ...,
        description='MicroTime is version of Time with microsecond level precision.',
    )


class OwnerReferenceModel18(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel16(BaseModel):
    pass


class PreconditionsModel16(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel16(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel16(BaseModel):
    causes: Optional[List[StatusCauseModel16]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel18(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class APIResourceModel19(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel19(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel19] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model19(BaseModel):
    pass


class ListMetaModel17(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class MicroTimeModel1(BaseModel):
    __root__: datetime = Field(
        ...,
        description='MicroTime is version of Time with microsecond level precision.',
    )


class OwnerReferenceModel19(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel17(BaseModel):
    pass


class PreconditionsModel17(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel17(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel17(BaseModel):
    causes: Optional[List[StatusCauseModel17]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel19(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class GroupVersionForDiscoveryModel17(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel17(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class APIResourceModel20(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel20(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel20] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model20(BaseModel):
    pass


class ListMetaModel18(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel20(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel18(BaseModel):
    pass


class PreconditionsModel18(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel18(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel18(BaseModel):
    causes: Optional[List[StatusCauseModel18]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel20(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class APIResourceModel21(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel21(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel21] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model21(BaseModel):
    pass


class LabelSelectorRequirementModel9(BaseModel):
    key: str = Field(
        ..., description='key is the label key that the selector applies to.'
    )
    operator: str = Field(
        ...,
        description="operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
    )
    values: Optional[List[str]] = Field(
        None,
        description='values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
    )


class ListMetaModel19(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel21(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel19(BaseModel):
    pass


class PreconditionsModel19(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel19(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel19(BaseModel):
    causes: Optional[List[StatusCauseModel19]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel21(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class APIResourceModel22(BaseModel):
    categories: Optional[List[str]] = Field(
        None,
        description="categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
    )
    group: Optional[str] = Field(
        None,
        description='group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale".',
    )
    kind: str = Field(
        ...,
        description="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
    )
    name: str = Field(..., description='name is the plural name of the resource.')
    namespaced: bool = Field(
        ..., description='namespaced indicates if a resource is namespaced or not.'
    )
    shortNames: Optional[List[str]] = Field(
        None,
        description='shortNames is a list of suggested short names of the resource.',
    )
    singularName: str = Field(
        ...,
        description='singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.',
    )
    storageVersionHash: Optional[str] = Field(
        None,
        description='The hash value of the storage version, the version this resource is converted to when written to the data store. Value must be treated as opaque by clients. Only equality comparison on the value is valid. This is an alpha feature and may change or be removed in the future. The field is populated by the apiserver only if the StorageVersionHash feature gate is enabled. This field will remain optional even if it graduates.',
    )
    verbs: List[str] = Field(
        ...,
        description='verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)',
    )
    version: Optional[str] = Field(
        None,
        description='version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource\'s group)".',
    )


class APIResourceListModel22(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groupVersion: str = Field(
        ...,
        description='groupVersion is the group and version this APIResourceList is for.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    resources: List[APIResourceModel22] = Field(
        ...,
        description='resources contains the name of the resources and if they are namespaced.',
    )


class FieldsV1Model22(BaseModel):
    pass


class ListMetaModel20(BaseModel):
    continue_: Optional[str] = Field(
        None,
        alias='continue',
        description='continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.',
    )
    remainingItemCount: Optional[int] = Field(
        None,
        description='remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description="String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )


class OwnerReferenceModel22(BaseModel):
    apiVersion: str = Field(..., description='API version of the referent.')
    blockOwnerDeletion: Optional[bool] = Field(
        None,
        description='If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion for how the garbage collector interacts with this field and enforces the foreground deletion. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.',
    )
    controller: Optional[bool] = Field(
        None, description='If true, this reference points to the managing controller.'
    )
    kind: str = Field(
        ...,
        description='Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(
        ...,
        description='Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    uid: str = Field(
        ...,
        description='UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class PatchModel20(BaseModel):
    pass


class PreconditionsModel20(BaseModel):
    resourceVersion: Optional[str] = Field(
        None, description='Specifies the target ResourceVersion'
    )
    uid: Optional[str] = Field(None, description='Specifies the target UID.')


class StatusCauseModel20(BaseModel):
    field: Optional[str] = Field(
        None,
        description='The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  "name" - the field "name" on the current resource\n  "items[0].name" - the field "name" on the first array entry in "items"',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the cause of the error.  This field may be presented as-is to a reader.',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of the cause of the error. If this value is empty there is no information available.',
    )


class StatusDetailsModel20(BaseModel):
    causes: Optional[List[StatusCauseModel20]] = Field(
        None,
        description='The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.',
    )
    group: Optional[str] = Field(
        None,
        description='The group attribute of the resource associated with the status StatusReason.',
    )
    kind: Optional[str] = Field(
        None,
        description='The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: Optional[str] = Field(
        None,
        description='The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).',
    )
    retryAfterSeconds: Optional[int] = Field(
        None,
        description='If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class TimeModel22(BaseModel):
    __root__: datetime = Field(
        ...,
        description='Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.',
    )


class GroupVersionForDiscoveryModel18(BaseModel):
    groupVersion: str = Field(
        ...,
        description='groupVersion specifies the API group and version in the form "group/version"',
    )
    version: str = Field(
        ...,
        description='version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion.',
    )


class ServerAddressByClientCIDRModel18(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class ServerAddressByClientCIDRModel19(BaseModel):
    clientCIDR: str = Field(
        ...,
        description='The CIDR with which clients can match their IP to figure out the server address that they should use.',
    )
    serverAddress: str = Field(
        ...,
        description='Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.',
    )


class DeleteOptions(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[Preconditions] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class ManagedFieldsEntry(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[Time] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMeta(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[Time] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[Time] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntry]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReference]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class Status(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetails] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMeta] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEvent(BaseModel):
    object: runtime.RawExtension = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class APIGroup(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscovery] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[List[ServerAddressByClientCIDR]] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscovery] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class DeleteOptionsModel(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class LabelSelector(BaseModel):
    matchExpressions: Optional[List[LabelSelectorRequirement]] = Field(
        None,
        description='matchExpressions is a list of label selector requirements. The requirements are ANDed.',
    )
    matchLabels: Optional[Dict[str, str]] = Field(
        None,
        description='matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
    )


class ManagedFieldsEntryModel(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel(BaseModel):
    object: runtime.RawExtensionModel = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class DeleteOptionsModel1(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel1] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class LabelSelectorModel(BaseModel):
    matchExpressions: Optional[List[LabelSelectorRequirementModel]] = Field(
        None,
        description='matchExpressions is a list of label selector requirements. The requirements are ANDed.',
    )
    matchLabels: Optional[Dict[str, str]] = Field(
        None,
        description='matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
    )


class ManagedFieldsEntryModel1(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model1] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel1] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel1(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel1] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel1] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel1]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel1]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel1(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel1] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel1] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel1(BaseModel):
    object: runtime.RawExtensionModel1 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class Condition(BaseModel):
    lastTransitionTime: TimeModel2 = Field(
        ...,
        description='lastTransitionTime is the last time the condition transitioned from one status to another. This should be when the underlying condition changed.  If that is not known, then using the time when the API field changed is acceptable.',
    )
    message: str = Field(
        ...,
        description='message is a human readable message indicating details about the transition. This may be an empty string.',
    )
    observedGeneration: Optional[int] = Field(
        None,
        description='observedGeneration represents the .metadata.generation that the condition was set based upon. For instance, if .metadata.generation is currently 12, but the .status.conditions[x].observedGeneration is 9, the condition is out of date with respect to the current state of the instance.',
    )
    reason: str = Field(
        ...,
        description="reason contains a programmatic identifier indicating the reason for the condition's last transition. Producers of specific condition types may define expected values and meanings for this field, and whether the values are considered a guaranteed API. The value should be a CamelCase string. This field may not be empty.",
    )
    status: str = Field(
        ..., description='status of the condition, one of True, False, Unknown.'
    )
    type: str = Field(
        ...,
        description='type of condition in CamelCase or in foo.example.com/CamelCase.',
    )


class DeleteOptionsModel2(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel2] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class LabelSelectorModel1(BaseModel):
    matchExpressions: Optional[List[LabelSelectorRequirementModel1]] = Field(
        None,
        description='matchExpressions is a list of label selector requirements. The requirements are ANDed.',
    )
    matchLabels: Optional[Dict[str, str]] = Field(
        None,
        description='matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
    )


class ManagedFieldsEntryModel2(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model2] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel2] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel2(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel2] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel2] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel2]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel2]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel2(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel2] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel2] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel2(BaseModel):
    object: runtime.RawExtensionModel2 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class APIGroupModel(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[List[ServerAddressByClientCIDRModel]] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class DeleteOptionsModel3(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel3] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class LabelSelectorModel2(BaseModel):
    matchExpressions: Optional[List[LabelSelectorRequirementModel2]] = Field(
        None,
        description='matchExpressions is a list of label selector requirements. The requirements are ANDed.',
    )
    matchLabels: Optional[Dict[str, str]] = Field(
        None,
        description='matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
    )


class ManagedFieldsEntryModel3(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model3] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel3] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel3(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel3] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel3] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel3]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel3]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel3(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel3] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel3] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel3(BaseModel):
    object: runtime.RawExtensionModel3 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class APIGroupModel1(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel1] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[List[ServerAddressByClientCIDRModel1]] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel1] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class DeleteOptionsModel4(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel4] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class ManagedFieldsEntryModel4(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model4] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel4] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel4(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel4] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel4] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel4]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel4]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel4(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel4] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel4] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel4(BaseModel):
    object: runtime.RawExtensionModel4 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class DeleteOptionsModel5(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel5] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class ManagedFieldsEntryModel5(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model5] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel5] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel5(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel5] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel5] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel5]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel5]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel5(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel5] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel5] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel5(BaseModel):
    object: runtime.RawExtensionModel5 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class DeleteOptionsModel6(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel6] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class LabelSelectorModel3(BaseModel):
    matchExpressions: Optional[List[LabelSelectorRequirementModel3]] = Field(
        None,
        description='matchExpressions is a list of label selector requirements. The requirements are ANDed.',
    )
    matchLabels: Optional[Dict[str, str]] = Field(
        None,
        description='matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
    )


class ManagedFieldsEntryModel6(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model6] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel6] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel6(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel6] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel6] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel6]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel6]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel6(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel6] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel6] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel6(BaseModel):
    object: runtime.RawExtensionModel6 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class APIGroupModel2(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel2] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[List[ServerAddressByClientCIDRModel2]] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel2] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class APIGroupModel3(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel3] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[List[ServerAddressByClientCIDRModel3]] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel3] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class APIGroupList(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    groups: List[APIGroupModel3] = Field(
        ..., description='groups is a list of APIGroup.'
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )


class DeleteOptionsModel7(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel7] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class LabelSelectorModel4(BaseModel):
    matchExpressions: Optional[List[LabelSelectorRequirementModel4]] = Field(
        None,
        description='matchExpressions is a list of label selector requirements. The requirements are ANDed.',
    )
    matchLabels: Optional[Dict[str, str]] = Field(
        None,
        description='matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
    )


class ManagedFieldsEntryModel7(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model7] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel7] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel7(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel7] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel7] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel7]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel7]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel7(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel7] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel7] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel7(BaseModel):
    object: runtime.RawExtensionModel7 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class DeleteOptionsModel8(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel8] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class ManagedFieldsEntryModel8(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model8] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel8] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel8(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel8] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel8] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel8]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel8]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel8(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel8] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel8] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel8(BaseModel):
    object: runtime.RawExtensionModel8 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class DeleteOptionsModel9(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel9] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class LabelSelectorModel5(BaseModel):
    matchExpressions: Optional[List[LabelSelectorRequirementModel5]] = Field(
        None,
        description='matchExpressions is a list of label selector requirements. The requirements are ANDed.',
    )
    matchLabels: Optional[Dict[str, str]] = Field(
        None,
        description='matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
    )


class ManagedFieldsEntryModel9(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model9] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel9] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel9(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel9] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel9] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel9]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel9]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel9(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel9] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel9] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel9(BaseModel):
    object: runtime.RawExtensionModel9 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class APIGroupModel4(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel4] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[List[ServerAddressByClientCIDRModel4]] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel4] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class APIGroupModel5(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel5] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[List[ServerAddressByClientCIDRModel5]] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel5] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class DeleteOptionsModel10(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel10] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class ManagedFieldsEntryModel10(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model10] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel10] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel10(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel10] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel10] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel10]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel10]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel10(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel10] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel10] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel10(BaseModel):
    object: runtime.RawExtensionModel10 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class APIGroupModel6(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel6] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[List[ServerAddressByClientCIDRModel6]] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel6] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class APIGroupModel7(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel7] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[List[ServerAddressByClientCIDRModel7]] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel7] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class ManagedFieldsEntryModel11(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model11] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel11] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel11(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel11] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel11] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel11]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel11]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class APIGroupModel8(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel8] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[List[ServerAddressByClientCIDRModel8]] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel8] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class DeleteOptionsModel11(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel11] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class ManagedFieldsEntryModel12(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model12] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel12] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel12(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel12] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel12] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel12]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel12]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel11(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel11] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel11] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel11(BaseModel):
    object: runtime.RawExtensionModel11 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class APIGroupModel9(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel9] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[List[ServerAddressByClientCIDRModel9]] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel9] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class ManagedFieldsEntryModel13(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model13] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel13] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel13(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel13] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel13] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel13]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel13]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class DeleteOptionsModel12(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel12] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class LabelSelectorModel6(BaseModel):
    matchExpressions: Optional[List[LabelSelectorRequirementModel6]] = Field(
        None,
        description='matchExpressions is a list of label selector requirements. The requirements are ANDed.',
    )
    matchLabels: Optional[Dict[str, str]] = Field(
        None,
        description='matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
    )


class ManagedFieldsEntryModel14(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model14] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel14] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel14(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel14] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel14] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel14]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel14]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel12(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel12] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel12] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel12(BaseModel):
    object: runtime.RawExtensionModel12 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class DeleteOptionsModel13(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel13] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class ManagedFieldsEntryModel15(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model15] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel15] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel15(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel15] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel15] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel15]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel15]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel13(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel13] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel13] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel13(BaseModel):
    object: runtime.RawExtensionModel13 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class APIGroupModel10(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel10] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[
        List[ServerAddressByClientCIDRModel10]
    ] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel10] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class APIGroupModel11(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel11] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[
        List[ServerAddressByClientCIDRModel11]
    ] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel11] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class APIGroupModel12(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel12] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[
        List[ServerAddressByClientCIDRModel12]
    ] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel12] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class APIGroupModel13(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel13] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[
        List[ServerAddressByClientCIDRModel13]
    ] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel13] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class APIGroupModel14(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel14] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[
        List[ServerAddressByClientCIDRModel14]
    ] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel14] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class APIGroupModel15(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel15] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[
        List[ServerAddressByClientCIDRModel15]
    ] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel15] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class ConditionModel(BaseModel):
    lastTransitionTime: TimeModel16 = Field(
        ...,
        description='lastTransitionTime is the last time the condition transitioned from one status to another. This should be when the underlying condition changed.  If that is not known, then using the time when the API field changed is acceptable.',
    )
    message: str = Field(
        ...,
        description='message is a human readable message indicating details about the transition. This may be an empty string.',
    )
    observedGeneration: Optional[int] = Field(
        None,
        description='observedGeneration represents the .metadata.generation that the condition was set based upon. For instance, if .metadata.generation is currently 12, but the .status.conditions[x].observedGeneration is 9, the condition is out of date with respect to the current state of the instance.',
    )
    reason: str = Field(
        ...,
        description="reason contains a programmatic identifier indicating the reason for the condition's last transition. Producers of specific condition types may define expected values and meanings for this field, and whether the values are considered a guaranteed API. The value should be a CamelCase string. This field may not be empty.",
    )
    status: str = Field(
        ..., description='status of the condition, one of True, False, Unknown.'
    )
    type: str = Field(
        ...,
        description='type of condition in CamelCase or in foo.example.com/CamelCase.',
    )


class DeleteOptionsModel14(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel14] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class LabelSelectorModel7(BaseModel):
    matchExpressions: Optional[List[LabelSelectorRequirementModel7]] = Field(
        None,
        description='matchExpressions is a list of label selector requirements. The requirements are ANDed.',
    )
    matchLabels: Optional[Dict[str, str]] = Field(
        None,
        description='matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
    )


class ManagedFieldsEntryModel16(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model16] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel16] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel16(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel16] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel16] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel16]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel16]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel14(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel14] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel14] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel14(BaseModel):
    object: runtime.RawExtensionModel14 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class APIGroupModel16(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel16] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[
        List[ServerAddressByClientCIDRModel16]
    ] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel16] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class DeleteOptionsModel15(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel15] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class ManagedFieldsEntryModel17(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model17] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel17] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel17(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel17] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel17] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel17]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel17]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel15(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel15] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel15] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel15(BaseModel):
    object: runtime.RawExtensionModel15 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class ConditionModel1(BaseModel):
    lastTransitionTime: TimeModel18 = Field(
        ...,
        description='lastTransitionTime is the last time the condition transitioned from one status to another. This should be when the underlying condition changed.  If that is not known, then using the time when the API field changed is acceptable.',
    )
    message: str = Field(
        ...,
        description='message is a human readable message indicating details about the transition. This may be an empty string.',
    )
    observedGeneration: Optional[int] = Field(
        None,
        description='observedGeneration represents the .metadata.generation that the condition was set based upon. For instance, if .metadata.generation is currently 12, but the .status.conditions[x].observedGeneration is 9, the condition is out of date with respect to the current state of the instance.',
    )
    reason: str = Field(
        ...,
        description="reason contains a programmatic identifier indicating the reason for the condition's last transition. Producers of specific condition types may define expected values and meanings for this field, and whether the values are considered a guaranteed API. The value should be a CamelCase string. This field may not be empty.",
    )
    status: str = Field(
        ..., description='status of the condition, one of True, False, Unknown.'
    )
    type: str = Field(
        ...,
        description='type of condition in CamelCase or in foo.example.com/CamelCase.',
    )


class DeleteOptionsModel16(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel16] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class LabelSelectorModel8(BaseModel):
    matchExpressions: Optional[List[LabelSelectorRequirementModel8]] = Field(
        None,
        description='matchExpressions is a list of label selector requirements. The requirements are ANDed.',
    )
    matchLabels: Optional[Dict[str, str]] = Field(
        None,
        description='matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
    )


class ManagedFieldsEntryModel18(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model18] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel18] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel18(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel18] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel18] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel18]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel18]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel16(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel16] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel16] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel16(BaseModel):
    object: runtime.RawExtensionModel16 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class DeleteOptionsModel17(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel17] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class ManagedFieldsEntryModel19(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model19] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel19] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel19(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel19] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel19] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel19]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel19]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel17(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel17] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel17] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel17(BaseModel):
    object: runtime.RawExtensionModel17 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class APIGroupModel17(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel17] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[
        List[ServerAddressByClientCIDRModel17]
    ] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel17] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class DeleteOptionsModel18(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel18] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class ManagedFieldsEntryModel20(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model20] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel20] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel20(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel20] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel20] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel20]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel20]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel18(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel18] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel18] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel18(BaseModel):
    object: runtime.RawExtensionModel18 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class DeleteOptionsModel19(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel19] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class LabelSelectorModel9(BaseModel):
    matchExpressions: Optional[List[LabelSelectorRequirementModel9]] = Field(
        None,
        description='matchExpressions is a list of label selector requirements. The requirements are ANDed.',
    )
    matchLabels: Optional[Dict[str, str]] = Field(
        None,
        description='matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
    )


class ManagedFieldsEntryModel21(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model21] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel21] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel21(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel21] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel21] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel21]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel21]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel19(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel19] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel19] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel19(BaseModel):
    object: runtime.RawExtensionModel19 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class DeleteOptionsModel20(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    dryRun: Optional[List[str]] = Field(
        None,
        description='When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed',
    )
    gracePeriodSeconds: Optional[int] = Field(
        None,
        description='The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    orphanDependents: Optional[bool] = Field(
        None,
        description='Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object\'s finalizers list. Either this field or PropagationPolicy may be set, but not both.',
    )
    preconditions: Optional[PreconditionsModel20] = Field(
        None,
        description='Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.',
    )
    propagationPolicy: Optional[str] = Field(
        None,
        description="Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.",
    )


class ManagedFieldsEntryModel22(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.',
    )
    fieldsType: Optional[str] = Field(
        None,
        description='FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1"',
    )
    fieldsV1: Optional[FieldsV1Model22] = Field(
        None,
        description='FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.',
    )
    manager: Optional[str] = Field(
        None,
        description='Manager is an identifier of the workflow managing these fields.',
    )
    operation: Optional[str] = Field(
        None,
        description="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.",
    )
    subresource: Optional[str] = Field(
        None,
        description='Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.',
    )
    time: Optional[TimeModel22] = Field(
        None,
        description='Time is the timestamp of when the ManagedFields entry was added. The timestamp will also be updated if a field is added, the manager changes any of the owned fields value or removes a field. The timestamp does not update when a field is removed from the entry because another manager took it over.',
    )


class ObjectMetaModel22(BaseModel):
    annotations: Optional[Dict[str, str]] = Field(
        None,
        description='Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations',
    )
    creationTimestamp: Optional[TimeModel22] = Field(
        {},
        description='CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    deletionGracePeriodSeconds: Optional[int] = Field(
        None,
        description='Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.',
    )
    deletionTimestamp: Optional[TimeModel22] = Field(
        None,
        description='DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata',
    )
    finalizers: Optional[List[str]] = Field(
        None,
        description='Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.',
    )
    generateName: Optional[str] = Field(
        None,
        description='GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will return a 409.\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency',
    )
    generation: Optional[int] = Field(
        None,
        description='A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.',
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels',
    )
    managedFields: Optional[List[ManagedFieldsEntryModel22]] = Field(
        None,
        description='ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn\'t need to set or understand this field. A workflow can be the user\'s name, a controller\'s name, or the name of a specific apply path like "ci-cd". The set of fields is always in the version that the workflow used when modifying the object.',
    )
    name: Optional[str] = Field(
        None,
        description='Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names',
    )
    namespace: Optional[str] = Field(
        None,
        description='Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the "default" namespace, but "default" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces',
    )
    ownerReferences: Optional[List[OwnerReferenceModel22]] = Field(
        None,
        description='List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.',
    )
    resourceVersion: Optional[str] = Field(
        None,
        description='An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency',
    )
    selfLink: Optional[str] = Field(
        None,
        description='Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.',
    )
    uid: Optional[str] = Field(
        None,
        description='UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids',
    )


class StatusModel20(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    code: Optional[int] = Field(
        None, description='Suggested HTTP return code for this status, 0 if not set.'
    )
    details: Optional[StatusDetailsModel20] = Field(
        None,
        description='Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable description of the status of this operation.',
    )
    metadata: Optional[ListMetaModel20] = Field(
        {},
        description='Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    reason: Optional[str] = Field(
        None,
        description='A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.',
    )
    status: Optional[str] = Field(
        None,
        description='Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status',
    )


class WatchEventModel20(BaseModel):
    object: runtime.RawExtensionModel20 = Field(
        ...,
        description='Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.',
    )
    type: str


class APIGroupModel18(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    name: str = Field(..., description='name is the name of the group.')
    preferredVersion: Optional[GroupVersionForDiscoveryModel18] = Field(
        {},
        description='preferredVersion is the version preferred by the API server, which probably is the storage version.',
    )
    serverAddressByClientCIDRs: Optional[
        List[ServerAddressByClientCIDRModel18]
    ] = Field(
        None,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[GroupVersionForDiscoveryModel18] = Field(
        ..., description='versions are the versions supported in this group.'
    )


class APIVersions(BaseModel):
    apiVersion: Optional[str] = Field(
        None,
        description='APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
    )
    kind: Optional[str] = Field(
        None,
        description='Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
    )
    serverAddressByClientCIDRs: List[ServerAddressByClientCIDRModel19] = Field(
        ...,
        description='a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.',
    )
    versions: List[str] = Field(
        ..., description='versions are the api versions that are available.'
    )
