import cdk = require('@aws-cdk/core');
import { Base, LambdaProps, Props } from './base';
/**
 * Props for Athena Migrations.
 *
 * @stability stable
 */
export interface AthenaProps extends Props {
    /**
     * Athena WorkGroup to run the migration in.
     *
     * @default - primary
     * @stability stable
     */
    readonly workGroup?: string;
}
/**
 * Defines a new DB Migration for Athena.
 *
 * @stability stable
 */
export declare class Athena extends Base {
    /**
     * Defines a new DB Migration.
     *
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: AthenaProps);
    /**
     * @stability stable
     */
    protected makeType(): string;
    /**
     * @stability stable
     */
    protected makeProperties(props: Props): LambdaProps;
}
