import iam = require('@aws-cdk/aws-iam');
import lambda = require('@aws-cdk/aws-lambda');
import cdk = require('@aws-cdk/core');
/**
 * @stability stable
 */
export interface LambdaProps {
    [key: string]: String;
}
/**
 * Manages Database Migration.
 *
 * @stability stable
 */
export interface Props extends cdk.StackProps {
    /**
     * Migration to apply, when the resource is created.
     *
     * @stability stable
     */
    readonly up: string;
    /**
     * Migration to apply, when the resource is deleted.
     *
     * @stability stable
     */
    readonly down: string;
    /**
     * One or more cdk constructs the migration depends on.
     *
     * @stability stable
     */
    readonly dependsOn?: cdk.Construct | cdk.Construct[];
    /**
     * Timeout of the lambda function, which is used to run the migrations.
     *
     * @default - 30 seconds
     * @stability stable
     */
    readonly timeout?: cdk.Duration;
}
/**
 * Defines a new DB Migration.
 *
 * @stability stable
 */
export declare class Base extends cdk.Construct {
    /**
     * The lambda function which backs the custom resource.
     *
     * @stability stable
     */
    readonly lambda: lambda.IFunction;
    /**
     * The IAM role, used by the lambda function which backs the custom resource.
     *
     * @stability stable
     */
    readonly role: iam.Role;
    /**
     * Migration to apply, when the resource is deleted.
     *
     * @stability stable
     */
    readonly up: string;
    /**
     * Migration to apply, when the resource is deleted.
     *
     * @stability stable
     */
    readonly down: string;
    /**
     * Defines a new DB Migration.
     *
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: Props);
    /**
     * @stability stable
     */
    protected makeProperties(_: Props): LambdaProps;
    /**
     * @stability stable
     */
    protected makeType(): string;
}
