"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Base = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const lambda_1 = require("./lambda");
const resourceType = 'Custom::DB-Migration';
/**
 * Defines a new DB Migration.
 *
 * @stability stable
 */
class Base extends cdk.Construct {
    /**
     * Defines a new DB Migration.
     *
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const lambdaResources = lambda_1.ensureLambda(this);
        this.lambda = lambdaResources.function;
        this.role = lambdaResources.role;
        this.up = props.up.trim();
        this.down = props.down.trim();
        const queryProps = {
            serviceToken: this.lambda.functionArn,
            resourceType: `${resourceType}-${this.makeType()}`,
            properties: this.makeProperties(props),
        };
        const query = new cdk.CustomResource(this, `DbMigration${id}`, queryProps);
        if (typeof props.dependsOn !== 'undefined') {
            if (Array.isArray(props.dependsOn)) {
                query.node.addDependency(...props.dependsOn);
            }
            else {
                query.node.addDependency(props.dependsOn);
            }
        }
    }
    /**
     * @stability stable
     */
    makeProperties(_) {
        return {
            Up: this.up,
            Down: this.down,
        };
    }
    /**
     * @stability stable
     */
    makeType() {
        return 'Base';
    }
}
exports.Base = Base;
_a = JSII_RTTI_SYMBOL_1;
Base[_a] = { fqn: "cdk-db-migration.Base", version: "1.0.0" };
//# sourceMappingURL=data:application/json;base64,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