# Generated by Django 3.1.8 on 2021-07-20 13:34

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('django_workflow_system', '0004_auto_20210701_0910'),
    ]

    operations = [
        migrations.CreateModel(
            name='WorkflowCollectionDependency',
            fields=[
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('source', models.ForeignKey(help_text='The collection for which we want to create a dependency.', on_delete=django.db.models.deletion.PROTECT, related_name='source_workflow_collection', to='django_workflow_system.workflowcollection')),
                ('target', models.ForeignKey(help_text="The collection which we want to require be completed before the user can create engagements for the 'source' collection.", on_delete=django.db.models.deletion.PROTECT, related_name='target_workflow_collection', to='django_workflow_system.workflowcollection')),
            ],
            options={
                'verbose_name_plural': 'Workflow Collection Dependencies',
                'db_table': 'workflow_collection_dependency',
                'unique_together': {('source', 'target')},
            },
        ),
        migrations.AddField(
            model_name='workflowcollection',
            name='collection_dependencies',
            field=models.ManyToManyField(blank=True, help_text='Specify which collections a user must complete before accessing this Collection.', through='django_workflow_system.WorkflowCollectionDependency', to='django_workflow_system.WorkflowCollection'),
        ),
    ]
