# readarr-py
Readarr API docs

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

[comment]: # (x-release-please-start-version)
- Package version: 0.2.1

[comment]: # (x-release-please-end)
- API version: 0.1.0

- Build package: org.openapitools.codegen.languages.PythonNextgenClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/devopsarr/readarr-py.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/devopsarr/readarr-py.git`)

Then import the package:
```python
import readarr
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import readarr
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import readarr
from readarr.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = readarr.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with readarr.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = readarr.AuthenticationApi(api_client)
    return_url = 'return_url_example' # str |  (optional)
    username = 'username_example' # str |  (optional)
    password = 'password_example' # str |  (optional)
    remember_me = 'remember_me_example' # str |  (optional)

    try:
        api_instance.create_login(return_url=return_url, username=username, password=password, remember_me=remember_me)
    except ApiException as e:
        print("Exception when calling AuthenticationApi->create_login: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**create_login**](docs/AuthenticationApi.md#create_login) | **POST** /login | 
*AuthenticationApi* | [**get_logout**](docs/AuthenticationApi.md#get_logout) | **GET** /logout | 
*AuthorApi* | [**create_author**](docs/AuthorApi.md#create_author) | **POST** /api/v1/author | 
*AuthorApi* | [**delete_author**](docs/AuthorApi.md#delete_author) | **DELETE** /api/v1/author/{id} | 
*AuthorApi* | [**get_author_by_id**](docs/AuthorApi.md#get_author_by_id) | **GET** /api/v1/author/{id} | 
*AuthorApi* | [**list_author**](docs/AuthorApi.md#list_author) | **GET** /api/v1/author | 
*AuthorApi* | [**update_author**](docs/AuthorApi.md#update_author) | **PUT** /api/v1/author/{id} | 
*AuthorEditorApi* | [**delete_author_editor**](docs/AuthorEditorApi.md#delete_author_editor) | **DELETE** /api/v1/author/editor | 
*AuthorEditorApi* | [**put_author_editor**](docs/AuthorEditorApi.md#put_author_editor) | **PUT** /api/v1/author/editor | 
*AuthorLookupApi* | [**get_author_lookup**](docs/AuthorLookupApi.md#get_author_lookup) | **GET** /api/v1/author/lookup | 
*BackupApi* | [**create_system_backup_restore_by_id**](docs/BackupApi.md#create_system_backup_restore_by_id) | **POST** /api/v1/system/backup/restore/{id} | 
*BackupApi* | [**create_system_backup_restore_upload**](docs/BackupApi.md#create_system_backup_restore_upload) | **POST** /api/v1/system/backup/restore/upload | 
*BackupApi* | [**delete_system_backup**](docs/BackupApi.md#delete_system_backup) | **DELETE** /api/v1/system/backup/{id} | 
*BackupApi* | [**list_system_backup**](docs/BackupApi.md#list_system_backup) | **GET** /api/v1/system/backup | 
*BlacklistApi* | [**delete_blacklist**](docs/BlacklistApi.md#delete_blacklist) | **DELETE** /api/v1/blacklist/{id} | 
*BlacklistApi* | [**delete_blacklist_bulk**](docs/BlacklistApi.md#delete_blacklist_bulk) | **DELETE** /api/v1/blacklist/bulk | 
*BlacklistApi* | [**get_blacklist**](docs/BlacklistApi.md#get_blacklist) | **GET** /api/v1/blacklist | 
*BookApi* | [**create_book**](docs/BookApi.md#create_book) | **POST** /api/v1/book | 
*BookApi* | [**delete_book**](docs/BookApi.md#delete_book) | **DELETE** /api/v1/book/{id} | 
*BookApi* | [**get_book_by_id**](docs/BookApi.md#get_book_by_id) | **GET** /api/v1/book/{id} | 
*BookApi* | [**list_book**](docs/BookApi.md#list_book) | **GET** /api/v1/book | 
*BookApi* | [**put_book_monitor**](docs/BookApi.md#put_book_monitor) | **PUT** /api/v1/book/monitor | 
*BookApi* | [**update_book**](docs/BookApi.md#update_book) | **PUT** /api/v1/book/{id} | 
*BookFileApi* | [**delete_book_file**](docs/BookFileApi.md#delete_book_file) | **DELETE** /api/v1/bookfile/{id} | 
*BookFileApi* | [**delete_book_file_bulk**](docs/BookFileApi.md#delete_book_file_bulk) | **DELETE** /api/v1/bookfile/bulk | 
*BookFileApi* | [**get_book_file_by_id**](docs/BookFileApi.md#get_book_file_by_id) | **GET** /api/v1/bookfile/{id} | 
*BookFileApi* | [**list_book_file**](docs/BookFileApi.md#list_book_file) | **GET** /api/v1/bookfile | 
*BookFileApi* | [**put_book_file_editor**](docs/BookFileApi.md#put_book_file_editor) | **PUT** /api/v1/bookfile/editor | 
*BookFileApi* | [**update_book_file**](docs/BookFileApi.md#update_book_file) | **PUT** /api/v1/bookfile/{id} | 
*BookLookupApi* | [**get_book_lookup**](docs/BookLookupApi.md#get_book_lookup) | **GET** /api/v1/book/lookup | 
*BookshelfApi* | [**create_bookshelf**](docs/BookshelfApi.md#create_bookshelf) | **POST** /api/v1/bookshelf | 
*CalendarApi* | [**get_calendar_by_id**](docs/CalendarApi.md#get_calendar_by_id) | **GET** /api/v1/calendar/{id} | 
*CalendarApi* | [**list_calendar**](docs/CalendarApi.md#list_calendar) | **GET** /api/v1/calendar | 
*CalendarFeedApi* | [**get_calendar_readarr_ics**](docs/CalendarFeedApi.md#get_calendar_readarr_ics) | **GET** /api/v1/calendar/readarr.ics | 
*CommandApi* | [**create_command**](docs/CommandApi.md#create_command) | **POST** /api/v1/command | 
*CommandApi* | [**delete_command**](docs/CommandApi.md#delete_command) | **DELETE** /api/v1/command/{id} | 
*CommandApi* | [**get_command_by_id**](docs/CommandApi.md#get_command_by_id) | **GET** /api/v1/command/{id} | 
*CommandApi* | [**list_command**](docs/CommandApi.md#list_command) | **GET** /api/v1/command | 
*CustomFilterApi* | [**create_custom_filter**](docs/CustomFilterApi.md#create_custom_filter) | **POST** /api/v1/customfilter | 
*CustomFilterApi* | [**delete_custom_filter**](docs/CustomFilterApi.md#delete_custom_filter) | **DELETE** /api/v1/customfilter/{id} | 
*CustomFilterApi* | [**get_custom_filter_by_id**](docs/CustomFilterApi.md#get_custom_filter_by_id) | **GET** /api/v1/customfilter/{id} | 
*CustomFilterApi* | [**list_custom_filter**](docs/CustomFilterApi.md#list_custom_filter) | **GET** /api/v1/customfilter | 
*CustomFilterApi* | [**update_custom_filter**](docs/CustomFilterApi.md#update_custom_filter) | **PUT** /api/v1/customfilter/{id} | 
*CutoffApi* | [**get_wanted_cutoff**](docs/CutoffApi.md#get_wanted_cutoff) | **GET** /api/v1/wanted/cutoff | 
*CutoffApi* | [**get_wanted_cutoff_by_id**](docs/CutoffApi.md#get_wanted_cutoff_by_id) | **GET** /api/v1/wanted/cutoff/{id} | 
*DelayProfileApi* | [**create_delay_profile**](docs/DelayProfileApi.md#create_delay_profile) | **POST** /api/v1/delayprofile | 
*DelayProfileApi* | [**delete_delay_profile**](docs/DelayProfileApi.md#delete_delay_profile) | **DELETE** /api/v1/delayprofile/{id} | 
*DelayProfileApi* | [**get_delay_profile_by_id**](docs/DelayProfileApi.md#get_delay_profile_by_id) | **GET** /api/v1/delayprofile/{id} | 
*DelayProfileApi* | [**list_delay_profile**](docs/DelayProfileApi.md#list_delay_profile) | **GET** /api/v1/delayprofile | 
*DelayProfileApi* | [**update_delay_profile**](docs/DelayProfileApi.md#update_delay_profile) | **PUT** /api/v1/delayprofile/{id} | 
*DelayProfileApi* | [**update_delay_profile_reorder**](docs/DelayProfileApi.md#update_delay_profile_reorder) | **PUT** /api/v1/delayprofile/reorder/{id} | 
*DevelopmentConfigApi* | [**get_development_config**](docs/DevelopmentConfigApi.md#get_development_config) | **GET** /api/v1/config/development | 
*DevelopmentConfigApi* | [**get_development_config_by_id**](docs/DevelopmentConfigApi.md#get_development_config_by_id) | **GET** /api/v1/config/development/{id} | 
*DevelopmentConfigApi* | [**update_development_config**](docs/DevelopmentConfigApi.md#update_development_config) | **PUT** /api/v1/config/development/{id} | 
*DiskSpaceApi* | [**list_disk_space**](docs/DiskSpaceApi.md#list_disk_space) | **GET** /api/v1/diskspace | 
*DownloadClientApi* | [**create_download_client**](docs/DownloadClientApi.md#create_download_client) | **POST** /api/v1/downloadclient | 
*DownloadClientApi* | [**create_download_client_action_by_name**](docs/DownloadClientApi.md#create_download_client_action_by_name) | **POST** /api/v1/downloadclient/action/{name} | 
*DownloadClientApi* | [**delete_download_client**](docs/DownloadClientApi.md#delete_download_client) | **DELETE** /api/v1/downloadclient/{id} | 
*DownloadClientApi* | [**get_download_client_by_id**](docs/DownloadClientApi.md#get_download_client_by_id) | **GET** /api/v1/downloadclient/{id} | 
*DownloadClientApi* | [**list_download_client**](docs/DownloadClientApi.md#list_download_client) | **GET** /api/v1/downloadclient | 
*DownloadClientApi* | [**list_download_client_schema**](docs/DownloadClientApi.md#list_download_client_schema) | **GET** /api/v1/downloadclient/schema | 
*DownloadClientApi* | [**test_download_client**](docs/DownloadClientApi.md#test_download_client) | **POST** /api/v1/downloadclient/test | 
*DownloadClientApi* | [**testall_download_client**](docs/DownloadClientApi.md#testall_download_client) | **POST** /api/v1/downloadclient/testall | 
*DownloadClientApi* | [**update_download_client**](docs/DownloadClientApi.md#update_download_client) | **PUT** /api/v1/downloadclient/{id} | 
*DownloadClientConfigApi* | [**get_download_client_config**](docs/DownloadClientConfigApi.md#get_download_client_config) | **GET** /api/v1/config/downloadclient | 
*DownloadClientConfigApi* | [**get_download_client_config_by_id**](docs/DownloadClientConfigApi.md#get_download_client_config_by_id) | **GET** /api/v1/config/downloadclient/{id} | 
*DownloadClientConfigApi* | [**update_download_client_config**](docs/DownloadClientConfigApi.md#update_download_client_config) | **PUT** /api/v1/config/downloadclient/{id} | 
*FileSystemApi* | [**get_file_system**](docs/FileSystemApi.md#get_file_system) | **GET** /api/v1/filesystem | 
*FileSystemApi* | [**get_file_system_mediafiles**](docs/FileSystemApi.md#get_file_system_mediafiles) | **GET** /api/v1/filesystem/mediafiles | 
*FileSystemApi* | [**get_file_system_type**](docs/FileSystemApi.md#get_file_system_type) | **GET** /api/v1/filesystem/type | 
*HealthApi* | [**get_health_by_id**](docs/HealthApi.md#get_health_by_id) | **GET** /api/v1/health/{id} | 
*HealthApi* | [**list_health**](docs/HealthApi.md#list_health) | **GET** /api/v1/health | 
*HistoryApi* | [**create_history_failed**](docs/HistoryApi.md#create_history_failed) | **POST** /api/v1/history/failed | 
*HistoryApi* | [**get_history**](docs/HistoryApi.md#get_history) | **GET** /api/v1/history | 
*HistoryApi* | [**list_history_author**](docs/HistoryApi.md#list_history_author) | **GET** /api/v1/history/author | 
*HistoryApi* | [**list_history_since**](docs/HistoryApi.md#list_history_since) | **GET** /api/v1/history/since | 
*HostConfigApi* | [**get_host_config**](docs/HostConfigApi.md#get_host_config) | **GET** /api/v1/config/host | 
*HostConfigApi* | [**get_host_config_by_id**](docs/HostConfigApi.md#get_host_config_by_id) | **GET** /api/v1/config/host/{id} | 
*HostConfigApi* | [**update_host_config**](docs/HostConfigApi.md#update_host_config) | **PUT** /api/v1/config/host/{id} | 
*ImportListApi* | [**create_import_list**](docs/ImportListApi.md#create_import_list) | **POST** /api/v1/importlist | 
*ImportListApi* | [**create_import_list_action_by_name**](docs/ImportListApi.md#create_import_list_action_by_name) | **POST** /api/v1/importlist/action/{name} | 
*ImportListApi* | [**delete_import_list**](docs/ImportListApi.md#delete_import_list) | **DELETE** /api/v1/importlist/{id} | 
*ImportListApi* | [**get_import_list_by_id**](docs/ImportListApi.md#get_import_list_by_id) | **GET** /api/v1/importlist/{id} | 
*ImportListApi* | [**list_import_list**](docs/ImportListApi.md#list_import_list) | **GET** /api/v1/importlist | 
*ImportListApi* | [**list_import_list_schema**](docs/ImportListApi.md#list_import_list_schema) | **GET** /api/v1/importlist/schema | 
*ImportListApi* | [**test_import_list**](docs/ImportListApi.md#test_import_list) | **POST** /api/v1/importlist/test | 
*ImportListApi* | [**testall_import_list**](docs/ImportListApi.md#testall_import_list) | **POST** /api/v1/importlist/testall | 
*ImportListApi* | [**update_import_list**](docs/ImportListApi.md#update_import_list) | **PUT** /api/v1/importlist/{id} | 
*ImportListExclusionApi* | [**create_import_list_exclusion**](docs/ImportListExclusionApi.md#create_import_list_exclusion) | **POST** /api/v1/importlistexclusion | 
*ImportListExclusionApi* | [**delete_import_list_exclusion**](docs/ImportListExclusionApi.md#delete_import_list_exclusion) | **DELETE** /api/v1/importlistexclusion/{id} | 
*ImportListExclusionApi* | [**get_import_list_exclusion_by_id**](docs/ImportListExclusionApi.md#get_import_list_exclusion_by_id) | **GET** /api/v1/importlistexclusion/{id} | 
*ImportListExclusionApi* | [**list_import_list_exclusion**](docs/ImportListExclusionApi.md#list_import_list_exclusion) | **GET** /api/v1/importlistexclusion | 
*ImportListExclusionApi* | [**update_import_list_exclusion**](docs/ImportListExclusionApi.md#update_import_list_exclusion) | **PUT** /api/v1/importlistexclusion/{id} | 
*IndexerApi* | [**create_indexer**](docs/IndexerApi.md#create_indexer) | **POST** /api/v1/indexer | 
*IndexerApi* | [**create_indexer_action_by_name**](docs/IndexerApi.md#create_indexer_action_by_name) | **POST** /api/v1/indexer/action/{name} | 
*IndexerApi* | [**delete_indexer**](docs/IndexerApi.md#delete_indexer) | **DELETE** /api/v1/indexer/{id} | 
*IndexerApi* | [**get_indexer_by_id**](docs/IndexerApi.md#get_indexer_by_id) | **GET** /api/v1/indexer/{id} | 
*IndexerApi* | [**list_indexer**](docs/IndexerApi.md#list_indexer) | **GET** /api/v1/indexer | 
*IndexerApi* | [**list_indexer_schema**](docs/IndexerApi.md#list_indexer_schema) | **GET** /api/v1/indexer/schema | 
*IndexerApi* | [**test_indexer**](docs/IndexerApi.md#test_indexer) | **POST** /api/v1/indexer/test | 
*IndexerApi* | [**testall_indexer**](docs/IndexerApi.md#testall_indexer) | **POST** /api/v1/indexer/testall | 
*IndexerApi* | [**update_indexer**](docs/IndexerApi.md#update_indexer) | **PUT** /api/v1/indexer/{id} | 
*IndexerConfigApi* | [**get_indexer_config**](docs/IndexerConfigApi.md#get_indexer_config) | **GET** /api/v1/config/indexer | 
*IndexerConfigApi* | [**get_indexer_config_by_id**](docs/IndexerConfigApi.md#get_indexer_config_by_id) | **GET** /api/v1/config/indexer/{id} | 
*IndexerConfigApi* | [**update_indexer_config**](docs/IndexerConfigApi.md#update_indexer_config) | **PUT** /api/v1/config/indexer/{id} | 
*InitializeJsApi* | [**get_initialize_js**](docs/InitializeJsApi.md#get_initialize_js) | **GET** /initialize.js | 
*LanguageApi* | [**get_language_by_id**](docs/LanguageApi.md#get_language_by_id) | **GET** /api/v1/language/{id} | 
*LanguageApi* | [**list_language**](docs/LanguageApi.md#list_language) | **GET** /api/v1/language | 
*LocalizationApi* | [**get_localization**](docs/LocalizationApi.md#get_localization) | **GET** /api/v1/localization | 
*LogApi* | [**get_log**](docs/LogApi.md#get_log) | **GET** /api/v1/log | 
*LogFileApi* | [**get_log_file_by_filename**](docs/LogFileApi.md#get_log_file_by_filename) | **GET** /api/v1/log/file/{filename} | 
*LogFileApi* | [**list_log_file**](docs/LogFileApi.md#list_log_file) | **GET** /api/v1/log/file | 
*ManualImportApi* | [**list_manual_import**](docs/ManualImportApi.md#list_manual_import) | **GET** /api/v1/manualimport | 
*ManualImportApi* | [**put_manual_import**](docs/ManualImportApi.md#put_manual_import) | **PUT** /api/v1/manualimport | 
*MediaCoverApi* | [**get_media_cover_authorauthor_id_by_filename**](docs/MediaCoverApi.md#get_media_cover_authorauthor_id_by_filename) | **GET** /api/v1/mediacover/author/{authorId}/{filename} | 
*MediaCoverApi* | [**get_media_cover_bookbook_id_by_filename**](docs/MediaCoverApi.md#get_media_cover_bookbook_id_by_filename) | **GET** /api/v1/mediacover/book/{bookId}/{filename} | 
*MediaManagementConfigApi* | [**get_media_management_config**](docs/MediaManagementConfigApi.md#get_media_management_config) | **GET** /api/v1/config/mediamanagement | 
*MediaManagementConfigApi* | [**get_media_management_config_by_id**](docs/MediaManagementConfigApi.md#get_media_management_config_by_id) | **GET** /api/v1/config/mediamanagement/{id} | 
*MediaManagementConfigApi* | [**update_media_management_config**](docs/MediaManagementConfigApi.md#update_media_management_config) | **PUT** /api/v1/config/mediamanagement/{id} | 
*MetadataApi* | [**create_metadata**](docs/MetadataApi.md#create_metadata) | **POST** /api/v1/metadata | 
*MetadataApi* | [**create_metadata_action_by_name**](docs/MetadataApi.md#create_metadata_action_by_name) | **POST** /api/v1/metadata/action/{name} | 
*MetadataApi* | [**delete_metadata**](docs/MetadataApi.md#delete_metadata) | **DELETE** /api/v1/metadata/{id} | 
*MetadataApi* | [**get_metadata_by_id**](docs/MetadataApi.md#get_metadata_by_id) | **GET** /api/v1/metadata/{id} | 
*MetadataApi* | [**list_metadata**](docs/MetadataApi.md#list_metadata) | **GET** /api/v1/metadata | 
*MetadataApi* | [**list_metadata_schema**](docs/MetadataApi.md#list_metadata_schema) | **GET** /api/v1/metadata/schema | 
*MetadataApi* | [**test_metadata**](docs/MetadataApi.md#test_metadata) | **POST** /api/v1/metadata/test | 
*MetadataApi* | [**testall_metadata**](docs/MetadataApi.md#testall_metadata) | **POST** /api/v1/metadata/testall | 
*MetadataApi* | [**update_metadata**](docs/MetadataApi.md#update_metadata) | **PUT** /api/v1/metadata/{id} | 
*MetadataProfileApi* | [**create_metadata_profile**](docs/MetadataProfileApi.md#create_metadata_profile) | **POST** /api/v1/metadataprofile | 
*MetadataProfileApi* | [**delete_metadata_profile**](docs/MetadataProfileApi.md#delete_metadata_profile) | **DELETE** /api/v1/metadataprofile/{id} | 
*MetadataProfileApi* | [**get_metadata_profile_by_id**](docs/MetadataProfileApi.md#get_metadata_profile_by_id) | **GET** /api/v1/metadataprofile/{id} | 
*MetadataProfileApi* | [**list_metadata_profile**](docs/MetadataProfileApi.md#list_metadata_profile) | **GET** /api/v1/metadataprofile | 
*MetadataProfileApi* | [**update_metadata_profile**](docs/MetadataProfileApi.md#update_metadata_profile) | **PUT** /api/v1/metadataprofile/{id} | 
*MetadataProfileSchemaApi* | [**get_metadataprofile_schema**](docs/MetadataProfileSchemaApi.md#get_metadataprofile_schema) | **GET** /api/v1/metadataprofile/schema | 
*MetadataProviderConfigApi* | [**get_metadata_provider_config**](docs/MetadataProviderConfigApi.md#get_metadata_provider_config) | **GET** /api/v1/config/metadataprovider | 
*MetadataProviderConfigApi* | [**get_metadata_provider_config_by_id**](docs/MetadataProviderConfigApi.md#get_metadata_provider_config_by_id) | **GET** /api/v1/config/metadataprovider/{id} | 
*MetadataProviderConfigApi* | [**update_metadata_provider_config**](docs/MetadataProviderConfigApi.md#update_metadata_provider_config) | **PUT** /api/v1/config/metadataprovider/{id} | 
*MissingApi* | [**get_wanted_missing**](docs/MissingApi.md#get_wanted_missing) | **GET** /api/v1/wanted/missing | 
*MissingApi* | [**get_wanted_missing_by_id**](docs/MissingApi.md#get_wanted_missing_by_id) | **GET** /api/v1/wanted/missing/{id} | 
*NamingConfigApi* | [**get_naming_config**](docs/NamingConfigApi.md#get_naming_config) | **GET** /api/v1/config/naming | 
*NamingConfigApi* | [**get_naming_config_by_id**](docs/NamingConfigApi.md#get_naming_config_by_id) | **GET** /api/v1/config/naming/{id} | 
*NamingConfigApi* | [**get_naming_config_examples**](docs/NamingConfigApi.md#get_naming_config_examples) | **GET** /api/v1/config/naming/examples | 
*NamingConfigApi* | [**update_naming_config**](docs/NamingConfigApi.md#update_naming_config) | **PUT** /api/v1/config/naming/{id} | 
*NotificationApi* | [**create_notification**](docs/NotificationApi.md#create_notification) | **POST** /api/v1/notification | 
*NotificationApi* | [**create_notification_action_by_name**](docs/NotificationApi.md#create_notification_action_by_name) | **POST** /api/v1/notification/action/{name} | 
*NotificationApi* | [**delete_notification**](docs/NotificationApi.md#delete_notification) | **DELETE** /api/v1/notification/{id} | 
*NotificationApi* | [**get_notification_by_id**](docs/NotificationApi.md#get_notification_by_id) | **GET** /api/v1/notification/{id} | 
*NotificationApi* | [**list_notification**](docs/NotificationApi.md#list_notification) | **GET** /api/v1/notification | 
*NotificationApi* | [**list_notification_schema**](docs/NotificationApi.md#list_notification_schema) | **GET** /api/v1/notification/schema | 
*NotificationApi* | [**test_notification**](docs/NotificationApi.md#test_notification) | **POST** /api/v1/notification/test | 
*NotificationApi* | [**testall_notification**](docs/NotificationApi.md#testall_notification) | **POST** /api/v1/notification/testall | 
*NotificationApi* | [**update_notification**](docs/NotificationApi.md#update_notification) | **PUT** /api/v1/notification/{id} | 
*ParseApi* | [**get_parse**](docs/ParseApi.md#get_parse) | **GET** /api/v1/parse | 
*QualityDefinitionApi* | [**get_quality_definition_by_id**](docs/QualityDefinitionApi.md#get_quality_definition_by_id) | **GET** /api/v1/qualitydefinition/{id} | 
*QualityDefinitionApi* | [**list_quality_definition**](docs/QualityDefinitionApi.md#list_quality_definition) | **GET** /api/v1/qualitydefinition | 
*QualityDefinitionApi* | [**put_quality_definition_update**](docs/QualityDefinitionApi.md#put_quality_definition_update) | **PUT** /api/v1/qualitydefinition/update | 
*QualityDefinitionApi* | [**update_quality_definition**](docs/QualityDefinitionApi.md#update_quality_definition) | **PUT** /api/v1/qualitydefinition/{id} | 
*QualityProfileApi* | [**create_quality_profile**](docs/QualityProfileApi.md#create_quality_profile) | **POST** /api/v1/qualityprofile | 
*QualityProfileApi* | [**delete_quality_profile**](docs/QualityProfileApi.md#delete_quality_profile) | **DELETE** /api/v1/qualityprofile/{id} | 
*QualityProfileApi* | [**get_quality_profile_by_id**](docs/QualityProfileApi.md#get_quality_profile_by_id) | **GET** /api/v1/qualityprofile/{id} | 
*QualityProfileApi* | [**list_quality_profile**](docs/QualityProfileApi.md#list_quality_profile) | **GET** /api/v1/qualityprofile | 
*QualityProfileApi* | [**update_quality_profile**](docs/QualityProfileApi.md#update_quality_profile) | **PUT** /api/v1/qualityprofile/{id} | 
*QualityProfileSchemaApi* | [**get_qualityprofile_schema**](docs/QualityProfileSchemaApi.md#get_qualityprofile_schema) | **GET** /api/v1/qualityprofile/schema | 
*QueueApi* | [**delete_queue**](docs/QueueApi.md#delete_queue) | **DELETE** /api/v1/queue/{id} | 
*QueueApi* | [**delete_queue_bulk**](docs/QueueApi.md#delete_queue_bulk) | **DELETE** /api/v1/queue/bulk | 
*QueueApi* | [**get_queue**](docs/QueueApi.md#get_queue) | **GET** /api/v1/queue | 
*QueueApi* | [**get_queue_by_id**](docs/QueueApi.md#get_queue_by_id) | **GET** /api/v1/queue/{id} | 
*QueueActionApi* | [**create_queue_grab_bulk**](docs/QueueActionApi.md#create_queue_grab_bulk) | **POST** /api/v1/queue/grab/bulk | 
*QueueActionApi* | [**create_queue_grab_by_id**](docs/QueueActionApi.md#create_queue_grab_by_id) | **POST** /api/v1/queue/grab/{id} | 
*QueueDetailsApi* | [**get_queue_details_by_id**](docs/QueueDetailsApi.md#get_queue_details_by_id) | **GET** /api/v1/queue/details/{id} | 
*QueueDetailsApi* | [**list_queue_details**](docs/QueueDetailsApi.md#list_queue_details) | **GET** /api/v1/queue/details | 
*QueueStatusApi* | [**get_queue_status**](docs/QueueStatusApi.md#get_queue_status) | **GET** /api/v1/queue/status | 
*QueueStatusApi* | [**get_queue_status_by_id**](docs/QueueStatusApi.md#get_queue_status_by_id) | **GET** /api/v1/queue/status/{id} | 
*ReleaseApi* | [**create_release**](docs/ReleaseApi.md#create_release) | **POST** /api/v1/release | 
*ReleaseApi* | [**get_release_by_id**](docs/ReleaseApi.md#get_release_by_id) | **GET** /api/v1/release/{id} | 
*ReleaseApi* | [**list_release**](docs/ReleaseApi.md#list_release) | **GET** /api/v1/release | 
*ReleaseProfileApi* | [**create_release_profile**](docs/ReleaseProfileApi.md#create_release_profile) | **POST** /api/v1/releaseprofile | 
*ReleaseProfileApi* | [**delete_release_profile**](docs/ReleaseProfileApi.md#delete_release_profile) | **DELETE** /api/v1/releaseprofile/{id} | 
*ReleaseProfileApi* | [**get_release_profile_by_id**](docs/ReleaseProfileApi.md#get_release_profile_by_id) | **GET** /api/v1/releaseprofile/{id} | 
*ReleaseProfileApi* | [**list_release_profile**](docs/ReleaseProfileApi.md#list_release_profile) | **GET** /api/v1/releaseprofile | 
*ReleaseProfileApi* | [**update_release_profile**](docs/ReleaseProfileApi.md#update_release_profile) | **PUT** /api/v1/releaseprofile/{id} | 
*ReleasePushApi* | [**create_release_push**](docs/ReleasePushApi.md#create_release_push) | **POST** /api/v1/release/push | 
*ReleasePushApi* | [**get_release_push_by_id**](docs/ReleasePushApi.md#get_release_push_by_id) | **GET** /api/v1/release/push/{id} | 
*RemotePathMappingApi* | [**create_remote_path_mapping**](docs/RemotePathMappingApi.md#create_remote_path_mapping) | **POST** /api/v1/remotepathmapping | 
*RemotePathMappingApi* | [**delete_remote_path_mapping**](docs/RemotePathMappingApi.md#delete_remote_path_mapping) | **DELETE** /api/v1/remotepathmapping/{id} | 
*RemotePathMappingApi* | [**get_remote_path_mapping_by_id**](docs/RemotePathMappingApi.md#get_remote_path_mapping_by_id) | **GET** /api/v1/remotepathmapping/{id} | 
*RemotePathMappingApi* | [**list_remote_path_mapping**](docs/RemotePathMappingApi.md#list_remote_path_mapping) | **GET** /api/v1/remotepathmapping | 
*RemotePathMappingApi* | [**update_remote_path_mapping**](docs/RemotePathMappingApi.md#update_remote_path_mapping) | **PUT** /api/v1/remotepathmapping/{id} | 
*RenameBookApi* | [**list_rename**](docs/RenameBookApi.md#list_rename) | **GET** /api/v1/rename | 
*RetagBookApi* | [**list_retag**](docs/RetagBookApi.md#list_retag) | **GET** /api/v1/retag | 
*RootFolderApi* | [**create_root_folder**](docs/RootFolderApi.md#create_root_folder) | **POST** /api/v1/rootfolder | 
*RootFolderApi* | [**delete_root_folder**](docs/RootFolderApi.md#delete_root_folder) | **DELETE** /api/v1/rootfolder/{id} | 
*RootFolderApi* | [**get_root_folder_by_id**](docs/RootFolderApi.md#get_root_folder_by_id) | **GET** /api/v1/rootfolder/{id} | 
*RootFolderApi* | [**list_root_folder**](docs/RootFolderApi.md#list_root_folder) | **GET** /api/v1/rootfolder | 
*RootFolderApi* | [**update_root_folder**](docs/RootFolderApi.md#update_root_folder) | **PUT** /api/v1/rootfolder/{id} | 
*SearchApi* | [**get_search**](docs/SearchApi.md#get_search) | **GET** /api/v1/search | 
*SeriesApi* | [**list_series**](docs/SeriesApi.md#list_series) | **GET** /api/v1/series | 
*StaticResourceApi* | [**get**](docs/StaticResourceApi.md#get) | **GET** / | 
*StaticResourceApi* | [**get_by_path**](docs/StaticResourceApi.md#get_by_path) | **GET** /{path} | 
*StaticResourceApi* | [**get_content_by_path**](docs/StaticResourceApi.md#get_content_by_path) | **GET** /content/{path} | 
*StaticResourceApi* | [**get_login**](docs/StaticResourceApi.md#get_login) | **GET** /login | 
*SystemApi* | [**create_system_restart**](docs/SystemApi.md#create_system_restart) | **POST** /api/v1/system/restart | 
*SystemApi* | [**create_system_shutdown**](docs/SystemApi.md#create_system_shutdown) | **POST** /api/v1/system/shutdown | 
*SystemApi* | [**get_system_routes**](docs/SystemApi.md#get_system_routes) | **GET** /api/v1/system/routes | 
*SystemApi* | [**get_system_routes_duplicate**](docs/SystemApi.md#get_system_routes_duplicate) | **GET** /api/v1/system/routes/duplicate | 
*SystemApi* | [**get_system_status**](docs/SystemApi.md#get_system_status) | **GET** /api/v1/system/status | 
*TagApi* | [**create_tag**](docs/TagApi.md#create_tag) | **POST** /api/v1/tag | 
*TagApi* | [**delete_tag**](docs/TagApi.md#delete_tag) | **DELETE** /api/v1/tag/{id} | 
*TagApi* | [**get_tag_by_id**](docs/TagApi.md#get_tag_by_id) | **GET** /api/v1/tag/{id} | 
*TagApi* | [**list_tag**](docs/TagApi.md#list_tag) | **GET** /api/v1/tag | 
*TagApi* | [**update_tag**](docs/TagApi.md#update_tag) | **PUT** /api/v1/tag/{id} | 
*TagDetailsApi* | [**get_tag_detail_by_id**](docs/TagDetailsApi.md#get_tag_detail_by_id) | **GET** /api/v1/tag/detail/{id} | 
*TagDetailsApi* | [**list_tag_detail**](docs/TagDetailsApi.md#list_tag_detail) | **GET** /api/v1/tag/detail | 
*TaskApi* | [**get_system_task_by_id**](docs/TaskApi.md#get_system_task_by_id) | **GET** /api/v1/system/task/{id} | 
*TaskApi* | [**list_system_task**](docs/TaskApi.md#list_system_task) | **GET** /api/v1/system/task | 
*UiConfigApi* | [**get_ui_config**](docs/UiConfigApi.md#get_ui_config) | **GET** /api/v1/config/ui | 
*UiConfigApi* | [**get_ui_config_by_id**](docs/UiConfigApi.md#get_ui_config_by_id) | **GET** /api/v1/config/ui/{id} | 
*UiConfigApi* | [**update_ui_config**](docs/UiConfigApi.md#update_ui_config) | **PUT** /api/v1/config/ui/{id} | 
*UpdateApi* | [**list_update**](docs/UpdateApi.md#list_update) | **GET** /api/v1/update | 
*UpdateLogFileApi* | [**get_log_file_update_by_filename**](docs/UpdateLogFileApi.md#get_log_file_update_by_filename) | **GET** /api/v1/log/file/update/{filename} | 
*UpdateLogFileApi* | [**list_log_file_update**](docs/UpdateLogFileApi.md#list_log_file_update) | **GET** /api/v1/log/file/update | 


## Documentation For Models

 - [AddAuthorOptions](docs/AddAuthorOptions.md)
 - [AddBookOptions](docs/AddBookOptions.md)
 - [AllowFingerprinting](docs/AllowFingerprinting.md)
 - [ApplyTags](docs/ApplyTags.md)
 - [AuthenticationType](docs/AuthenticationType.md)
 - [Author](docs/Author.md)
 - [AuthorEditorResource](docs/AuthorEditorResource.md)
 - [AuthorLazyLoaded](docs/AuthorLazyLoaded.md)
 - [AuthorMetadata](docs/AuthorMetadata.md)
 - [AuthorMetadataLazyLoaded](docs/AuthorMetadataLazyLoaded.md)
 - [AuthorResource](docs/AuthorResource.md)
 - [AuthorStatisticsResource](docs/AuthorStatisticsResource.md)
 - [AuthorStatusType](docs/AuthorStatusType.md)
 - [AuthorTitleInfo](docs/AuthorTitleInfo.md)
 - [BackupResource](docs/BackupResource.md)
 - [BackupType](docs/BackupType.md)
 - [BlacklistBulkResource](docs/BlacklistBulkResource.md)
 - [BlacklistResource](docs/BlacklistResource.md)
 - [BlacklistResourcePagingResource](docs/BlacklistResourcePagingResource.md)
 - [Book](docs/Book.md)
 - [BookAddType](docs/BookAddType.md)
 - [BookFile](docs/BookFile.md)
 - [BookFileListLazyLoaded](docs/BookFileListLazyLoaded.md)
 - [BookFileListResource](docs/BookFileListResource.md)
 - [BookFileResource](docs/BookFileResource.md)
 - [BookLazyLoaded](docs/BookLazyLoaded.md)
 - [BookListLazyLoaded](docs/BookListLazyLoaded.md)
 - [BookResource](docs/BookResource.md)
 - [BookResourcePagingResource](docs/BookResourcePagingResource.md)
 - [BookStatisticsResource](docs/BookStatisticsResource.md)
 - [BooksMonitoredResource](docs/BooksMonitoredResource.md)
 - [BookshelfAuthorResource](docs/BookshelfAuthorResource.md)
 - [BookshelfResource](docs/BookshelfResource.md)
 - [CertificateValidationType](docs/CertificateValidationType.md)
 - [Command](docs/Command.md)
 - [CommandPriority](docs/CommandPriority.md)
 - [CommandResource](docs/CommandResource.md)
 - [CommandStatus](docs/CommandStatus.md)
 - [CommandTrigger](docs/CommandTrigger.md)
 - [CustomFilterResource](docs/CustomFilterResource.md)
 - [DelayProfileResource](docs/DelayProfileResource.md)
 - [DevelopmentConfigResource](docs/DevelopmentConfigResource.md)
 - [DiskSpaceResource](docs/DiskSpaceResource.md)
 - [DownloadClientConfigResource](docs/DownloadClientConfigResource.md)
 - [DownloadClientResource](docs/DownloadClientResource.md)
 - [DownloadProtocol](docs/DownloadProtocol.md)
 - [Edition](docs/Edition.md)
 - [EditionLazyLoaded](docs/EditionLazyLoaded.md)
 - [EditionListLazyLoaded](docs/EditionListLazyLoaded.md)
 - [EditionResource](docs/EditionResource.md)
 - [Field](docs/Field.md)
 - [FileDateType](docs/FileDateType.md)
 - [HealthCheckResult](docs/HealthCheckResult.md)
 - [HealthResource](docs/HealthResource.md)
 - [HistoryEventType](docs/HistoryEventType.md)
 - [HistoryResource](docs/HistoryResource.md)
 - [HistoryResourcePagingResource](docs/HistoryResourcePagingResource.md)
 - [HostConfigResource](docs/HostConfigResource.md)
 - [ImportListExclusionResource](docs/ImportListExclusionResource.md)
 - [ImportListMonitorType](docs/ImportListMonitorType.md)
 - [ImportListResource](docs/ImportListResource.md)
 - [ImportListType](docs/ImportListType.md)
 - [IndexerConfigResource](docs/IndexerConfigResource.md)
 - [IndexerResource](docs/IndexerResource.md)
 - [IsoCountry](docs/IsoCountry.md)
 - [LanguageResource](docs/LanguageResource.md)
 - [Links](docs/Links.md)
 - [LogFileResource](docs/LogFileResource.md)
 - [LogResource](docs/LogResource.md)
 - [LogResourcePagingResource](docs/LogResourcePagingResource.md)
 - [ManualImportResource](docs/ManualImportResource.md)
 - [MediaCover](docs/MediaCover.md)
 - [MediaCoverTypes](docs/MediaCoverTypes.md)
 - [MediaInfoModel](docs/MediaInfoModel.md)
 - [MediaInfoResource](docs/MediaInfoResource.md)
 - [MediaManagementConfigResource](docs/MediaManagementConfigResource.md)
 - [MetadataProfile](docs/MetadataProfile.md)
 - [MetadataProfileLazyLoaded](docs/MetadataProfileLazyLoaded.md)
 - [MetadataProfileResource](docs/MetadataProfileResource.md)
 - [MetadataProviderConfigResource](docs/MetadataProviderConfigResource.md)
 - [MetadataResource](docs/MetadataResource.md)
 - [MonitorTypes](docs/MonitorTypes.md)
 - [MonitoringOptions](docs/MonitoringOptions.md)
 - [NamingConfigResource](docs/NamingConfigResource.md)
 - [NotificationResource](docs/NotificationResource.md)
 - [PagingResourceFilter](docs/PagingResourceFilter.md)
 - [ParseResource](docs/ParseResource.md)
 - [ParsedBookInfo](docs/ParsedBookInfo.md)
 - [ParsedTrackInfo](docs/ParsedTrackInfo.md)
 - [ProperDownloadTypes](docs/ProperDownloadTypes.md)
 - [ProviderMessage](docs/ProviderMessage.md)
 - [ProviderMessageType](docs/ProviderMessageType.md)
 - [ProxyType](docs/ProxyType.md)
 - [Quality](docs/Quality.md)
 - [QualityDefinitionResource](docs/QualityDefinitionResource.md)
 - [QualityModel](docs/QualityModel.md)
 - [QualityProfile](docs/QualityProfile.md)
 - [QualityProfileLazyLoaded](docs/QualityProfileLazyLoaded.md)
 - [QualityProfileQualityItem](docs/QualityProfileQualityItem.md)
 - [QualityProfileQualityItemResource](docs/QualityProfileQualityItemResource.md)
 - [QualityProfileResource](docs/QualityProfileResource.md)
 - [QueueBulkResource](docs/QueueBulkResource.md)
 - [QueueResource](docs/QueueResource.md)
 - [QueueResourcePagingResource](docs/QueueResourcePagingResource.md)
 - [QueueStatusResource](docs/QueueStatusResource.md)
 - [Ratings](docs/Ratings.md)
 - [Rejection](docs/Rejection.md)
 - [RejectionType](docs/RejectionType.md)
 - [ReleaseProfileResource](docs/ReleaseProfileResource.md)
 - [ReleaseResource](docs/ReleaseResource.md)
 - [RemotePathMappingResource](docs/RemotePathMappingResource.md)
 - [RenameBookResource](docs/RenameBookResource.md)
 - [RescanAfterRefreshType](docs/RescanAfterRefreshType.md)
 - [RetagBookResource](docs/RetagBookResource.md)
 - [Revision](docs/Revision.md)
 - [RootFolderResource](docs/RootFolderResource.md)
 - [SelectOption](docs/SelectOption.md)
 - [Series](docs/Series.md)
 - [SeriesBookLink](docs/SeriesBookLink.md)
 - [SeriesBookLinkListLazyLoaded](docs/SeriesBookLinkListLazyLoaded.md)
 - [SeriesBookLinkResource](docs/SeriesBookLinkResource.md)
 - [SeriesLazyLoaded](docs/SeriesLazyLoaded.md)
 - [SeriesListLazyLoaded](docs/SeriesListLazyLoaded.md)
 - [SeriesResource](docs/SeriesResource.md)
 - [SortDirection](docs/SortDirection.md)
 - [StringInt32KeyValuePair](docs/StringInt32KeyValuePair.md)
 - [TagDetailsResource](docs/TagDetailsResource.md)
 - [TagDifference](docs/TagDifference.md)
 - [TagResource](docs/TagResource.md)
 - [TaskResource](docs/TaskResource.md)
 - [TrackedDownloadState](docs/TrackedDownloadState.md)
 - [TrackedDownloadStatus](docs/TrackedDownloadStatus.md)
 - [TrackedDownloadStatusMessage](docs/TrackedDownloadStatusMessage.md)
 - [UiConfigResource](docs/UiConfigResource.md)
 - [UpdateChanges](docs/UpdateChanges.md)
 - [UpdateMechanism](docs/UpdateMechanism.md)
 - [UpdateResource](docs/UpdateResource.md)
 - [WriteAudioTagsType](docs/WriteAudioTagsType.md)
 - [WriteBookTagsType](docs/WriteBookTagsType.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




