# coding: utf-8

"""
    Readarr

    Readarr API docs  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel
from readarr.models.add_author_options import AddAuthorOptions
from readarr.models.author_metadata_lazy_loaded import AuthorMetadataLazyLoaded
from readarr.models.metadata_profile_lazy_loaded import MetadataProfileLazyLoaded
from readarr.models.quality_profile_lazy_loaded import QualityProfileLazyLoaded

class Author(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    author_metadata_id: Optional[int]
    clean_name: Optional[str]
    monitored: Optional[bool]
    last_info_sync: Optional[datetime]
    path: Optional[str]
    root_folder_path: Optional[str]
    added: Optional[datetime]
    quality_profile_id: Optional[int]
    metadata_profile_id: Optional[int]
    tags: Optional[List]
    add_options: Optional[AddAuthorOptions]
    metadata: Optional[AuthorMetadataLazyLoaded]
    quality_profile: Optional[QualityProfileLazyLoaded]
    metadata_profile: Optional[MetadataProfileLazyLoaded]
    books: Optional[BookListLazyLoaded]
    series: Optional[SeriesListLazyLoaded]
    name: Optional[str]
    foreign_author_id: Optional[str]
    __properties = ["id", "authorMetadataId", "cleanName", "monitored", "lastInfoSync", "path", "rootFolderPath", "added", "qualityProfileId", "metadataProfileId", "tags", "addOptions", "metadata", "qualityProfile", "metadataProfile", "books", "series", "name", "foreignAuthorId"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Author:
        """Create an instance of Author from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of add_options
        if self.add_options:
            _dict['addOptions'] = self.add_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quality_profile
        if self.quality_profile:
            _dict['qualityProfile'] = self.quality_profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata_profile
        if self.metadata_profile:
            _dict['metadataProfile'] = self.metadata_profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of books
        if self.books:
            _dict['books'] = self.books.to_dict()
        # override the default output from pydantic by calling `to_dict()` of series
        if self.series:
            _dict['series'] = self.series.to_dict()
        # set to None if clean_name (nullable) is None
        if self.clean_name is None:
            _dict['cleanName'] = None

        # set to None if last_info_sync (nullable) is None
        if self.last_info_sync is None:
            _dict['lastInfoSync'] = None

        # set to None if path (nullable) is None
        if self.path is None:
            _dict['path'] = None

        # set to None if root_folder_path (nullable) is None
        if self.root_folder_path is None:
            _dict['rootFolderPath'] = None

        # set to None if tags (nullable) is None
        if self.tags is None:
            _dict['tags'] = None

        # set to None if name (nullable) is None
        if self.name is None:
            _dict['name'] = None

        # set to None if foreign_author_id (nullable) is None
        if self.foreign_author_id is None:
            _dict['foreignAuthorId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Author:
        """Create an instance of Author from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Author.parse_obj(obj)

        _obj = Author.parse_obj({
            "id": obj.get("id"),
            "author_metadata_id": obj.get("authorMetadataId"),
            "clean_name": obj.get("cleanName"),
            "monitored": obj.get("monitored"),
            "last_info_sync": obj.get("lastInfoSync"),
            "path": obj.get("path"),
            "root_folder_path": obj.get("rootFolderPath"),
            "added": obj.get("added"),
            "quality_profile_id": obj.get("qualityProfileId"),
            "metadata_profile_id": obj.get("metadataProfileId"),
            "tags": obj.get("tags"),
            "add_options": AddAuthorOptions.from_dict(obj.get("addOptions")) if obj.get("addOptions") is not None else None,
            "metadata": AuthorMetadataLazyLoaded.from_dict(obj.get("metadata")) if obj.get("metadata") is not None else None,
            "quality_profile": QualityProfileLazyLoaded.from_dict(obj.get("qualityProfile")) if obj.get("qualityProfile") is not None else None,
            "metadata_profile": MetadataProfileLazyLoaded.from_dict(obj.get("metadataProfile")) if obj.get("metadataProfile") is not None else None,
            "books": BookListLazyLoaded.from_dict(obj.get("books")) if obj.get("books") is not None else None,
            "series": SeriesListLazyLoaded.from_dict(obj.get("series")) if obj.get("series") is not None else None,
            "name": obj.get("name"),
            "foreign_author_id": obj.get("foreignAuthorId")
        })
        return _obj

