# coding: utf-8

"""
    Readarr

    Readarr API docs  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, validator
from readarr.models.iso_country import IsoCountry
from readarr.models.media_info_model import MediaInfoModel
from readarr.models.quality_model import QualityModel

class ParsedTrackInfo(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    title: Optional[str]
    clean_title: Optional[str]
    authors: Optional[List]
    author_title: Optional[str]
    book_title: Optional[str]
    series_title: Optional[str]
    series_index: Optional[str]
    isbn: Optional[str]
    asin: Optional[str]
    goodreads_id: Optional[str]
    author_mbid: Optional[str]
    book_mbid: Optional[str]
    release_mbid: Optional[str]
    recording_mbid: Optional[str]
    track_mbid: Optional[str]
    disc_number: Optional[int]
    disc_count: Optional[int]
    country: Optional[IsoCountry]
    year: Optional[int]
    publisher: Optional[str]
    label: Optional[str]
    source: Optional[str]
    catalog_number: Optional[str]
    disambiguation: Optional[str]
    duration: Optional[str]
    quality: Optional[QualityModel]
    media_info: Optional[MediaInfoModel]
    track_numbers: Optional[List]
    language: Optional[str]
    release_group: Optional[str]
    release_hash: Optional[str]
    __properties = ["title", "cleanTitle", "authors", "authorTitle", "bookTitle", "seriesTitle", "seriesIndex", "isbn", "asin", "goodreadsId", "authorMBId", "bookMBId", "releaseMBId", "recordingMBId", "trackMBId", "discNumber", "discCount", "country", "year", "publisher", "label", "source", "catalogNumber", "disambiguation", "duration", "quality", "mediaInfo", "trackNumbers", "language", "releaseGroup", "releaseHash"]

    @validator('duration')
    def duration_validate_regular_expression(cls, v):
        if not re.match(r"\d{2}:\d{2}:\d{2}", v):
            raise ValueError(r"must validate the regular expression /\d{2}:\d{2}:\d{2}/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ParsedTrackInfo:
        """Create an instance of ParsedTrackInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "author_title",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of country
        if self.country:
            _dict['country'] = self.country.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quality
        if self.quality:
            _dict['quality'] = self.quality.to_dict()
        # override the default output from pydantic by calling `to_dict()` of media_info
        if self.media_info:
            _dict['mediaInfo'] = self.media_info.to_dict()
        # set to None if title (nullable) is None
        if self.title is None:
            _dict['title'] = None

        # set to None if clean_title (nullable) is None
        if self.clean_title is None:
            _dict['cleanTitle'] = None

        # set to None if authors (nullable) is None
        if self.authors is None:
            _dict['authors'] = None

        # set to None if author_title (nullable) is None
        if self.author_title is None:
            _dict['authorTitle'] = None

        # set to None if book_title (nullable) is None
        if self.book_title is None:
            _dict['bookTitle'] = None

        # set to None if series_title (nullable) is None
        if self.series_title is None:
            _dict['seriesTitle'] = None

        # set to None if series_index (nullable) is None
        if self.series_index is None:
            _dict['seriesIndex'] = None

        # set to None if isbn (nullable) is None
        if self.isbn is None:
            _dict['isbn'] = None

        # set to None if asin (nullable) is None
        if self.asin is None:
            _dict['asin'] = None

        # set to None if goodreads_id (nullable) is None
        if self.goodreads_id is None:
            _dict['goodreadsId'] = None

        # set to None if author_mbid (nullable) is None
        if self.author_mbid is None:
            _dict['authorMBId'] = None

        # set to None if book_mbid (nullable) is None
        if self.book_mbid is None:
            _dict['bookMBId'] = None

        # set to None if release_mbid (nullable) is None
        if self.release_mbid is None:
            _dict['releaseMBId'] = None

        # set to None if recording_mbid (nullable) is None
        if self.recording_mbid is None:
            _dict['recordingMBId'] = None

        # set to None if track_mbid (nullable) is None
        if self.track_mbid is None:
            _dict['trackMBId'] = None

        # set to None if publisher (nullable) is None
        if self.publisher is None:
            _dict['publisher'] = None

        # set to None if label (nullable) is None
        if self.label is None:
            _dict['label'] = None

        # set to None if source (nullable) is None
        if self.source is None:
            _dict['source'] = None

        # set to None if catalog_number (nullable) is None
        if self.catalog_number is None:
            _dict['catalogNumber'] = None

        # set to None if disambiguation (nullable) is None
        if self.disambiguation is None:
            _dict['disambiguation'] = None

        # set to None if track_numbers (nullable) is None
        if self.track_numbers is None:
            _dict['trackNumbers'] = None

        # set to None if language (nullable) is None
        if self.language is None:
            _dict['language'] = None

        # set to None if release_group (nullable) is None
        if self.release_group is None:
            _dict['releaseGroup'] = None

        # set to None if release_hash (nullable) is None
        if self.release_hash is None:
            _dict['releaseHash'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ParsedTrackInfo:
        """Create an instance of ParsedTrackInfo from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ParsedTrackInfo.parse_obj(obj)

        _obj = ParsedTrackInfo.parse_obj({
            "title": obj.get("title"),
            "clean_title": obj.get("cleanTitle"),
            "authors": obj.get("authors"),
            "author_title": obj.get("authorTitle"),
            "book_title": obj.get("bookTitle"),
            "series_title": obj.get("seriesTitle"),
            "series_index": obj.get("seriesIndex"),
            "isbn": obj.get("isbn"),
            "asin": obj.get("asin"),
            "goodreads_id": obj.get("goodreadsId"),
            "author_mbid": obj.get("authorMBId"),
            "book_mbid": obj.get("bookMBId"),
            "release_mbid": obj.get("releaseMBId"),
            "recording_mbid": obj.get("recordingMBId"),
            "track_mbid": obj.get("trackMBId"),
            "disc_number": obj.get("discNumber"),
            "disc_count": obj.get("discCount"),
            "country": IsoCountry.from_dict(obj.get("country")) if obj.get("country") is not None else None,
            "year": obj.get("year"),
            "publisher": obj.get("publisher"),
            "label": obj.get("label"),
            "source": obj.get("source"),
            "catalog_number": obj.get("catalogNumber"),
            "disambiguation": obj.get("disambiguation"),
            "duration": obj.get("duration"),
            "quality": QualityModel.from_dict(obj.get("quality")) if obj.get("quality") is not None else None,
            "media_info": MediaInfoModel.from_dict(obj.get("mediaInfo")) if obj.get("mediaInfo") is not None else None,
            "track_numbers": obj.get("trackNumbers"),
            "language": obj.get("language"),
            "release_group": obj.get("releaseGroup"),
            "release_hash": obj.get("releaseHash")
        })
        return _obj

