# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.common.v1.config.Metadata import Metadata  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.NetworkingBaseModel import NetworkingBaseModel  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.Route import Route  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.Status import Status  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class BgpSession(NetworkingBaseModel):
    """BgpSession - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'local_gateway_reference': 'str',
        'remote_gateway_reference': 'str',
        'dynamic_route_priority': 'int',
        'password': 'str',
        'status': 'networking.v4.config.Status',
        'advertised_routes': 'list[networking.v4.config.Route]',
        'received_routes': 'list[networking.v4.config.Route]',
        'ignored_routes': 'list[networking.v4.config.Route]',
        'metadata': 'common.v1.config.Metadata',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'local_gateway_reference': 'localGatewayReference',
        'remote_gateway_reference': 'remoteGatewayReference',
        'dynamic_route_priority': 'dynamicRoutePriority',
        'password': 'password',
        'status': 'status',
        'advertised_routes': 'advertisedRoutes',
        'received_routes': 'receivedRoutes',
        'ignored_routes': 'ignoredRoutes',
        'metadata': 'metadata',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, name=None, description=None, local_gateway_reference=None, remote_gateway_reference=None, dynamic_route_priority=None, password=None, status=None, advertised_routes=None, received_routes=None, ignored_routes=None, metadata=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """BgpSession - a model defined in Swagger
            \nBGP session.
        """
        NetworkingBaseModel.__init__(self, metadata, ext_id, links, tenant_id, *args, **kwargs)
        self.__name = None
        self.__description = None
        self.__local_gateway_reference = None
        self.__remote_gateway_reference = None
        self.__dynamic_route_priority = None
        self.__password = None
        self.__status = None
        self.__advertised_routes = None
        self.__received_routes = None
        self.__ignored_routes = None
        self.discriminator = None
        self.__name = name
        if description is not None:
            self.__description = description
        self.__local_gateway_reference = local_gateway_reference
        self.__remote_gateway_reference = remote_gateway_reference
        if dynamic_route_priority is not None:
            self.__dynamic_route_priority = dynamic_route_priority
        if password is not None:
            self.__password = password
        if status is not None:
            self.__status = status
        if advertised_routes is not None:
            self.__advertised_routes = advertised_routes
        if received_routes is not None:
            self.__received_routes = received_routes
        if ignored_routes is not None:
            self.__ignored_routes = ignored_routes

    def _initialize_object_type(self):
        return 'networking.v4.config.BgpSession'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.BgpSession'


    @property
    def name(self):
        """`{ str }`
            \nBGP session name.
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self.__name = name

    @property
    def description(self):
        """`{ str }`
            \nBGP session description.
        """ # noqa: E501
        return self.__description

    @description.setter
    def description(self, description):

        self.__description = description

    @property
    def local_gateway_reference(self):
        """`{ str }`
            \nThe local BGP gateway reference.
        """ # noqa: E501
        return self.__local_gateway_reference

    @local_gateway_reference.setter
    def local_gateway_reference(self, local_gateway_reference):
        if local_gateway_reference is None:
            raise ValueError("Invalid value for `local_gateway_reference`, must not be `None`")  # noqa: E501
        if local_gateway_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', local_gateway_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `local_gateway_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__local_gateway_reference = local_gateway_reference

    @property
    def remote_gateway_reference(self):
        """`{ str }`
            \nThe remote BGP gateway reference.
        """ # noqa: E501
        return self.__remote_gateway_reference

    @remote_gateway_reference.setter
    def remote_gateway_reference(self, remote_gateway_reference):
        if remote_gateway_reference is None:
            raise ValueError("Invalid value for `remote_gateway_reference`, must not be `None`")  # noqa: E501
        if remote_gateway_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', remote_gateway_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `remote_gateway_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__remote_gateway_reference = remote_gateway_reference

    @property
    def dynamic_route_priority(self):
        """`{ int }`
            \nThe priority assigned to routes received over this BGP session.
        """ # noqa: E501
        return self.__dynamic_route_priority

    @dynamic_route_priority.setter
    def dynamic_route_priority(self, dynamic_route_priority):
        if dynamic_route_priority is not None and dynamic_route_priority > 1000:  # noqa: E501
            raise ValueError("Invalid value for `dynamic_route_priority`, must be a value less than or equal to `1000`")  # noqa: E501
        if dynamic_route_priority is not None and dynamic_route_priority < 300:  # noqa: E501
            raise ValueError("Invalid value for `dynamic_route_priority`, must be a value greater than or equal to `300`")  # noqa: E501

        self.__dynamic_route_priority = dynamic_route_priority

    @property
    def password(self):
        """`{ str }`
            \nBGP password
        """ # noqa: E501
        return self.__password

    @password.setter
    def password(self, password):

        self.__password = password

    @property
    def status(self):
        """`{ networking.v4.config.Status }`
            
        """ # noqa: E501
        return self.__status

    @status.setter
    def status(self, status):

        self.__status = status

    @property
    def advertised_routes(self):
        """`{ list[networking.v4.config.Route] }`
            \nAdvertised routes.
        """ # noqa: E501
        return self.__advertised_routes

    @advertised_routes.setter
    def advertised_routes(self, advertised_routes):

        self.__advertised_routes = advertised_routes

    @property
    def received_routes(self):
        """`{ list[networking.v4.config.Route] }`
            \nReceived routes.
        """ # noqa: E501
        return self.__received_routes

    @received_routes.setter
    def received_routes(self, received_routes):

        self.__received_routes = received_routes

    @property
    def ignored_routes(self):
        """`{ list[networking.v4.config.Route] }`
            \nReceived routes that are ignored either because the next hop is not L2-adjacent to the VPC or the upper limit of the received routes per session has exceeded.
        """ # noqa: E501
        return self.__ignored_routes

    @ignored_routes.setter
    def ignored_routes(self, ignored_routes):

        self.__ignored_routes = ignored_routes

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(BgpSession, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BgpSession):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

