# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
import ntnx_networking_py_client.Ntnx
from ntnx_networking_py_client.Ntnx.OneOfnetworking.v4.config.FloatingIpassociation import FloatingIpassociation  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.common.v1.config.Metadata import Metadata  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.FloatingIPAddress import FloatingIPAddress  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.NetworkingBaseModel import NetworkingBaseModel  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class FloatingIp(NetworkingBaseModel):
    """FloatingIp - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'association': 'OneOfnetworking.v4.config.FloatingIpassociation',
        'floating_ip': 'networking.v4.config.FloatingIPAddress',
        'external_subnet_reference': 'str',
        'metadata': 'common.v1.config.Metadata',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'association': 'association',
        'floating_ip': 'floatingIp',
        'external_subnet_reference': 'externalSubnetReference',
        'metadata': 'metadata',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, name=None, description=None, association=None, floating_ip=None, external_subnet_reference=None, metadata=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """FloatingIp - a model defined in Swagger
            \nConfigure a floating IP.
        """
        NetworkingBaseModel.__init__(self, metadata, ext_id, links, tenant_id, *args, **kwargs)
        self.__name = None
        self.__description = None
        self.__association = None
        self.__floating_ip = None
        self.__external_subnet_reference = None
        self.discriminator = None
        if name is not None:
            self.__name = name
        if description is not None:
            self.__description = description
        if association is not None:
            self.__association = association
        if floating_ip is not None:
            self.__floating_ip = floating_ip
        if external_subnet_reference is not None:
            self.__external_subnet_reference = external_subnet_reference

    def _initialize_object_type(self):
        return 'networking.v4.config.FloatingIp'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.FloatingIp'


    @property
    def name(self):
        """`{ str }`
            \nName of the floating IP.
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is not None and len(name) > 128:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `128`")  # noqa: E501

        self.__name = name

    @property
    def description(self):
        """`{ str }`
            \nDescription for the Floating IP.
        """ # noqa: E501
        return self.__description

    @description.setter
    def description(self, description):
        if description is not None and len(description) > 1000:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `1000`")  # noqa: E501

        self.__description = description

    @property
    def association(self):
        """`{ networking.v4.config.VmNicAssociation | networking.v4.config.PrivateIpAssociation }`
            \nAssociation of the Floating IP with either NIC or Private IP
        """ # noqa: E501
        return self.__association

    @association.setter
    def association(self, association):

        self.__association = association

    @property
    def floating_ip(self):
        """`{ networking.v4.config.FloatingIPAddress }`
            
        """ # noqa: E501
        return self.__floating_ip

    @floating_ip.setter
    def floating_ip(self, floating_ip):

        self.__floating_ip = floating_ip

    @property
    def external_subnet_reference(self):
        """`{ str }`
            \nExternal subnet reference for the Floating IP to be allocated in on-prem only.
        """ # noqa: E501
        return self.__external_subnet_reference

    @external_subnet_reference.setter
    def external_subnet_reference(self, external_subnet_reference):
        if external_subnet_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', external_subnet_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `external_subnet_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__external_subnet_reference = external_subnet_reference

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if attr_type.startswith('OneOf'):
                type = getattr(ntnx_networking_py_client.Ntnx, attr_type.split('.')[-1])
                if hasattr(type, 'get_discriminator_from_object'):
                    result[type.ONE_OF_ITEM_DISCRIMINATOR_NAME] = type.get_discriminator_from_object(value)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(FloatingIp, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FloatingIp):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

