# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.common.v1.config.Metadata import Metadata  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.AzureExternalSubnetBinding import AzureExternalSubnetBinding  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.FlowGatewayStatus import FlowGatewayStatus  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.NetworkingBaseModel import NetworkingBaseModel  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class FlowGateway(NetworkingBaseModel):
    """FlowGateway - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'chassis_uuid': 'str',
        'azure_external_subnet_binding_list': 'list[networking.v4.config.AzureExternalSubnetBinding]',
        'gateway_status': 'networking.v4.config.FlowGatewayStatus',
        'ovn_controller_version': 'str',
        'metadata': 'common.v1.config.Metadata',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'chassis_uuid': 'chassisUuid',
        'azure_external_subnet_binding_list': 'azureExternalSubnetBindingList',
        'gateway_status': 'gatewayStatus',
        'ovn_controller_version': 'ovnControllerVersion',
        'metadata': 'metadata',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, chassis_uuid=None, azure_external_subnet_binding_list=None, gateway_status=None, ovn_controller_version=None, metadata=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """FlowGateway - a model defined in Swagger
            
        """
        NetworkingBaseModel.__init__(self, metadata, ext_id, links, tenant_id, *args, **kwargs)
        self.__chassis_uuid = None
        self.__azure_external_subnet_binding_list = None
        self.__gateway_status = None
        self.__ovn_controller_version = None
        self.discriminator = None
        self.__chassis_uuid = chassis_uuid
        self.__azure_external_subnet_binding_list = azure_external_subnet_binding_list
        if gateway_status is not None:
            self.__gateway_status = gateway_status
        if ovn_controller_version is not None:
            self.__ovn_controller_version = ovn_controller_version

    def _initialize_object_type(self):
        return 'networking.v4.config.FlowGateway'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.FlowGateway'


    @property
    def chassis_uuid(self):
        """`{ str }`
            \nChassis UUID of the Atlas Flow Gateway.
        """ # noqa: E501
        return self.__chassis_uuid

    @chassis_uuid.setter
    def chassis_uuid(self, chassis_uuid):
        if chassis_uuid is None:
            raise ValueError("Invalid value for `chassis_uuid`, must not be `None`")  # noqa: E501
        if chassis_uuid is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', chassis_uuid):  # noqa: E501
            raise ValueError(r"Invalid value for `chassis_uuid`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__chassis_uuid = chassis_uuid

    @property
    def azure_external_subnet_binding_list(self):
        """`{ list[networking.v4.config.AzureExternalSubnetBinding] }`
            \nList of bindings of the Atlas Flow Gateway external subnet with the Azure external subnet.
        """ # noqa: E501
        return self.__azure_external_subnet_binding_list

    @azure_external_subnet_binding_list.setter
    def azure_external_subnet_binding_list(self, azure_external_subnet_binding_list):
        if azure_external_subnet_binding_list is None:
            raise ValueError("Invalid value for `azure_external_subnet_binding_list`, must not be `None`")  # noqa: E501

        self.__azure_external_subnet_binding_list = azure_external_subnet_binding_list

    @property
    def gateway_status(self):
        """`{ networking.v4.config.FlowGatewayStatus }`
            
        """ # noqa: E501
        return self.__gateway_status

    @gateway_status.setter
    def gateway_status(self, gateway_status):

        self.__gateway_status = gateway_status

    @property
    def ovn_controller_version(self):
        """`{ str }`
            \nVersion of the OVN controller
        """ # noqa: E501
        return self.__ovn_controller_version

    @ovn_controller_version.setter
    def ovn_controller_version(self, ovn_controller_version):
        if ovn_controller_version is not None and not re.search('^(\\d+\\.)?(\\d+\\.)?(\\d+)$', ovn_controller_version):  # noqa: E501
            raise ValueError(r"Invalid value for `ovn_controller_version`, must be a follow pattern or equal to `/^(\\d+\\.)?(\\d+\\.)?(\\d+)$/`")  # noqa: E501

        self.__ovn_controller_version = ovn_controller_version

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(FlowGateway, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FlowGateway):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

