# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.common.v1.config.IPAddress import IPAddress  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.AuthenticationAlgorithm import AuthenticationAlgorithm  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.EncryptionAlgorithm import EncryptionAlgorithm  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class IpsecConfig(object):
    """IpsecConfig - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'pre_shared_key': 'str',
        'local_vti_ip': 'common.v1.config.IPAddress',
        'remote_vti_ip': 'common.v1.config.IPAddress',
        'local_authentication_id': 'str',
        'remote_authentication_id': 'str',
        'ike_lifetime_secs': 'int',
        'ipsec_lifetime_secs': 'int',
        'esp_pfs_dh_group_number': 'int',
        'ike_encryption_algorithm': 'networking.v4.config.EncryptionAlgorithm',
        'ike_authentication_algorithm': 'networking.v4.config.AuthenticationAlgorithm',
        'ipsec_encryption_algorithm': 'networking.v4.config.EncryptionAlgorithm',
        'ipsec_authentication_algorithm': 'networking.v4.config.AuthenticationAlgorithm',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'pre_shared_key': 'preSharedKey',
        'local_vti_ip': 'localVtiIp',
        'remote_vti_ip': 'remoteVtiIp',
        'local_authentication_id': 'localAuthenticationId',
        'remote_authentication_id': 'remoteAuthenticationId',
        'ike_lifetime_secs': 'ikeLifetimeSecs',
        'ipsec_lifetime_secs': 'ipsecLifetimeSecs',
        'esp_pfs_dh_group_number': 'espPfsDhGroupNumber',
        'ike_encryption_algorithm': 'ikeEncryptionAlgorithm',
        'ike_authentication_algorithm': 'ikeAuthenticationAlgorithm',
        'ipsec_encryption_algorithm': 'ipsecEncryptionAlgorithm',
        'ipsec_authentication_algorithm': 'ipsecAuthenticationAlgorithm',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, pre_shared_key=None, local_vti_ip=None, remote_vti_ip=None, local_authentication_id=None, remote_authentication_id=None, ike_lifetime_secs=None, ipsec_lifetime_secs=None, esp_pfs_dh_group_number=None, ike_encryption_algorithm=None, ike_authentication_algorithm=None, ipsec_encryption_algorithm=None, ipsec_authentication_algorithm=None, *args, **kwargs):  # noqa: E501
        """IpsecConfig - a model defined in Swagger
            \nIPSec configuration
        """
        self.__pre_shared_key = None
        self.__local_vti_ip = None
        self.__remote_vti_ip = None
        self.__local_authentication_id = None
        self.__remote_authentication_id = None
        self.__ike_lifetime_secs = None
        self.__ipsec_lifetime_secs = None
        self.__esp_pfs_dh_group_number = None
        self.__ike_encryption_algorithm = None
        self.__ike_authentication_algorithm = None
        self.__ipsec_encryption_algorithm = None
        self.__ipsec_authentication_algorithm = None
        self.discriminator = None
        self.__pre_shared_key = pre_shared_key
        if local_vti_ip is not None:
            self.__local_vti_ip = local_vti_ip
        if remote_vti_ip is not None:
            self.__remote_vti_ip = remote_vti_ip
        if local_authentication_id is not None:
            self.__local_authentication_id = local_authentication_id
        if remote_authentication_id is not None:
            self.__remote_authentication_id = remote_authentication_id
        if ike_lifetime_secs is not None:
            self.__ike_lifetime_secs = ike_lifetime_secs
        if ipsec_lifetime_secs is not None:
            self.__ipsec_lifetime_secs = ipsec_lifetime_secs
        if esp_pfs_dh_group_number is not None:
            self.__esp_pfs_dh_group_number = esp_pfs_dh_group_number
        if ike_encryption_algorithm is not None:
            self.__ike_encryption_algorithm = ike_encryption_algorithm
        if ike_authentication_algorithm is not None:
            self.__ike_authentication_algorithm = ike_authentication_algorithm
        if ipsec_encryption_algorithm is not None:
            self.__ipsec_encryption_algorithm = ipsec_encryption_algorithm
        if ipsec_authentication_algorithm is not None:
            self.__ipsec_authentication_algorithm = ipsec_authentication_algorithm
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'networking.v4.config.IpsecConfig'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.IpsecConfig'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def pre_shared_key(self):
        """`{ str }`
            \nShared secret for authentication between gateway peers
        """ # noqa: E501
        return self.__pre_shared_key

    @pre_shared_key.setter
    def pre_shared_key(self, pre_shared_key):
        if pre_shared_key is None:
            raise ValueError("Invalid value for `pre_shared_key`, must not be `None`")  # noqa: E501

        self.__pre_shared_key = pre_shared_key

    @property
    def local_vti_ip(self):
        """`{ common.v1.config.IPAddress }`
            
        """ # noqa: E501
        return self.__local_vti_ip

    @local_vti_ip.setter
    def local_vti_ip(self, local_vti_ip):

        self.__local_vti_ip = local_vti_ip

    @property
    def remote_vti_ip(self):
        """`{ common.v1.config.IPAddress }`
            
        """ # noqa: E501
        return self.__remote_vti_ip

    @remote_vti_ip.setter
    def remote_vti_ip(self, remote_vti_ip):

        self.__remote_vti_ip = remote_vti_ip

    @property
    def local_authentication_id(self):
        """`{ str }`
            \nLocal IKE authentication Id used for this connection
        """ # noqa: E501
        return self.__local_authentication_id

    @local_authentication_id.setter
    def local_authentication_id(self, local_authentication_id):

        self.__local_authentication_id = local_authentication_id

    @property
    def remote_authentication_id(self):
        """`{ str }`
            \nIKE authentication Id of the remote peer
        """ # noqa: E501
        return self.__remote_authentication_id

    @remote_authentication_id.setter
    def remote_authentication_id(self, remote_authentication_id):

        self.__remote_authentication_id = remote_authentication_id

    @property
    def ike_lifetime_secs(self):
        """`{ int }`
            \nIKE lifetime (seconds)
        """ # noqa: E501
        return self.__ike_lifetime_secs

    @ike_lifetime_secs.setter
    def ike_lifetime_secs(self, ike_lifetime_secs):

        self.__ike_lifetime_secs = ike_lifetime_secs

    @property
    def ipsec_lifetime_secs(self):
        """`{ int }`
            \nIPSec lifetime (seconds)
        """ # noqa: E501
        return self.__ipsec_lifetime_secs

    @ipsec_lifetime_secs.setter
    def ipsec_lifetime_secs(self, ipsec_lifetime_secs):

        self.__ipsec_lifetime_secs = ipsec_lifetime_secs

    @property
    def esp_pfs_dh_group_number(self):
        """`{ int }`
            \nDiffie-Hellman group value of 14, 19 or 20 to be used for Perfect Forward Secrecy (PFS) 
        """ # noqa: E501
        return self.__esp_pfs_dh_group_number

    @esp_pfs_dh_group_number.setter
    def esp_pfs_dh_group_number(self, esp_pfs_dh_group_number):

        self.__esp_pfs_dh_group_number = esp_pfs_dh_group_number

    @property
    def ike_encryption_algorithm(self):
        """`{ networking.v4.config.EncryptionAlgorithm }`
            
        """ # noqa: E501
        return self.__ike_encryption_algorithm

    @ike_encryption_algorithm.setter
    def ike_encryption_algorithm(self, ike_encryption_algorithm):

        self.__ike_encryption_algorithm = ike_encryption_algorithm

    @property
    def ike_authentication_algorithm(self):
        """`{ networking.v4.config.AuthenticationAlgorithm }`
            
        """ # noqa: E501
        return self.__ike_authentication_algorithm

    @ike_authentication_algorithm.setter
    def ike_authentication_algorithm(self, ike_authentication_algorithm):

        self.__ike_authentication_algorithm = ike_authentication_algorithm

    @property
    def ipsec_encryption_algorithm(self):
        """`{ networking.v4.config.EncryptionAlgorithm }`
            
        """ # noqa: E501
        return self.__ipsec_encryption_algorithm

    @ipsec_encryption_algorithm.setter
    def ipsec_encryption_algorithm(self, ipsec_encryption_algorithm):

        self.__ipsec_encryption_algorithm = ipsec_encryption_algorithm

    @property
    def ipsec_authentication_algorithm(self):
        """`{ networking.v4.config.AuthenticationAlgorithm }`
            
        """ # noqa: E501
        return self.__ipsec_authentication_algorithm

    @ipsec_authentication_algorithm.setter
    def ipsec_authentication_algorithm(self, ipsec_authentication_algorithm):

        self.__ipsec_authentication_algorithm = ipsec_authentication_algorithm

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(IpsecConfig, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IpsecConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

