# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.common.v1.config.EntityReference import EntityReference  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.Vtep import Vtep  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class Layer2StretchVtepGatewayInfo(object):
    """Layer2StretchVtepGatewayInfo - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'network_gateway_reference': 'str',
        'network_gateway_name': 'str',
        'is_local': 'bool',
        'vxlan_port': 'int',
        'vteps': 'list[networking.v4.config.Vtep]',
        'cluster_reference': 'common.v1.config.EntityReference',
        'vpc_reference': 'common.v1.config.EntityReference',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'network_gateway_reference': 'networkGatewayReference',
        'network_gateway_name': 'networkGatewayName',
        'is_local': 'isLocal',
        'vxlan_port': 'vxlanPort',
        'vteps': 'vteps',
        'cluster_reference': 'clusterReference',
        'vpc_reference': 'vpcReference',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, network_gateway_reference=None, network_gateway_name=None, is_local=None, vxlan_port=None, vteps=None, cluster_reference=None, vpc_reference=None, *args, **kwargs):  # noqa: E501
        """Layer2StretchVtepGatewayInfo - a model defined in Swagger
            \nInformation about a VTEP gateway.
        """
        self.__network_gateway_reference = None
        self.__network_gateway_name = None
        self.__is_local = None
        self.__vxlan_port = None
        self.__vteps = None
        self.__cluster_reference = None
        self.__vpc_reference = None
        self.discriminator = None
        if network_gateway_reference is not None:
            self.__network_gateway_reference = network_gateway_reference
        if network_gateway_name is not None:
            self.__network_gateway_name = network_gateway_name
        if is_local is not None:
            self.__is_local = is_local
        if vxlan_port is not None:
            self.__vxlan_port = vxlan_port
        if vteps is not None:
            self.__vteps = vteps
        if cluster_reference is not None:
            self.__cluster_reference = cluster_reference
        if vpc_reference is not None:
            self.__vpc_reference = vpc_reference
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'networking.v4.config.Layer2StretchVtepGatewayInfo'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.Layer2StretchVtepGatewayInfo'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def network_gateway_reference(self):
        """`{ str }`
            \nVTEP gateway Id.
        """ # noqa: E501
        return self.__network_gateway_reference

    @network_gateway_reference.setter
    def network_gateway_reference(self, network_gateway_reference):
        if network_gateway_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', network_gateway_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `network_gateway_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__network_gateway_reference = network_gateway_reference

    @property
    def network_gateway_name(self):
        """`{ str }`
            \nVTEP gateway name.
        """ # noqa: E501
        return self.__network_gateway_name

    @network_gateway_name.setter
    def network_gateway_name(self, network_gateway_name):

        self.__network_gateway_name = network_gateway_name

    @property
    def is_local(self):
        """`{ bool }`
            \nIf the value is set to true, VTEP gateway is local. If set to false, VTEP gateway is remote.
        """ # noqa: E501
        return self.__is_local

    @is_local.setter
    def is_local(self, is_local):

        self.__is_local = is_local

    @property
    def vxlan_port(self):
        """`{ int }`
            \nVXLAN port
        """ # noqa: E501
        return self.__vxlan_port

    @vxlan_port.setter
    def vxlan_port(self, vxlan_port):

        self.__vxlan_port = vxlan_port

    @property
    def vteps(self):
        """`{ list[networking.v4.config.Vtep] }`
            
        """ # noqa: E501
        return self.__vteps

    @vteps.setter
    def vteps(self, vteps):

        self.__vteps = vteps

    @property
    def cluster_reference(self):
        """`{ common.v1.config.EntityReference }`
            
        """ # noqa: E501
        return self.__cluster_reference

    @cluster_reference.setter
    def cluster_reference(self, cluster_reference):

        self.__cluster_reference = cluster_reference

    @property
    def vpc_reference(self):
        """`{ common.v1.config.EntityReference }`
            
        """ # noqa: E501
        return self.__vpc_reference

    @vpc_reference.setter
    def vpc_reference(self, vpc_reference):

        self.__vpc_reference = vpc_reference

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(Layer2StretchVtepGatewayInfo, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Layer2StretchVtepGatewayInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

