# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class LocalBgpService(object):
    """LocalBgpService - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'vpc_reference': 'str',
        'asn': 'int',
        'exchange_routes_with_vpn': 'bool',
        'graceful_restart_timeout_seconds': 'int',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'vpc_reference': 'vpcReference',
        'asn': 'asn',
        'exchange_routes_with_vpn': 'exchangeRoutesWithVpn',
        'graceful_restart_timeout_seconds': 'gracefulRestartTimeoutSeconds',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, vpc_reference=None, asn=None, exchange_routes_with_vpn=False, graceful_restart_timeout_seconds=None, *args, **kwargs):  # noqa: E501
        """LocalBgpService - a model defined in Swagger
            \nBGP service hosted on this local gateway.
        """
        self.__vpc_reference = None
        self.__asn = None
        self.__exchange_routes_with_vpn = None
        self.__graceful_restart_timeout_seconds = None
        self.discriminator = None
        if vpc_reference is not None:
            self.__vpc_reference = vpc_reference
        self.__asn = asn
        if exchange_routes_with_vpn is not None:
            self.__exchange_routes_with_vpn = exchange_routes_with_vpn
        if graceful_restart_timeout_seconds is not None:
            self.__graceful_restart_timeout_seconds = graceful_restart_timeout_seconds
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'networking.v4.config.LocalBgpService'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.LocalBgpService'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def vpc_reference(self):
        """`{ str }`
            \nReference to the VPC that this network gateway serves as its BGP speaker.
        """ # noqa: E501
        return self.__vpc_reference

    @vpc_reference.setter
    def vpc_reference(self, vpc_reference):
        if vpc_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', vpc_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `vpc_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__vpc_reference = vpc_reference

    @property
    def asn(self):
        """`{ int }`
            \nAutonomous system number. 0 and 4294967295 are reserved.
        """ # noqa: E501
        return self.__asn

    @asn.setter
    def asn(self, asn):
        if asn is None:
            raise ValueError("Invalid value for `asn`, must not be `None`")  # noqa: E501
        if asn is not None and asn > 4294967294:  # noqa: E501
            raise ValueError("Invalid value for `asn`, must be a value less than or equal to `4294967294`")  # noqa: E501
        if asn is not None and asn < 1:  # noqa: E501
            raise ValueError("Invalid value for `asn`, must be a value greater than or equal to `1`")  # noqa: E501

        self.__asn = asn

    @property
    def exchange_routes_with_vpn(self):
        """`{ bool }`
            \nIf true, routes are exchanged between BGP and VPN services.
        """ # noqa: E501
        return self.__exchange_routes_with_vpn

    @exchange_routes_with_vpn.setter
    def exchange_routes_with_vpn(self, exchange_routes_with_vpn):

        self.__exchange_routes_with_vpn = exchange_routes_with_vpn

    @property
    def graceful_restart_timeout_seconds(self):
        """`{ int }`
            \nBGP graceful restart timeout seconds.
        """ # noqa: E501
        return self.__graceful_restart_timeout_seconds

    @graceful_restart_timeout_seconds.setter
    def graceful_restart_timeout_seconds(self, graceful_restart_timeout_seconds):
        if graceful_restart_timeout_seconds is not None and graceful_restart_timeout_seconds < 0:  # noqa: E501
            raise ValueError("Invalid value for `graceful_restart_timeout_seconds`, must be a value greater than or equal to `0`")  # noqa: E501

        self.__graceful_restart_timeout_seconds = graceful_restart_timeout_seconds

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(LocalBgpService, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LocalBgpService):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

