# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
import ntnx_networking_py_client.Ntnx
from ntnx_networking_py_client.Ntnx.OneOfnetworking.v4.config.NetworkGatewayservices import NetworkGatewayservices  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.common.v1.config.Metadata import Metadata  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.NetworkGatewayDeployment import NetworkGatewayDeployment  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.NetworkingBaseModel import NetworkingBaseModel  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.Status import Status  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class NetworkGateway(NetworkingBaseModel):
    """NetworkGateway - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'vpc_reference': 'str',
        'cloud_network_reference': 'str',
        'installed_software_version': 'str',
        'supported_software_version': 'str',
        'vm_reference': 'str',
        'deployment': 'networking.v4.config.NetworkGatewayDeployment',
        'gateway_device_vendor': 'str',
        'services': 'OneOfnetworking.v4.config.NetworkGatewayservices',
        'status': 'networking.v4.config.Status',
        'metadata': 'common.v1.config.Metadata',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'vpc_reference': 'vpcReference',
        'cloud_network_reference': 'cloudNetworkReference',
        'installed_software_version': 'installedSoftwareVersion',
        'supported_software_version': 'supportedSoftwareVersion',
        'vm_reference': 'vmReference',
        'deployment': 'deployment',
        'gateway_device_vendor': 'gatewayDeviceVendor',
        'services': 'services',
        'status': 'status',
        'metadata': 'metadata',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, name=None, description=None, vpc_reference=None, cloud_network_reference=None, installed_software_version=None, supported_software_version=None, vm_reference=None, deployment=None, gateway_device_vendor=None, services=None, status=None, metadata=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """NetworkGateway - a model defined in Swagger
            \nNetwork gateway
        """
        NetworkingBaseModel.__init__(self, metadata, ext_id, links, tenant_id, *args, **kwargs)
        self.__name = None
        self.__description = None
        self.__vpc_reference = None
        self.__cloud_network_reference = None
        self.__installed_software_version = None
        self.__supported_software_version = None
        self.__vm_reference = None
        self.__deployment = None
        self.__gateway_device_vendor = None
        self.__services = None
        self.__status = None
        self.discriminator = None
        if name is not None:
            self.__name = name
        if description is not None:
            self.__description = description
        if vpc_reference is not None:
            self.__vpc_reference = vpc_reference
        if cloud_network_reference is not None:
            self.__cloud_network_reference = cloud_network_reference
        if installed_software_version is not None:
            self.__installed_software_version = installed_software_version
        if supported_software_version is not None:
            self.__supported_software_version = supported_software_version
        if vm_reference is not None:
            self.__vm_reference = vm_reference
        if deployment is not None:
            self.__deployment = deployment
        if gateway_device_vendor is not None:
            self.__gateway_device_vendor = gateway_device_vendor
        if services is not None:
            self.__services = services
        if status is not None:
            self.__status = status

    def _initialize_object_type(self):
        return 'networking.v4.config.NetworkGateway'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.NetworkGateway'


    @property
    def name(self):
        """`{ str }`
            \nName of the gateway
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):

        self.__name = name

    @property
    def description(self):
        """`{ str }`
            \nDescription of the gateway
        """ # noqa: E501
        return self.__description

    @description.setter
    def description(self, description):

        self.__description = description

    @property
    def vpc_reference(self):
        """`{ str }`
            \nVPC
        """ # noqa: E501
        return self.__vpc_reference

    @vpc_reference.setter
    def vpc_reference(self, vpc_reference):
        if vpc_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', vpc_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `vpc_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__vpc_reference = vpc_reference

    @property
    def cloud_network_reference(self):
        """`{ str }`
            \nCloud network on which network gateway is deployed
        """ # noqa: E501
        return self.__cloud_network_reference

    @cloud_network_reference.setter
    def cloud_network_reference(self, cloud_network_reference):
        if cloud_network_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', cloud_network_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `cloud_network_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__cloud_network_reference = cloud_network_reference

    @property
    def installed_software_version(self):
        """`{ str }`
            \nSoftware version installed on the gateway appliance
        """ # noqa: E501
        return self.__installed_software_version

    @installed_software_version.setter
    def installed_software_version(self, installed_software_version):

        self.__installed_software_version = installed_software_version

    @property
    def supported_software_version(self):
        """`{ str }`
            \nSupported gateway appliance version
        """ # noqa: E501
        return self.__supported_software_version

    @supported_software_version.setter
    def supported_software_version(self, supported_software_version):

        self.__supported_software_version = supported_software_version

    @property
    def vm_reference(self):
        """`{ str }`
            \nReference to a dedicated VM on which a local gateway is deployed 
        """ # noqa: E501
        return self.__vm_reference

    @vm_reference.setter
    def vm_reference(self, vm_reference):

        self.__vm_reference = vm_reference

    @property
    def deployment(self):
        """`{ networking.v4.config.NetworkGatewayDeployment }`
            
        """ # noqa: E501
        return self.__deployment

    @deployment.setter
    def deployment(self, deployment):

        self.__deployment = deployment

    @property
    def gateway_device_vendor(self):
        """`{ str }`
            \nThird-party gateway vendor
        """ # noqa: E501
        return self.__gateway_device_vendor

    @gateway_device_vendor.setter
    def gateway_device_vendor(self, gateway_device_vendor):

        self.__gateway_device_vendor = gateway_device_vendor

    @property
    def services(self):
        """`{ networking.v4.config.LocalNetworkServices | networking.v4.config.RemoteNetworkServices }`
            
        """ # noqa: E501
        return self.__services

    @services.setter
    def services(self, services):

        self.__services = services

    @property
    def status(self):
        """`{ networking.v4.config.Status }`
            
        """ # noqa: E501
        return self.__status

    @status.setter
    def status(self, status):

        self.__status = status

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if attr_type.startswith('OneOf'):
                type = getattr(ntnx_networking_py_client.Ntnx, attr_type.split('.')[-1])
                if hasattr(type, 'get_discriminator_from_object'):
                    result[type.ONE_OF_ITEM_DISCRIMINATOR_NAME] = type.get_discriminator_from_object(value)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(NetworkGateway, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetworkGateway):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

