# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.common.v1.config.IPAddress import IPAddress  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.IPSubnet import IPSubnet  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.NexthopType import NexthopType  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class Route(object):
    """Route - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'active': 'bool',
        'priority': 'int',
        'destination': 'networking.v4.config.IPSubnet',
        'nexthop_type': 'networking.v4.config.NexthopType',
        'nexthop_reference': 'str',
        'nexthop_ip_address': 'common.v1.config.IPAddress',
        'nexthop_name': 'str',
        'source': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'active': 'active',
        'priority': 'priority',
        'destination': 'destination',
        'nexthop_type': 'nexthopType',
        'nexthop_reference': 'nexthopReference',
        'nexthop_ip_address': 'nexthopIpAddress',
        'nexthop_name': 'nexthopName',
        'source': 'source',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, active=None, priority=None, destination=None, nexthop_type=None, nexthop_reference=None, nexthop_ip_address=None, nexthop_name=None, source=None, *args, **kwargs):  # noqa: E501
        """Route - a model defined in Swagger
            \nRoute.
        """
        self.__active = None
        self.__priority = None
        self.__destination = None
        self.__nexthop_type = None
        self.__nexthop_reference = None
        self.__nexthop_ip_address = None
        self.__nexthop_name = None
        self.__source = None
        self.discriminator = None
        if active is not None:
            self.__active = active
        if priority is not None:
            self.__priority = priority
        self.__destination = destination
        self.__nexthop_type = nexthop_type
        if nexthop_reference is not None:
            self.__nexthop_reference = nexthop_reference
        if nexthop_ip_address is not None:
            self.__nexthop_ip_address = nexthop_ip_address
        if nexthop_name is not None:
            self.__nexthop_name = nexthop_name
        if source is not None:
            self.__source = source
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'networking.v4.config.Route'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.Route'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def active(self):
        """`{ bool }`
            \nIndicates whether the route is active or inactive.
        """ # noqa: E501
        return self.__active

    @active.setter
    def active(self, active):

        self.__active = active

    @property
    def priority(self):
        """`{ int }`
            \nRoute priority. A higher value implies greater preference is assigned to the route.
        """ # noqa: E501
        return self.__priority

    @priority.setter
    def priority(self, priority):

        self.__priority = priority

    @property
    def destination(self):
        """`{ networking.v4.config.IPSubnet }`
            
        """ # noqa: E501
        return self.__destination

    @destination.setter
    def destination(self, destination):
        if destination is None:
            raise ValueError("Invalid value for `destination`, must not be `None`")  # noqa: E501

        self.__destination = destination

    @property
    def nexthop_type(self):
        """`{ networking.v4.config.NexthopType }`
            
        """ # noqa: E501
        return self.__nexthop_type

    @nexthop_type.setter
    def nexthop_type(self, nexthop_type):
        if nexthop_type is None:
            raise ValueError("Invalid value for `nexthop_type`, must not be `None`")  # noqa: E501

        self.__nexthop_type = nexthop_type

    @property
    def nexthop_reference(self):
        """`{ str }`
            \nThe reference to a link, such as a VPN connection or a subnet.
        """ # noqa: E501
        return self.__nexthop_reference

    @nexthop_reference.setter
    def nexthop_reference(self, nexthop_reference):
        if nexthop_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', nexthop_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `nexthop_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__nexthop_reference = nexthop_reference

    @property
    def nexthop_ip_address(self):
        """`{ common.v1.config.IPAddress }`
            
        """ # noqa: E501
        return self.__nexthop_ip_address

    @nexthop_ip_address.setter
    def nexthop_ip_address(self, nexthop_ip_address):

        self.__nexthop_ip_address = nexthop_ip_address

    @property
    def nexthop_name(self):
        """`{ str }`
            \nName of the next hop, where the next hop is either a VPN connection, direct connect virtual interface, or a subnet.  
        """ # noqa: E501
        return self.__nexthop_name

    @nexthop_name.setter
    def nexthop_name(self, nexthop_name):

        self.__nexthop_name = nexthop_name

    @property
    def source(self):
        """`{ str }`
            \nThe source of a dynamic route is either a VPN connection, direct connect virtual interface, or a BGP session. 
        """ # noqa: E501
        return self.__source

    @source.setter
    def source(self, source):

        self.__source = source

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(Route, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Route):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

