# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.BondModeType import BondModeType  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.Cluster import Cluster  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class VirtualSwitch(ExternalizableAbstractModel):
    """VirtualSwitch - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'is_default': 'bool',
        'quick_mode': 'bool',
        'deployment_error': 'bool',
        'mtu': 'int',
        'bond_mode': 'networking.v4.config.BondModeType',
        'clusters': 'list[networking.v4.config.Cluster]',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'is_default': 'isDefault',
        'quick_mode': 'quickMode',
        'deployment_error': 'deploymentError',
        'mtu': 'mtu',
        'bond_mode': 'bondMode',
        'clusters': 'clusters',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, name=None, description=None, is_default=False, quick_mode=False, deployment_error=None, mtu=None, bond_mode=None, clusters=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """VirtualSwitch - a model defined in Swagger
            \nSchema to configure a virtual switch
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__name = None
        self.__description = None
        self.__is_default = None
        self.__quick_mode = None
        self.__deployment_error = None
        self.__mtu = None
        self.__bond_mode = None
        self.__clusters = None
        self.discriminator = None
        self.__name = name
        if description is not None:
            self.__description = description
        if is_default is not None:
            self.__is_default = is_default
        if quick_mode is not None:
            self.__quick_mode = quick_mode
        if deployment_error is not None:
            self.__deployment_error = deployment_error
        if mtu is not None:
            self.__mtu = mtu
        self.__bond_mode = bond_mode
        self.__clusters = clusters

    def _initialize_object_type(self):
        return 'networking.v4.config.VirtualSwitch'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.VirtualSwitch'


    @property
    def name(self):
        """`{ str }`
            \nUser-visible Virtual Switch name
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if name is not None and len(name) > 128:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `128`")  # noqa: E501

        self.__name = name

    @property
    def description(self):
        """`{ str }`
            \nInput body to configure a Virtual Switch
        """ # noqa: E501
        return self.__description

    @description.setter
    def description(self, description):
        if description is not None and len(description) > 1000:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `1000`")  # noqa: E501

        self.__description = description

    @property
    def is_default(self):
        """`{ bool }`
            \nIndicates whether it is a default Virtual Switch which cannot be deleted
        """ # noqa: E501
        return self.__is_default

    @is_default.setter
    def is_default(self, is_default):

        self.__is_default = is_default

    @property
    def quick_mode(self):
        """`{ bool }`
            \nWhen true, the node is not put in maintenance mode during the create/update operation.
        """ # noqa: E501
        return self.__quick_mode

    @quick_mode.setter
    def quick_mode(self, quick_mode):

        self.__quick_mode = quick_mode

    @property
    def deployment_error(self):
        """`{ bool }`
            \nWhen true, virtual switch configuration is not deployed on every node.
        """ # noqa: E501
        return self.__deployment_error

    @deployment_error.setter
    def deployment_error(self, deployment_error):

        self.__deployment_error = deployment_error

    @property
    def mtu(self):
        """`{ int }`
            \nMTU
        """ # noqa: E501
        return self.__mtu

    @mtu.setter
    def mtu(self, mtu):

        self.__mtu = mtu

    @property
    def bond_mode(self):
        """`{ networking.v4.config.BondModeType }`
            
        """ # noqa: E501
        return self.__bond_mode

    @bond_mode.setter
    def bond_mode(self, bond_mode):
        if bond_mode is None:
            raise ValueError("Invalid value for `bond_mode`, must not be `None`")  # noqa: E501

        self.__bond_mode = bond_mode

    @property
    def clusters(self):
        """`{ list[networking.v4.config.Cluster] }`
            \nCluster configuration list
        """ # noqa: E501
        return self.__clusters

    @clusters.setter
    def clusters(self, clusters):
        if clusters is None:
            raise ValueError("Invalid value for `clusters`, must not be `None`")  # noqa: E501

        self.__clusters = clusters

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(VirtualSwitch, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualSwitch):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

