# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.common.v1.config.IPAddress import IPAddress  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.common.v1.config.Metadata import Metadata  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.ExternalSubnet import ExternalSubnet  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.IPSubnet import IPSubnet  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.NetworkingBaseModel import NetworkingBaseModel  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.VpcDhcpOptions import VpcDhcpOptions  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class Vpc(NetworkingBaseModel):
    """Vpc - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'common_dhcp_options': 'networking.v4.config.VpcDhcpOptions',
        'snat_ips': 'list[common.v1.config.IPAddress]',
        'external_subnets': 'list[networking.v4.config.ExternalSubnet]',
        'external_routing_domain_reference': 'str',
        'externally_routable_prefixes': 'list[networking.v4.config.IPSubnet]',
        'metadata': 'common.v1.config.Metadata',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'common_dhcp_options': 'commonDhcpOptions',
        'snat_ips': 'snatIps',
        'external_subnets': 'externalSubnets',
        'external_routing_domain_reference': 'externalRoutingDomainReference',
        'externally_routable_prefixes': 'externallyRoutablePrefixes',
        'metadata': 'metadata',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, name=None, description=None, common_dhcp_options=None, snat_ips=None, external_subnets=None, external_routing_domain_reference=None, externally_routable_prefixes=None, metadata=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """Vpc - a model defined in Swagger
            
        """
        NetworkingBaseModel.__init__(self, metadata, ext_id, links, tenant_id, *args, **kwargs)
        self.__name = None
        self.__description = None
        self.__common_dhcp_options = None
        self.__snat_ips = None
        self.__external_subnets = None
        self.__external_routing_domain_reference = None
        self.__externally_routable_prefixes = None
        self.discriminator = None
        self.__name = name
        if description is not None:
            self.__description = description
        if common_dhcp_options is not None:
            self.__common_dhcp_options = common_dhcp_options
        if snat_ips is not None:
            self.__snat_ips = snat_ips
        if external_subnets is not None:
            self.__external_subnets = external_subnets
        if external_routing_domain_reference is not None:
            self.__external_routing_domain_reference = external_routing_domain_reference
        if externally_routable_prefixes is not None:
            self.__externally_routable_prefixes = externally_routable_prefixes

    def _initialize_object_type(self):
        return 'networking.v4.config.Vpc'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.Vpc'


    @property
    def name(self):
        """`{ str }`
            \nName of the VPC.
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if name is not None and len(name) > 128:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `128`")  # noqa: E501

        self.__name = name

    @property
    def description(self):
        """`{ str }`
            \nDescription of the VPC.
        """ # noqa: E501
        return self.__description

    @description.setter
    def description(self, description):
        if description is not None and len(description) > 1000:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `1000`")  # noqa: E501

        self.__description = description

    @property
    def common_dhcp_options(self):
        """`{ networking.v4.config.VpcDhcpOptions }`
            
        """ # noqa: E501
        return self.__common_dhcp_options

    @common_dhcp_options.setter
    def common_dhcp_options(self, common_dhcp_options):

        self.__common_dhcp_options = common_dhcp_options

    @property
    def snat_ips(self):
        """`{ list[common.v1.config.IPAddress] }`
            \nList of IP Addresses used for SNAT.
        """ # noqa: E501
        return self.__snat_ips

    @snat_ips.setter
    def snat_ips(self, snat_ips):

        self.__snat_ips = snat_ips

    @property
    def external_subnets(self):
        """`{ list[networking.v4.config.ExternalSubnet] }`
            \nList of external subnets that the VPC is attached to.
        """ # noqa: E501
        return self.__external_subnets

    @external_subnets.setter
    def external_subnets(self, external_subnets):

        self.__external_subnets = external_subnets

    @property
    def external_routing_domain_reference(self):
        """`{ str }`
            \nThe external routing domain UUID
        """ # noqa: E501
        return self.__external_routing_domain_reference

    @external_routing_domain_reference.setter
    def external_routing_domain_reference(self, external_routing_domain_reference):
        if external_routing_domain_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', external_routing_domain_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `external_routing_domain_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__external_routing_domain_reference = external_routing_domain_reference

    @property
    def externally_routable_prefixes(self):
        """`{ list[networking.v4.config.IPSubnet] }`
            \nCIDR blocks from the VPC which can talk externally without performing NAT. This is applicable when connecting to external subnets which have disabled NAT.
        """ # noqa: E501
        return self.__externally_routable_prefixes

    @externally_routable_prefixes.setter
    def externally_routable_prefixes(self, externally_routable_prefixes):

        self.__externally_routable_prefixes = externally_routable_prefixes

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(Vpc, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Vpc):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

