# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_networking_py_client.Ntnx.common.v1.config.Metadata import Metadata  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.DpdConfig import DpdConfig  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.GatewayRole import GatewayRole  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.IPSubnet import IPSubnet  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.IpsecConfig import IpsecConfig  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.NetworkingBaseModel import NetworkingBaseModel  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.QosConfig import QosConfig  # noqa: F401,E501
from ntnx_networking_py_client.Ntnx.networking.v4.config.Status import Status  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class VpnConnection(NetworkingBaseModel):
    """VpnConnection - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'local_network_gateway_reference': 'str',
        'remote_network_gateway_reference': 'str',
        'ipsec_config': 'networking.v4.config.IpsecConfig',
        'dpd_config': 'networking.v4.config.DpdConfig',
        'qos_config': 'networking.v4.config.QosConfig',
        'local_gateway_role': 'networking.v4.config.GatewayRole',
        'dynamic_route_priority': 'int',
        'advertised_prefixes': 'list[networking.v4.config.IPSubnet]',
        'learned_prefixes': 'list[networking.v4.config.IPSubnet]',
        'ipsec_tunnel_status': 'networking.v4.config.Status',
        'ebgp_status': 'networking.v4.config.Status',
        'metadata': 'common.v1.config.Metadata',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'local_network_gateway_reference': 'localNetworkGatewayReference',
        'remote_network_gateway_reference': 'remoteNetworkGatewayReference',
        'ipsec_config': 'ipsecConfig',
        'dpd_config': 'dpdConfig',
        'qos_config': 'qosConfig',
        'local_gateway_role': 'localGatewayRole',
        'dynamic_route_priority': 'dynamicRoutePriority',
        'advertised_prefixes': 'advertisedPrefixes',
        'learned_prefixes': 'learnedPrefixes',
        'ipsec_tunnel_status': 'ipsecTunnelStatus',
        'ebgp_status': 'ebgpStatus',
        'metadata': 'metadata',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, name=None, description=None, local_network_gateway_reference=None, remote_network_gateway_reference=None, ipsec_config=None, dpd_config=None, qos_config=None, local_gateway_role=None, dynamic_route_priority=None, advertised_prefixes=None, learned_prefixes=None, ipsec_tunnel_status=None, ebgp_status=None, metadata=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """VpnConnection - a model defined in Swagger
            \nVPN connection
        """
        NetworkingBaseModel.__init__(self, metadata, ext_id, links, tenant_id, *args, **kwargs)
        self.__name = None
        self.__description = None
        self.__local_network_gateway_reference = None
        self.__remote_network_gateway_reference = None
        self.__ipsec_config = None
        self.__dpd_config = None
        self.__qos_config = None
        self.__local_gateway_role = None
        self.__dynamic_route_priority = None
        self.__advertised_prefixes = None
        self.__learned_prefixes = None
        self.__ipsec_tunnel_status = None
        self.__ebgp_status = None
        self.discriminator = None
        if name is not None:
            self.__name = name
        if description is not None:
            self.__description = description
        self.__local_network_gateway_reference = local_network_gateway_reference
        self.__remote_network_gateway_reference = remote_network_gateway_reference
        self.__ipsec_config = ipsec_config
        if dpd_config is not None:
            self.__dpd_config = dpd_config
        if qos_config is not None:
            self.__qos_config = qos_config
        self.__local_gateway_role = local_gateway_role
        if dynamic_route_priority is not None:
            self.__dynamic_route_priority = dynamic_route_priority
        if advertised_prefixes is not None:
            self.__advertised_prefixes = advertised_prefixes
        if learned_prefixes is not None:
            self.__learned_prefixes = learned_prefixes
        if ipsec_tunnel_status is not None:
            self.__ipsec_tunnel_status = ipsec_tunnel_status
        if ebgp_status is not None:
            self.__ebgp_status = ebgp_status

    def _initialize_object_type(self):
        return 'networking.v4.config.VpnConnection'

    def _initialize_fq_object_type(self):
        return 'networking.v4.r0.a1.config.VpnConnection'


    @property
    def name(self):
        """`{ str }`
            \nVPN connection name
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is not None and len(name) > 128:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `128`")  # noqa: E501

        self.__name = name

    @property
    def description(self):
        """`{ str }`
            \nVPN connection description
        """ # noqa: E501
        return self.__description

    @description.setter
    def description(self, description):
        if description is not None and len(description) > 1000:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `1000`")  # noqa: E501

        self.__description = description

    @property
    def local_network_gateway_reference(self):
        """`{ str }`
            \nThe local VPN gateway reference
        """ # noqa: E501
        return self.__local_network_gateway_reference

    @local_network_gateway_reference.setter
    def local_network_gateway_reference(self, local_network_gateway_reference):
        if local_network_gateway_reference is None:
            raise ValueError("Invalid value for `local_network_gateway_reference`, must not be `None`")  # noqa: E501
        if local_network_gateway_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', local_network_gateway_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `local_network_gateway_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__local_network_gateway_reference = local_network_gateway_reference

    @property
    def remote_network_gateway_reference(self):
        """`{ str }`
            \nThe remote VPN gateway reference
        """ # noqa: E501
        return self.__remote_network_gateway_reference

    @remote_network_gateway_reference.setter
    def remote_network_gateway_reference(self, remote_network_gateway_reference):
        if remote_network_gateway_reference is None:
            raise ValueError("Invalid value for `remote_network_gateway_reference`, must not be `None`")  # noqa: E501
        if remote_network_gateway_reference is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', remote_network_gateway_reference):  # noqa: E501
            raise ValueError(r"Invalid value for `remote_network_gateway_reference`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__remote_network_gateway_reference = remote_network_gateway_reference

    @property
    def ipsec_config(self):
        """`{ networking.v4.config.IpsecConfig }`
            
        """ # noqa: E501
        return self.__ipsec_config

    @ipsec_config.setter
    def ipsec_config(self, ipsec_config):
        if ipsec_config is None:
            raise ValueError("Invalid value for `ipsec_config`, must not be `None`")  # noqa: E501

        self.__ipsec_config = ipsec_config

    @property
    def dpd_config(self):
        """`{ networking.v4.config.DpdConfig }`
            
        """ # noqa: E501
        return self.__dpd_config

    @dpd_config.setter
    def dpd_config(self, dpd_config):

        self.__dpd_config = dpd_config

    @property
    def qos_config(self):
        """`{ networking.v4.config.QosConfig }`
            
        """ # noqa: E501
        return self.__qos_config

    @qos_config.setter
    def qos_config(self, qos_config):

        self.__qos_config = qos_config

    @property
    def local_gateway_role(self):
        """`{ networking.v4.config.GatewayRole }`
            
        """ # noqa: E501
        return self.__local_gateway_role

    @local_gateway_role.setter
    def local_gateway_role(self, local_gateway_role):
        if local_gateway_role is None:
            raise ValueError("Invalid value for `local_gateway_role`, must not be `None`")  # noqa: E501

        self.__local_gateway_role = local_gateway_role

    @property
    def dynamic_route_priority(self):
        """`{ int }`
            \nPriority assigned to routes received on this connection over eBGP. A higher priority value indicates that the routes are more preferred 
        """ # noqa: E501
        return self.__dynamic_route_priority

    @dynamic_route_priority.setter
    def dynamic_route_priority(self, dynamic_route_priority):
        if dynamic_route_priority is not None and dynamic_route_priority > 1000:  # noqa: E501
            raise ValueError("Invalid value for `dynamic_route_priority`, must be a value less than or equal to `1000`")  # noqa: E501
        if dynamic_route_priority is not None and dynamic_route_priority < 10:  # noqa: E501
            raise ValueError("Invalid value for `dynamic_route_priority`, must be a value greater than or equal to `10`")  # noqa: E501

        self.__dynamic_route_priority = dynamic_route_priority

    @property
    def advertised_prefixes(self):
        """`{ list[networking.v4.config.IPSubnet] }`
            \nIP prefixes advertised to the remote gateway over BGP.
        """ # noqa: E501
        return self.__advertised_prefixes

    @advertised_prefixes.setter
    def advertised_prefixes(self, advertised_prefixes):

        self.__advertised_prefixes = advertised_prefixes

    @property
    def learned_prefixes(self):
        """`{ list[networking.v4.config.IPSubnet] }`
            \nIP prefixes learned from the remote gateway over BGP.
        """ # noqa: E501
        return self.__learned_prefixes

    @learned_prefixes.setter
    def learned_prefixes(self, learned_prefixes):

        self.__learned_prefixes = learned_prefixes

    @property
    def ipsec_tunnel_status(self):
        """`{ networking.v4.config.Status }`
            
        """ # noqa: E501
        return self.__ipsec_tunnel_status

    @ipsec_tunnel_status.setter
    def ipsec_tunnel_status(self, ipsec_tunnel_status):

        self.__ipsec_tunnel_status = ipsec_tunnel_status

    @property
    def ebgp_status(self):
        """`{ networking.v4.config.Status }`
            
        """ # noqa: E501
        return self.__ebgp_status

    @ebgp_status.setter
    def ebgp_status(self, ebgp_status):

        self.__ebgp_status = ebgp_status

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(VpnConnection, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VpnConnection):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

