# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_networking_py_client.api_client import ApiClient


class IPFIXExporterApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_ipfix_exporter(self, body, **kwargs):  # noqa: E501
        """Create an IPFIX Exporter.
        Create an IPFIX Exporter.

        >>> response = api.create_ipfix_exporter(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_ipfix_exporter(body, async_req=True)
        >>> result = thread.get()

        :param networking.v4.config.IPFIXExporter body: Request schema to create the IPFIX exporter. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ipfix_exporter_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ipfix_exporter_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_ipfix_exporter_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create an IPFIX Exporter.
        Create an IPFIX Exporter.

        >>> response = api.create_ipfix_exporter(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_ipfix_exporter_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param networking.v4.config.IPFIXExporter body: Request schema to create the IPFIX exporter. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ipfix_exporter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_ipfix_exporter`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/ipfix-exporters', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.TaskReferenceApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ipfix_exporter(self, extId, **kwargs):  # noqa: E501
        """Delete the specified IPFIX Exporter.
        Delete the specified IPFIX exporter.

        >>> response = api.delete_ipfix_exporter(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ipfix_exporter(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: UUID of IPFIX exporter. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ipfix_exporter_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ipfix_exporter_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def delete_ipfix_exporter_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Delete the specified IPFIX Exporter.
        Delete the specified IPFIX exporter.

        >>> response = api.delete_ipfix_exporter(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ipfix_exporter_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: UUID of IPFIX exporter. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ipfix_exporter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `delete_ipfix_exporter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/ipfix-exporters/{extId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.TaskReferenceApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ipfix_exporter(self, extId, **kwargs):  # noqa: E501
        """Get the specified IPFIX Exporter.
        The UUID of the IPFIX exporter.

        >>> response = api.get_ipfix_exporter(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ipfix_exporter(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: UUID of IPFIX exporter. (required)
        :param bool async_req:
        :return: networking.v4.config.IPFIXExporterApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ipfix_exporter_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ipfix_exporter_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def get_ipfix_exporter_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Get the specified IPFIX Exporter.
        The UUID of the IPFIX exporter.

        >>> response = api.get_ipfix_exporter(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ipfix_exporter_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: UUID of IPFIX exporter. (required)
        :param bool async_req:
        :return: networking.v4.config.IPFIXExporterApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ipfix_exporter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_ipfix_exporter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/ipfix-exporters/{extId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.IPFIXExporterApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_ipfix_exporters(self, **kwargs):  # noqa: E501
        """Get the list of existing IPFIX Exporters.
        Get the list of existing IPFIX exporters.

        >>> response = api.list_ipfix_exporters()

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_ipfix_exporters(async_req=True)
        >>> result = thread.get()

        :param bool async_req:
        :return: networking.v4.config.IPFIXExporterListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_ipfix_exporters_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_ipfix_exporters_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_ipfix_exporters_with_http_info(self, **kwargs):  # noqa: E501
        """Get the list of existing IPFIX Exporters.
        Get the list of existing IPFIX exporters.

        >>> response = api.list_ipfix_exporters()

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_ipfix_exporters_with_http_info(async_req=True)
        >>> result = thread.get()

        :param bool async_req:
        :return: networking.v4.config.IPFIXExporterListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_ipfix_exporters" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/ipfix-exporters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.IPFIXExporterListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ipfix_exporter(self, body, extId, **kwargs):  # noqa: E501
        """Update the specified IPFIX Exporter.
        Update the specified IPFIX exporter.

        >>> response = api.update_ipfix_exporter(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_ipfix_exporter(body, extId, async_req=True)
        >>> result = thread.get()

        :param networking.v4.config.IPFIXExporter body: Request schema to update the specified IPFIX exporter. (required)
        :param str extId: UUID of IPFIX exporter. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ipfix_exporter_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ipfix_exporter_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def update_ipfix_exporter_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Update the specified IPFIX Exporter.
        Update the specified IPFIX exporter.

        >>> response = api.update_ipfix_exporter(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_ipfix_exporter_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param networking.v4.config.IPFIXExporter body: Request schema to update the specified IPFIX exporter. (required)
        :param str extId: UUID of IPFIX exporter. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ipfix_exporter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_ipfix_exporter`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `update_ipfix_exporter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/ipfix-exporters/{extId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.TaskReferenceApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
