# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_networking_py_client.api_client import ApiClient


class Layer2StretchStatsApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_layer2_stretch_stats(self, extId, **kwargs):  # noqa: E501
        """Get Layer2Stretch statistics
        Get Layer2Stretch statistics

        >>> response = api.get_layer2_stretch_stats(extId, (optional) _startTime, (optional) _endTime, (optional) _samplingInterval, (optional) _statType, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_layer2_stretch_stats(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: The UUID of the Layer2Stretch configuration. (required)
        :param str _startTime: The start time of the period for which stats should be reported. The value should be in extended ISO-8601 format. For example, start time of 2022-04-23T01:23:45.678+09:00 would consider all stats starting at 1:23:45.678 on the 23rd of April 2022. Details around ISO-8601 format can be found at https://www.iso.org/standard/70907.html

        :param str _endTime: The end time of the period for which stats should be reported. The value should be in extended ISO-8601 format. For example, end time of 2022-04-23T013:23:45.678+09:00 would consider all stats till 13:23:45 .678 on the 23rd of April 2022. Details around ISO-8601 format can be found at https://www.iso.org/standard/70907.html

        :param int _samplingInterval: The sampling interval in seconds at which statistical data should be collected For example, do you want performance statistics every 30 seconds? Every 60 seconds?

        :param common.v1.stats.DownSamplingOperator _statType:
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- entityUuid
- extId
- links
- rtt
- statType
- tenantId
- throughputRxKbps
- throughputTxKbps

        :param bool async_req:
        :return: networking.v4.stats.Layer2StretchStatsApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_layer2_stretch_stats_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_layer2_stretch_stats_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def get_layer2_stretch_stats_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Get Layer2Stretch statistics
        Get Layer2Stretch statistics

        >>> response = api.get_layer2_stretch_stats(extId, (optional) _startTime, (optional) _endTime, (optional) _samplingInterval, (optional) _statType, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_layer2_stretch_stats_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: The UUID of the Layer2Stretch configuration. (required)
        :param str _startTime: The start time of the period for which stats should be reported. The value should be in extended ISO-8601 format. For example, start time of 2022-04-23T01:23:45.678+09:00 would consider all stats starting at 1:23:45.678 on the 23rd of April 2022. Details around ISO-8601 format can be found at https://www.iso.org/standard/70907.html

        :param str _endTime: The end time of the period for which stats should be reported. The value should be in extended ISO-8601 format. For example, end time of 2022-04-23T013:23:45.678+09:00 would consider all stats till 13:23:45 .678 on the 23rd of April 2022. Details around ISO-8601 format can be found at https://www.iso.org/standard/70907.html

        :param int _samplingInterval: The sampling interval in seconds at which statistical data should be collected For example, do you want performance statistics every 30 seconds? Every 60 seconds?

        :param common.v1.stats.DownSamplingOperator _statType:
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- entityUuid
- extId
- links
- rtt
- statType
- tenantId
- throughputRxKbps
- throughputTxKbps

        :param bool async_req:
        :return: networking.v4.stats.Layer2StretchStatsApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId', '_startTime', '_endTime', '_samplingInterval', '_statType', '_select']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_layer2_stretch_stats" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_layer2_stretch_stats`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []
        if '_startTime' in params:
            query_params.append(('$startTime', params['_startTime']))  # noqa: E501
        if '_endTime' in params:
            query_params.append(('$endTime', params['_endTime']))  # noqa: E501
        if '_samplingInterval' in params:
            query_params.append(('$samplingInterval', params['_samplingInterval']))  # noqa: E501
        if '_statType' in params:
            query_params.append(('$statType', params['_statType']))  # noqa: E501
        if '_select' in params:
            query_params.append(('$select', params['_select']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/stats/layer2-stretches/{extId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.stats.Layer2StretchStatsApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
