# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_networking_py_client.api_client import ApiClient


class SubnetReserveUnreserveIpApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def fetch_subnet_address_assignments(self, subnetExtId, **kwargs):  # noqa: E501
        """Get the list of assigned and reserved IP addresses on a subnet.
        Get the list of assigned and reserved IP addresses on a subnet.

        >>> response = api.fetch_subnet_address_assignments(subnetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_subnet_address_assignments(subnetExtId, async_req=True)
        >>> result = thread.get()

        :param str subnetExtId: Subnet ExtID (required)
        :param bool async_req:
        :return: networking.v4.config.SubnetAddressAssignmentListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.fetch_subnet_address_assignments_with_http_info(subnetExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.fetch_subnet_address_assignments_with_http_info(subnetExtId, **kwargs)  # noqa: E501
            return data

    def fetch_subnet_address_assignments_with_http_info(self, subnetExtId, **kwargs):  # noqa: E501
        """Get the list of assigned and reserved IP addresses on a subnet.
        Get the list of assigned and reserved IP addresses on a subnet.

        >>> response = api.fetch_subnet_address_assignments(subnetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_subnet_address_assignments_with_http_info(subnetExtId, async_req=True)
        >>> result = thread.get()

        :param str subnetExtId: Subnet ExtID (required)
        :param bool async_req:
        :return: networking.v4.config.SubnetAddressAssignmentListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subnetExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fetch_subnet_address_assignments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subnetExtId' is set
        if ('subnetExtId' not in params or
                params['subnetExtId'] is None):
            raise ValueError("Missing the required parameter `subnetExtId` when calling `fetch_subnet_address_assignments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subnetExtId' in params:
            path_params['subnetExtId'] = params['subnetExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/subnets/{subnetExtId}/addresses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.SubnetAddressAssignmentListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reserve_ips(self, body, subnetExtId, **kwargs):  # noqa: E501
        """Reserve IP addresses on a subnet.
        Reserve IP addresses on a subnet.

        >>> response = api.reserve_ips(body, subnetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reserve_ips(body, subnetExtId, async_req=True)
        >>> result = thread.get()

        :param networking.v4.config.IpReserveInput body: Request schema to reserve IP addresses on a subnet. (required)
        :param str subnetExtId: The UUID of the subnet. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reserve_ips_with_http_info(body, subnetExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.reserve_ips_with_http_info(body, subnetExtId, **kwargs)  # noqa: E501
            return data

    def reserve_ips_with_http_info(self, body, subnetExtId, **kwargs):  # noqa: E501
        """Reserve IP addresses on a subnet.
        Reserve IP addresses on a subnet.

        >>> response = api.reserve_ips(body, subnetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reserve_ips_with_http_info(body, subnetExtId, async_req=True)
        >>> result = thread.get()

        :param networking.v4.config.IpReserveInput body: Request schema to reserve IP addresses on a subnet. (required)
        :param str subnetExtId: The UUID of the subnet. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'subnetExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reserve_ips" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `reserve_ips`")  # noqa: E501
        # verify the required parameter 'subnetExtId' is set
        if ('subnetExtId' not in params or
                params['subnetExtId'] is None):
            raise ValueError("Missing the required parameter `subnetExtId` when calling `reserve_ips`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subnetExtId' in params:
            path_params['subnetExtId'] = params['subnetExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/subnets/{subnetExtId}/addresses/$actions/reserve', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.TaskReferenceApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unreserve_ips(self, body, subnetExtId, **kwargs):  # noqa: E501
        """Unreserve IP addresses on a subnet.
        Unreserve IP addresses on a subnet.

        >>> response = api.unreserve_ips(body, subnetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unreserve_ips(body, subnetExtId, async_req=True)
        >>> result = thread.get()

        :param networking.v4.config.IpUnreserveInput body: Request schema to unreserve IP addresses on a subnet. (required)
        :param str subnetExtId: The UUID of the subnet. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unreserve_ips_with_http_info(body, subnetExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.unreserve_ips_with_http_info(body, subnetExtId, **kwargs)  # noqa: E501
            return data

    def unreserve_ips_with_http_info(self, body, subnetExtId, **kwargs):  # noqa: E501
        """Unreserve IP addresses on a subnet.
        Unreserve IP addresses on a subnet.

        >>> response = api.unreserve_ips(body, subnetExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unreserve_ips_with_http_info(body, subnetExtId, async_req=True)
        >>> result = thread.get()

        :param networking.v4.config.IpUnreserveInput body: Request schema to unreserve IP addresses on a subnet. (required)
        :param str subnetExtId: The UUID of the subnet. (required)
        :param bool async_req:
        :return: networking.v4.config.TaskReferenceApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'subnetExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unreserve_ips" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `unreserve_ips`")  # noqa: E501
        # verify the required parameter 'subnetExtId' is set
        if ('subnetExtId' not in params or
                params['subnetExtId'] is None):
            raise ValueError("Missing the required parameter `subnetExtId` when calling `unreserve_ips`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subnetExtId' in params:
            path_params['subnetExtId'] = params['subnetExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/subnets/{subnetExtId}/addresses/$actions/unreserve', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.TaskReferenceApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
