# coding: utf-8


"""
IGNORE:
    Nutanix Networking Versioned APIs

    Manage networking configuration on Nutanix clusters, including AHV and advanced networking.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_networking_py_client.api_client import ApiClient


class VpnVendorConfigApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_vpn_vendor_config(self, vpnConnectionId, vendorName, **kwargs):  # noqa: E501
        """Get VPN vendor device configuration steps.
        Get VPN vendor device configuration steps. If device version is not specified the configuration steps of the latest available device version are returned.

        >>> response = api.get_vpn_vendor_config(vpnConnectionId, vendorName, (optional) deviceVersion)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vpn_vendor_config(vpnConnectionId, vendorName, async_req=True)
        >>> result = thread.get()

        :param str vpnConnectionId: VPN connection UUID. (required)
        :param str vendorName: VPN device vendor name. (required)
        :param str deviceVersion: VPN device version.
        :param bool async_req:
        :return: str

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vpn_vendor_config_with_http_info(vpnConnectionId, vendorName, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vpn_vendor_config_with_http_info(vpnConnectionId, vendorName, **kwargs)  # noqa: E501
            return data

    def get_vpn_vendor_config_with_http_info(self, vpnConnectionId, vendorName, **kwargs):  # noqa: E501
        """Get VPN vendor device configuration steps.
        Get VPN vendor device configuration steps. If device version is not specified the configuration steps of the latest available device version are returned.

        >>> response = api.get_vpn_vendor_config(vpnConnectionId, vendorName, (optional) deviceVersion)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vpn_vendor_config_with_http_info(vpnConnectionId, vendorName, async_req=True)
        >>> result = thread.get()

        :param str vpnConnectionId: VPN connection UUID. (required)
        :param str vendorName: VPN device vendor name. (required)
        :param str deviceVersion: VPN device version.
        :param bool async_req:
        :return: str

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vpnConnectionId', 'vendorName', 'deviceVersion']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vpn_vendor_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vpnConnectionId' is set
        if ('vpnConnectionId' not in params or
                params['vpnConnectionId'] is None):
            raise ValueError("Missing the required parameter `vpnConnectionId` when calling `get_vpn_vendor_config`")  # noqa: E501
        # verify the required parameter 'vendorName' is set
        if ('vendorName' not in params or
                params['vendorName'] is None):
            raise ValueError("Missing the required parameter `vendorName` when calling `get_vpn_vendor_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vpnConnectionId' in params:
            path_params['vpnConnectionId'] = params['vpnConnectionId']  # noqa: E501

        query_params = []
        if 'vendorName' in params:
            query_params.append(('vendorName', params['vendorName']))  # noqa: E501
        if 'deviceVersion' in params:
            query_params.append(('deviceVersion', params['deviceVersion']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/vpn-vendor-configs/{vpnConnectionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_available_vpn_vendor_configs(self, vpnConnectionId, **kwargs):  # noqa: E501
        """List third-party VPN vendors and devices for which configuration steps are available to download.
        List third-party VPN vendors and devices for which configuration steps are available to download.

        >>> response = api.list_available_vpn_vendor_configs(vpnConnectionId, (optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_available_vpn_vendor_configs(vpnConnectionId, async_req=True)
        >>> result = thread.get()

        :param str vpnConnectionId: VPN connection UUID. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: networking.v4.config.VpnVendorListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_available_vpn_vendor_configs_with_http_info(vpnConnectionId, **kwargs)  # noqa: E501
        else:
            (data) = self.list_available_vpn_vendor_configs_with_http_info(vpnConnectionId, **kwargs)  # noqa: E501
            return data

    def list_available_vpn_vendor_configs_with_http_info(self, vpnConnectionId, **kwargs):  # noqa: E501
        """List third-party VPN vendors and devices for which configuration steps are available to download.
        List third-party VPN vendors and devices for which configuration steps are available to download.

        >>> response = api.list_available_vpn_vendor_configs(vpnConnectionId, (optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_available_vpn_vendor_configs_with_http_info(vpnConnectionId, async_req=True)
        >>> result = thread.get()

        :param str vpnConnectionId: VPN connection UUID. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: networking.v4.config.VpnVendorListApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vpnConnectionId', '_page', '_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_available_vpn_vendor_configs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vpnConnectionId' is set
        if ('vpnConnectionId' not in params or
                params['vpnConnectionId'] is None):
            raise ValueError("Missing the required parameter `vpnConnectionId` when calling `list_available_vpn_vendor_configs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vpnConnectionId' in params:
            path_params['vpnConnectionId'] = params['vpnConnectionId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/networking/v4.0.a1/config/vpn-vendor-configs/{vpnConnectionId}/available', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='networking.v4.config.VpnVendorListApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
