"""Removed all tables

Peek Plugin Database Migration Script

Revision ID: 3e75fb851c5a
Revises: 36a9bc546606
Create Date: 2017-10-30 23:34:22.804094

"""

# revision identifiers, used by Alembic.
revision = "3e75fb851c5a"
down_revision = "36a9bc546606"
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
import geoalchemy2
from sqlalchemy.dialects import postgresql


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("SettingProperty", schema="pl_inbox")
    op.drop_table("TaskAction", schema="pl_inbox")
    op.drop_table("Activity", schema="pl_inbox")
    op.drop_table("Setting", schema="pl_inbox")
    op.drop_table("Task", schema="pl_inbox")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "Task",
        sa.Column(
            "id",
            sa.INTEGER(),
            server_default=sa.text("nextval('pl_inbox.\"Task_id_seq\"'::regclass)"),
            nullable=False,
        ),
        sa.Column(
            "uniqueId", sa.VARCHAR(length=100), autoincrement=False, nullable=False
        ),
        sa.Column("userId", sa.VARCHAR(length=50), autoincrement=False, nullable=False),
        sa.Column(
            "dateTime", postgresql.TIMESTAMP(), autoincrement=False, nullable=False
        ),
        sa.Column("title", sa.VARCHAR(length=100), autoincrement=False, nullable=False),
        sa.Column(
            "description", sa.VARCHAR(length=2000), autoincrement=False, nullable=True
        ),
        sa.Column(
            "iconPath", sa.VARCHAR(length=200), autoincrement=False, nullable=True
        ),
        sa.Column(
            "routePath", sa.VARCHAR(length=200), autoincrement=False, nullable=True
        ),
        sa.Column(
            "routeParamJson", sa.VARCHAR(length=200), autoincrement=False, nullable=True
        ),
        sa.Column(
            "onDeliveredPayload", postgresql.BYTEA(), autoincrement=False, nullable=True
        ),
        sa.Column(
            "onCompletedPayload", postgresql.BYTEA(), autoincrement=False, nullable=True
        ),
        sa.Column(
            "onDeletedPayload", postgresql.BYTEA(), autoincrement=False, nullable=True
        ),
        sa.Column(
            "autoComplete",
            sa.INTEGER(),
            server_default=sa.text("0"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "autoDelete",
            sa.INTEGER(),
            server_default=sa.text("0"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "stateFlags",
            sa.INTEGER(),
            server_default=sa.text("0"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "notificationRequiredFlags",
            sa.INTEGER(),
            server_default=sa.text("0"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "notificationSentFlags",
            sa.INTEGER(),
            server_default=sa.text("0"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "displayAs",
            sa.INTEGER(),
            server_default=sa.text("0"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "autoDeleteDateTime",
            postgresql.TIMESTAMP(),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column(
            "displayPriority",
            sa.INTEGER(),
            server_default=sa.text("0"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "onDialogConfirmPayload",
            postgresql.BYTEA(),
            autoincrement=False,
            nullable=True,
        ),
        sa.PrimaryKeyConstraint("id", name="Task_pkey"),
        sa.UniqueConstraint("uniqueId", name="Task_uniqueId_key"),
        schema="pl_inbox",
        postgresql_ignore_search_path=False,
    )
    op.create_table(
        "Setting",
        sa.Column(
            "id",
            sa.INTEGER(),
            server_default=sa.text("nextval('pl_inbox.\"Setting_id_seq\"'::regclass)"),
            nullable=False,
        ),
        sa.Column("name", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.PrimaryKeyConstraint("id", name="Setting_pkey"),
        schema="pl_inbox",
        postgresql_ignore_search_path=False,
    )
    op.create_table(
        "Activity",
        sa.Column(
            "id",
            sa.INTEGER(),
            server_default=sa.text("nextval('pl_inbox.\"Activity_id_seq\"'::regclass)"),
            nullable=False,
        ),
        sa.Column(
            "uniqueId", sa.VARCHAR(length=100), autoincrement=False, nullable=False
        ),
        sa.Column("userId", sa.VARCHAR(length=50), autoincrement=False, nullable=False),
        sa.Column(
            "dateTime", postgresql.TIMESTAMP(), autoincrement=False, nullable=False
        ),
        sa.Column("title", sa.VARCHAR(length=100), autoincrement=False, nullable=False),
        sa.Column(
            "description", sa.VARCHAR(length=2000), autoincrement=False, nullable=True
        ),
        sa.Column(
            "iconPath", sa.VARCHAR(length=200), autoincrement=False, nullable=True
        ),
        sa.Column(
            "routePath", sa.VARCHAR(length=200), autoincrement=False, nullable=True
        ),
        sa.Column(
            "routeParamJson", sa.VARCHAR(length=200), autoincrement=False, nullable=True
        ),
        sa.Column(
            "autoDeleteDateTime",
            postgresql.TIMESTAMP(),
            autoincrement=False,
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("id", name="Activity_pkey"),
        sa.UniqueConstraint("uniqueId", name="Activity_uniqueId_key"),
        schema="pl_inbox",
    )
    op.create_table(
        "TaskAction",
        sa.Column(
            "id",
            sa.INTEGER(),
            server_default=sa.text(
                "nextval('pl_inbox.\"TaskAction_id_seq\"'::regclass)"
            ),
            nullable=False,
        ),
        sa.Column("taskId", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("title", sa.VARCHAR(length=50), autoincrement=False, nullable=True),
        sa.Column(
            "confirmMessage", sa.VARCHAR(length=200), autoincrement=False, nullable=True
        ),
        sa.Column(
            "onActionPayload", postgresql.BYTEA(), autoincrement=False, nullable=True
        ),
        sa.ForeignKeyConstraint(
            ["taskId"],
            ["pl_inbox.Task.id"],
            name="TaskAction_taskId_fkey",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id", name="TaskAction_pkey"),
        schema="pl_inbox",
    )
    op.create_table(
        "SettingProperty",
        sa.Column(
            "id",
            sa.INTEGER(),
            server_default=sa.text(
                "nextval('pl_inbox.\"SettingProperty_id_seq\"'::regclass)"
            ),
            nullable=False,
        ),
        sa.Column("settingId", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("key", sa.VARCHAR(length=50), autoincrement=False, nullable=False),
        sa.Column("type", sa.VARCHAR(length=16), autoincrement=False, nullable=True),
        sa.Column("int_value", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("char_value", sa.VARCHAR(), autoincrement=False, nullable=True),
        sa.Column("boolean_value", sa.BOOLEAN(), autoincrement=False, nullable=True),
        sa.ForeignKeyConstraint(
            ["settingId"],
            ["pl_inbox.Setting.id"],
            name="SettingProperty_settingId_fkey",
        ),
        sa.PrimaryKeyConstraint("id", name="SettingProperty_pkey"),
        schema="pl_inbox",
    )
    # ### end Alembic commands ###
