import { DocumentRegistry } from "@jupyterlab/docregistry";
import { INotebookModel, NotebookPanel, INotebookTracker } from "@jupyterlab/notebook";
import { JupyterFrontEnd, JupyterFrontEndPlugin } from "@jupyterlab/application";
import { CommandRegistry } from "@lumino/commands";
import { IDisposable } from "@lumino/disposable";
import { Widget } from "@lumino/widgets";
import "../style/index.css";
export declare const AUTOVERSION_COMMAND = "notebook:autoversion";
declare const extension: JupyterFrontEndPlugin<void>;
export declare class AutoversionWidget extends Widget {
    constructor(app: JupyterFrontEnd, context: DocumentRegistry.IContext<INotebookModel>, id: string, path: string);
    getValue(): string;
    get inputNode(): HTMLSelectElement;
}
export declare function autoversion(app: JupyterFrontEnd, context: DocumentRegistry.IContext<INotebookModel>): void;
export declare function revision(app: JupyterFrontEnd, context: DocumentRegistry.IContext<INotebookModel>, id: string, version: string): void;
export declare class AutoversionExtension implements DocumentRegistry.IWidgetExtension<NotebookPanel, INotebookModel> {
    protected commands: CommandRegistry;
    constructor(commands: CommandRegistry);
    /**
     * Create a new extension object.
     */
    createNew(nb: NotebookPanel): IDisposable;
}
declare function activate(app: JupyterFrontEnd, tracker: INotebookTracker): void;
export default extension;
export { activate as _activate };
