"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports._activate = exports.AutoversionExtension = exports.revision = exports.autoversion = exports.AutoversionWidget = exports.AUTOVERSION_COMMAND = void 0;
/* eslint-disable max-classes-per-file */
const apputils_1 = require("@jupyterlab/apputils");
const coreutils_1 = require("@jupyterlab/coreutils");
const notebook_1 = require("@jupyterlab/notebook");
const algorithm_1 = require("@lumino/algorithm");
const disposable_1 = require("@lumino/disposable");
const widgets_1 = require("@lumino/widgets");
const requests_helper_1 = require("requests-helper");
require("../style/index.css");
exports.AUTOVERSION_COMMAND = "notebook:autoversion";
const extension = {
    activate,
    autoStart: true,
    id: "jupyterlab_autoversion",
    requires: [notebook_1.INotebookTracker],
};
class AutoversionWidget extends widgets_1.Widget {
    constructor(app, context, id, path) {
        const body = document.createElement("div");
        body.style.display = "flex";
        body.style.flexDirection = "column";
        const default_none = document.createElement("option");
        default_none.selected = false;
        default_none.disabled = true;
        default_none.hidden = false;
        default_none.style.display = "none";
        default_none.value = "";
        const type = document.createElement("select");
        type.appendChild(default_none);
        void requests_helper_1.request("get", coreutils_1.PageConfig.getBaseUrl() + "autoversion/get?id=" + id + "&path=" + path).then((res) => {
            if (res.ok) {
                const versions = res.json();
                for (const record of versions.versions) {
                    const option = document.createElement("option");
                    option.value = record;
                    const timestamp = new Date(record[1]);
                    option.textContent = timestamp + " -- " + record[0].slice(0, 6);
                    type.appendChild(option);
                }
            }
        });
        type.style.marginBottom = "15px";
        type.style.minHeight = "25px";
        body.appendChild(type);
        super({ node: body });
    }
    getValue() {
        return this.inputNode.value;
    }
    get inputNode() {
        return this.node.getElementsByTagName("select")[0];
    }
}
exports.AutoversionWidget = AutoversionWidget;
function autoversion(app, context) {
    const model = context.model;
    const id = model.metadata.autoversion || "";
    void apputils_1.showDialog({
        body: new AutoversionWidget(app, context, id, context.path),
        buttons: [apputils_1.Dialog.cancelButton(), apputils_1.Dialog.okButton({ label: "Ok" })],
        focusNodeSelector: "input",
        title: "Autoversion:",
    }).then((result) => {
        if (result.button.label === "Cancel") {
            return;
        }
        else {
            // narrow typing of .value since body.getValue != null
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            const val = result.value.split(",");
            revision(app, context, val[2], val[3]);
        }
    });
}
exports.autoversion = autoversion;
function revision(app, context, id, version) {
    void requests_helper_1.request("get", coreutils_1.PageConfig.getBaseUrl() + "autoversion/restore?id=" +
        id + "&path=" + context.path + "&version=" + version).then((res) => {
        if (res.ok) {
            const data = res.json();
            if (data.version.toString() === version) {
                context.model.fromJSON(data.nb);
            }
        }
    });
}
exports.revision = revision;
class AutoversionExtension {
    constructor(commands) {
        this.commands = commands;
    }
    /**
     * Create a new extension object.
     */
    createNew(nb) {
        // Create extension here
        // Add buttons to toolbar
        const buttons = [];
        let insertionPoint = -1;
        algorithm_1.find(nb.toolbar.children(), (tbb, index) => {
            if (tbb.hasClass("jp-Notebook-toolbarCellType")) {
                insertionPoint = index;
                return true;
            }
            return false;
        });
        let i = 1;
        for (const id of [exports.AUTOVERSION_COMMAND]) {
            const button = new apputils_1.CommandToolbarButton({
                commands: this.commands,
                id,
            });
            button.addClass("autoversionButton");
            if (insertionPoint >= 0) {
                nb.toolbar.insertItem(insertionPoint + i++, this.commands.label(id), button);
            }
            else {
                nb.toolbar.addItem(this.commands.label(id), button);
            }
            buttons.push(button);
        }
        return new disposable_1.DisposableDelegate(() => {
            // Cleanup extension here
            for (const btn of buttons) {
                btn.dispose();
            }
        });
    }
}
exports.AutoversionExtension = AutoversionExtension;
function activate(app, tracker) {
    const { commands } = app;
    const avExtension = new AutoversionExtension(commands);
    app.docRegistry.addWidgetExtension("Notebook", avExtension);
    commands.addCommand(exports.AUTOVERSION_COMMAND, {
        caption: "Restore previous version notebooks",
        execute: () => {
            const current = tracker.currentWidget;
            if (!current) {
                return;
            }
            autoversion(app, current.context);
        },
        iconClass: "jp-Icon jp-Icon-16 fa fa-fast-backward",
        iconLabel: "autoversion",
        isEnabled: () => tracker.currentWidget !== undefined && tracker.currentWidget !== null,
        label: "",
    });
    // eslint-disable-next-line no-console
    console.log("JupyterLab extension jupyterlab_autoversion is activated!");
}
exports._activate = activate;
exports.default = extension;
