"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reset = exports.lambda = exports.stepFunctions = exports.sqs = exports.s3ObjectExists = exports.s3 = void 0;
const _AWS = require("aws-sdk");
const AWSXRay = require("aws-xray-sdk-core");
// Do nothing if there is no XRay trace context
AWSXRay.setContextMissingStrategy(() => { });
const AWS = AWSXRay.captureAWS(_AWS);
let _s3;
let _sqs;
let _sfn;
let _lambda;
;
function s3() {
    if (_s3 == null) {
        _s3 = new AWS.S3();
    }
    return _s3;
}
exports.s3 = s3;
/**
 * Checks whether an object exists in S3 at the provided bucket and key.
 */
function s3ObjectExists(bucket, key) {
    return s3().headObject({
        Bucket: bucket,
        Key: key,
    }).promise()
        .then(() => true, (cause) => {
        if (cause.code === 'NotFound') {
            return false;
        }
        return Promise.reject(cause);
    });
}
exports.s3ObjectExists = s3ObjectExists;
function sqs() {
    if (_sqs == null) {
        _sqs = new AWS.SQS();
    }
    return _sqs;
}
exports.sqs = sqs;
function stepFunctions() {
    if (_sfn == null) {
        _sfn = new AWS.StepFunctions();
    }
    return _sfn;
}
exports.stepFunctions = stepFunctions;
function lambda() {
    if (_lambda == null) {
        _lambda = new AWS.Lambda();
    }
    return _lambda;
}
exports.lambda = lambda;
/**
 * Resets all clients vended by this module. This is useful in unit tests when
 * `aws-sdk-mocks` is used, so that new mocks are injected as intended.
 */
function reset() {
    _s3 = _sqs = _sfn = _lambda = undefined;
}
exports.reset = reset;
//# sourceMappingURL=data:application/json;base64,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