# Generated by Django 3.0.2 on 2020-01-17 18:40

from django.db import migrations, models
import django.db.models.deletion


def convert_notification_templates_with_slug_to_admin_templates(apps, schema_editor):
    NotificationTemplate = apps.get_model("pynotify", "NotificationTemplate")
    AdminNotificationTemplate = apps.get_model("pynotify", "AdminNotificationTemplate")

    for notification_template in NotificationTemplate.objects.filter(slug__isnull=False):
        admin_template = AdminNotificationTemplate.objects.create(
            title=notification_template.title,
            text=notification_template.text,
            trigger_action=notification_template.trigger_action,
            slug=notification_template.slug,
        )
        notification_template.admin_template = admin_template
        notification_template.save()


class Migration(migrations.Migration):

    dependencies = [
        ('pynotify', '0003_related_object_name_not_required'),
    ]

    operations = [
        migrations.CreateModel(
            name='AdminNotificationTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('title', models.CharField(max_length=200, verbose_name='title')),
                ('text', models.TextField(blank=True, null=True, verbose_name='text')),
                ('trigger_action', models.CharField(blank=True, max_length=2500, null=True,
                                                    verbose_name='trigger action')),
                ('slug', models.SlugField(blank=False, max_length=200, null=False, unique=True, verbose_name='slug')),
            ],
            options={
                'verbose_name': 'admin notification template',
                'verbose_name_plural': 'admin notification templates',
            },
        ),
        migrations.AddField(
            model_name='notificationtemplate',
            name='admin_template',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    related_name='notification_templates', to='pynotify.AdminNotificationTemplate',
                                    verbose_name='admin notification template'),
        ),
        migrations.RunPython(convert_notification_templates_with_slug_to_admin_templates),
        migrations.RemoveField(
            model_name='notificationtemplate',
            name='slug',
        ),
    ]
