# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 1.1.2  # noqa: E501
    The version of the OpenAPI document: 0.9.4
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class TransactionStatusDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'group': 'TransactionGroupEnum',
        'code': 'TransactionStatusEnum',
        'hash': 'str',
        'deadline': 'str',
        'height': 'str'
    }

    attribute_map = {
        'group': 'group',
        'code': 'code',
        'hash': 'hash',
        'deadline': 'deadline',
        'height': 'height'
    }

    def __init__(self, group=None, code=None, hash=None, deadline=None, height=None, local_vars_configuration=None):  # noqa: E501
        """TransactionStatusDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._group = None
        self._code = None
        self._hash = None
        self._deadline = None
        self._height = None
        self.discriminator = None

        self.group = group
        if code is not None:
            self.code = code
        self.hash = hash
        self.deadline = deadline
        if height is not None:
            self.height = height

    @property
    def group(self):
        """Gets the group of this TransactionStatusDTO.  # noqa: E501


        :return: The group of this TransactionStatusDTO.  # noqa: E501
        :rtype: TransactionGroupEnum
        """
        return self._group

    @group.setter
    def group(self, group):
        """Sets the group of this TransactionStatusDTO.


        :param group: The group of this TransactionStatusDTO.  # noqa: E501
        :type: TransactionGroupEnum
        """
        if self.local_vars_configuration.client_side_validation and group is None:  # noqa: E501
            raise ValueError("Invalid value for `group`, must not be `None`")  # noqa: E501

        self._group = group

    @property
    def code(self):
        """Gets the code of this TransactionStatusDTO.  # noqa: E501


        :return: The code of this TransactionStatusDTO.  # noqa: E501
        :rtype: TransactionStatusEnum
        """
        return self._code

    @code.setter
    def code(self, code):
        """Sets the code of this TransactionStatusDTO.


        :param code: The code of this TransactionStatusDTO.  # noqa: E501
        :type: TransactionStatusEnum
        """

        self._code = code

    @property
    def hash(self):
        """Gets the hash of this TransactionStatusDTO.  # noqa: E501


        :return: The hash of this TransactionStatusDTO.  # noqa: E501
        :rtype: str
        """
        return self._hash

    @hash.setter
    def hash(self, hash):
        """Sets the hash of this TransactionStatusDTO.


        :param hash: The hash of this TransactionStatusDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and hash is None:  # noqa: E501
            raise ValueError("Invalid value for `hash`, must not be `None`")  # noqa: E501

        self._hash = hash

    @property
    def deadline(self):
        """Gets the deadline of this TransactionStatusDTO.  # noqa: E501

        Duration expressed in number of blocks.  # noqa: E501

        :return: The deadline of this TransactionStatusDTO.  # noqa: E501
        :rtype: str
        """
        return self._deadline

    @deadline.setter
    def deadline(self, deadline):
        """Sets the deadline of this TransactionStatusDTO.

        Duration expressed in number of blocks.  # noqa: E501

        :param deadline: The deadline of this TransactionStatusDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and deadline is None:  # noqa: E501
            raise ValueError("Invalid value for `deadline`, must not be `None`")  # noqa: E501

        self._deadline = deadline

    @property
    def height(self):
        """Gets the height of this TransactionStatusDTO.  # noqa: E501

        Height of the blockchain.  # noqa: E501

        :return: The height of this TransactionStatusDTO.  # noqa: E501
        :rtype: str
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this TransactionStatusDTO.

        Height of the blockchain.  # noqa: E501

        :param height: The height of this TransactionStatusDTO.  # noqa: E501
        :type: str
        """

        self._height = height

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TransactionStatusDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TransactionStatusDTO):
            return True

        return self.to_dict() != other.to_dict()
