#   -*- coding: utf-8 -*-
#   Copyright 2020 Arturo González, Diego Barrantes
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

import pybuilder_archetype_base.messages as msg


class MissingPropertyError(Exception):
	def __init__(self, property, message=None):
		"""
		This exception is raised when a property value is missing.

		:param str or None message: Custom exception message
		"""
		super().__init__(message if message else msg.MISSING_PROPERTY_ERROR.format(property=property))
