# 4logik python rest client
Utility package to call an enpoint generated by 4Logik

## Installation
Use pip

```
pip install 4logik-python-rest-client
```

## How to call a CSV endpoint
- Locate the input CSV file
- Identify the URL of the enpoint
- Identify the name of the data set of the response that contains the results

Example of using the package:

```python
from py4logik_python_rest_client.endpoint_caller import call_csv_endpoint, call_csv_endpoint_read_data_set

# input parameters
input_csv_file = "/home/user1/incomingData.csv"
endpoint_url = "http://myOrganization.myDeployedService.com/RiskCalulationProcess"

# call the endpoint
received_json_data = call_csv_endpoint(ms_url, input_csv_file)
print(received_json_data)
```

The result will contain useful metadata like the quantity of business exceptions and the list of data sets which you can print using:

```python
print(received_json_data["data_sets_names"])
print(received_json_data["data_sets_results"])
```

To read the specific rows of a data set, call the method "call_csv_endpoint_read_data_set" sending the name of the data set, like this:

```python
specific_data_set_name_to_read = "ReportResult"
data_set_result_rows = call_csv_endpoint_read_data_set(ms_url, input_csv_file, specific_data_set_name_to_read)
print(data_set_result_rows)
```

## Example using the package inside Jupyter and converting the result to a data frame:

```python
import json
import pandas as pd
import tempfile

from py4logik_python_rest_client.endpoint_caller import call_csv_endpoint_read_data_set

# input parameters
input_csv_file = "/home/user1/incomingData.csv"
endpoint_url = "http://myOrganization.myDeployedService.com/RiskCalulationProcess"
dataset_name = "riskResult"

# call the endpoint
received_json_data = call_csv_endpoint_read_data_set(ms_url, input_csv_file, dataset_name)

# now convert the received json to panda
temp_file = tempfile.NamedTemporaryFile(delete=False)
output_json = temp_file.name

with open(output_json,'w', encoding='UTF_8') as f:
    f.write(json.dumps(received_json_data))
    f.close()

final_data_frame = pd.read_json(output_json)

final_data_frame
```