"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCliLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
/**
 * An AWS Lambda layer that includes the AWS CLI.
 *
 * @stability stable
 */
class AwsCliLayer extends lambda.LayerVersion {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            code: lambda.Code.fromAsset(path.join(__dirname, 'layer.zip'), {
                // we hash the layer directory (it contains the tools versions and Dockerfile) because hashing the zip is non-deterministic
                assetHash: core_1.FileSystem.fingerprint(path.join(__dirname, '../layer')),
            }),
            description: '/opt/awscli/aws',
        });
    }
}
exports.AwsCliLayer = AwsCliLayer;
_a = JSII_RTTI_SYMBOL_1;
AwsCliLayer[_a] = { fqn: "@aws-cdk/lambda-layer-awscli.AwsCliLayer", version: "1.144.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzY2xpLWxheWVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXdzY2xpLWxheWVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkJBQTZCO0FBQzdCLDhDQUE4QztBQUM5Qyx3Q0FBMkM7Ozs7OztBQUkzQyxNQUFhLFdBQVksU0FBUSxNQUFNLENBQUMsWUFBWTs7OztJQUNsRCxZQUFZLEtBQWdCLEVBQUUsRUFBVTtRQUN0QyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLElBQUksRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxXQUFXLENBQUMsRUFBRTtnQkFDN0QsMkhBQTJIO2dCQUMzSCxTQUFTLEVBQUUsaUJBQVUsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsVUFBVSxDQUFDLENBQUM7YUFDcEUsQ0FBQztZQUNGLFdBQVcsRUFBRSxpQkFBaUI7U0FDL0IsQ0FBQyxDQUFDO0tBQ0o7O0FBVEgsa0NBVUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgRmlsZVN5c3RlbSB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEF3c0NsaUxheWVyIGV4dGVuZHMgbGFtYmRhLkxheWVyVmVyc2lvbiB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIGNvZGU6IGxhbWJkYS5Db2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnbGF5ZXIuemlwJyksIHtcbiAgICAgICAgLy8gd2UgaGFzaCB0aGUgbGF5ZXIgZGlyZWN0b3J5IChpdCBjb250YWlucyB0aGUgdG9vbHMgdmVyc2lvbnMgYW5kIERvY2tlcmZpbGUpIGJlY2F1c2UgaGFzaGluZyB0aGUgemlwIGlzIG5vbi1kZXRlcm1pbmlzdGljXG4gICAgICAgIGFzc2V0SGFzaDogRmlsZVN5c3RlbS5maW5nZXJwcmludChwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4vbGF5ZXInKSksXG4gICAgICB9KSxcbiAgICAgIGRlc2NyaXB0aW9uOiAnL29wdC9hd3NjbGkvYXdzJyxcbiAgICB9KTtcbiAgfVxufVxuIl19