# Generated by Django 4.1.7 on 2023-02-28 20:30

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Job",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("function_name", models.TextField()),
                ("function_arguments", models.JSONField(blank=True, default=dict)),
                (
                    "status",
                    models.TextField(
                        choices=[
                            ("PENDING", "pending"),
                            ("IN_PROGRESS", "IN_PROGRESS"),
                            ("FAILED", "Failed"),
                            ("SUCCESS", "Success"),
                        ],
                        default="PENDING",
                    ),
                ),
                ("is_one_off", models.BooleanField()),
                ("periodic_schedule", models.TextField(blank=True, null=True)),
                ("disabled", models.BooleanField(default=False)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("last_run_at", models.DateTimeField(blank=True, null=True)),
                ("allow_retries", models.BooleanField(default=True)),
                ("is_scheduled_for_retry", models.BooleanField(default=False)),
                ("retry_times", models.IntegerField(default=0)),
                ("max_retries", models.IntegerField(default=6)),
                ("retry_seconds_interval", models.IntegerField(default=900)),
                ("queue", models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="JobResult",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("result", models.JSONField(blank=True, null=True)),
                ("exc_type", models.TextField(blank=True, null=True)),
                ("exc_message", models.TextField(blank=True, null=True)),
                ("exc_traceback", models.TextField(blank=True, null=True)),
                ("started_at", models.DateTimeField(auto_now_add=True)),
                ("finished_at", models.DateTimeField()),
                (
                    "job",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="results",
                        to="simple_jobs.job",
                    ),
                ),
            ],
        ),
    ]
