#! /usr/bin/env python
# -*- coding: utf-8 -*-#
"""Batch conversion for all image files

This is a way to save the startup time when running img2py on lots of
files...

"""
import sys
from wx.tools import img2py
from wx import EmptyIcon

headerStuff = """# This file was generated by pyrimg2py.py
#
from wx.lib.embeddedimage import PyEmbeddedImage
import cStringIO
"""

resFileName = "../pyrres.py"
imageFile = file(resFileName, "w+")
imageFile.write(headerStuff)
imageFile.close()

command_lines = [
        "-a -u  -i -n img_114_list 114_list.png %s" % resFileName,
        "-a -u  -i -n img_137_computer_service 137_computer_service.png %s" % resFileName,
        "-a -u  -i -n barcode_default barcode_default.png %s" % resFileName,
        "-a -u  -i -n glyphicons_036_file glyphicons_036_file.png %s" % resFileName,
        "-a -u  -i -n glyphicons_094_vector_path_square glyphicons_094_vector_path_square.png %s" % resFileName,
        "-a -u  -i -n glyphicons_097_vector_path_line glyphicons_097_vector_path_line.png %s" % resFileName,
        "-a -u  -i -n glyphicons_099_vector_path_all glyphicons_099_vector_path_all.png %s" % resFileName,
        "-a -u  -i -n glyphicons_104_text glyphicons_104_text.png %s" % resFileName,
        "-a -u  -i -n glyphicons_159_picture glyphicons_159_picture.png %s" % resFileName,
        "-a -u  -i -n glyphicons_236_zoom_in glyphicons_236_zoom_in.png %s" % resFileName,
        "-a -u  -i -n glyphicons_237_zoom_out glyphicons_237_zoom_out.png %s" % resFileName,
        "-a -u  -i -n glyphicons_259_barcode glyphicons_259_barcode.png %s" % resFileName,
        "-a -u  -i -n glyphicons_358_file_import glyphicons_358_file_import.png %s" % resFileName,
        "-a -u  -i -n glyphicons_359_file_export glyphicons_359_file_export.png %s" % resFileName,
        "-a -u  -i -n image image.png %s" % resFileName,
        "-a -u  -i -n image_default image_default.png %s" % resFileName,
        "-a -u  -i -n image_error image_error.png %s" % resFileName,
        "-a -u  -i -n properties properties.png %s" % resFileName,
        "-a -u  -i -n pythonreports pythonreports.ico %s" % resFileName,

    ]


if __name__ == "__main__":
    for line in command_lines:
        args = line.split()
        img2py.main(args)
