import { Metric, MetricOptions } from '@aws-cdk/aws-cloudwatch';
import { IGrantable, IPrincipal } from '@aws-cdk/aws-iam';
import { IFunction } from '@aws-cdk/aws-lambda';
import { IBucket } from '@aws-cdk/aws-s3';
import { IQueue } from '@aws-cdk/aws-sqs';
import { Construct, Duration } from '@aws-cdk/core';
import { Monitoring } from '../../monitoring';
import type { PackageLinkConfig } from '../../webapp';
import { Orchestration } from '../orchestration';
export interface IngestionProps {
    /**
     * The bucket in which ingested objects are due to be inserted.
     */
    readonly bucket: IBucket;
    /**
     * The monitoring handler to register alarms with.
     */
    readonly monitoring: Monitoring;
    /**
     * The backend orchestration to invoke once the package metadata has been
     * successfully registered.
     */
    readonly orchestration: Orchestration;
    /**
     * Configuration for custom package page links.
     */
    readonly packageLinks?: PackageLinkConfig[];
}
/**
 * The ingestion function receives messages from discovery integrations and
 * processes their payloads into the provided S3 Bucket.
 *
 * This function is also an `IGrantable`, so that it can be granted permissions
 * to read from the source S3 buckets.
 */
export declare class Ingestion extends Construct implements IGrantable {
    readonly grantPrincipal: IPrincipal;
    /**
     * The SQS queue that triggers the ingestion function.
     */
    readonly queue: IQueue;
    /**
     * The ingestion dead letter queue, which will hold messages that failed
     * ingestion one too many times, so that poison pills don't endlessly consume
     * resources.
     */
    readonly deadLetterQueue: IQueue;
    readonly queueRetentionPeriod: Duration;
    readonly function: IFunction;
    constructor(scope: Construct, id: string, props: IngestionProps);
    metricFoundLicenseFile(opts?: MetricOptions): Metric;
    metricIneligibleLicense(opts?: MetricOptions): Metric;
    metricInvalidAssembly(opts?: MetricOptions): Metric;
    metricInvalidTarball(opts?: MetricOptions): Metric;
    /**
     * This metrics is the total count of packages that were rejected due to
     * mismatched identity (name, version, license) between the `package.json`
     * file and te `.jsii` attribute.
     */
    metricMismatchedIdentityRejections(opts?: MetricOptions): Metric;
}
