import type { Context } from 'aws-lambda';
import type { TransliteratorInput } from '../payload-schema';
/**
 * This function receives an S3 event, and for each record, proceeds to download
 * the `.jsii` assembly the event refers to, transliterates it to Python, then
 * uploads the resulting `.jsii.python` object to S3.
 *
 * @param event   an S3 event payload
 * @param context a Lambda execution context
 *
 * @returns nothing
 */
export declare function handler(event: TransliteratorInput, context: Context): Promise<S3Object[]>;
interface S3Object {
    readonly bucket: string;
    readonly key: string;
    readonly versionId?: string;
}
export {};
