import * as cloudfront from '@aws-cdk/aws-cloudfront';
import * as s3 from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import { Domain } from '../api';
import { Monitoring } from '../monitoring';
/**
 * @experimental
 */
export interface PackageLinkConfig {
    /**
     * (experimental) The name of the link, appears before the ":" on the website.
     *
     * @experimental
     */
    readonly linkLabel: string;
    /**
     * (experimental) The location of the value inside the constructHub.packageLinks key of a module's package.json.
     *
     * @experimental
     */
    readonly configKey: string;
    /**
     * (experimental) optional text to display as the hyperlink text.
     *
     * @default the url of the link
     * @experimental
     */
    readonly linkText?: string;
    /**
     * (experimental) allowList of domains for this link.
     *
     * @default all domains allowed
     * @experimental
     */
    readonly allowedDomains?: string[];
}
export interface WebAppProps {
    /**
     * Connect to a domain.
     * @default - uses the default CloudFront domain.
     */
    readonly domain?: Domain;
    /**
     * Monitoring system.
     */
    readonly monitoring: Monitoring;
    /**
     * The bucket containing package data.
     */
    readonly packageData: s3.Bucket;
    /**
     * Configuration for custom package page links.
     */
    readonly packageLinks?: PackageLinkConfig[];
}
export declare class WebApp extends Construct {
    readonly bucket: s3.Bucket;
    readonly distribution: cloudfront.Distribution;
    constructor(scope: Construct, id: string, props: WebAppProps);
}
