# coding: utf-8

"""
    Selling Partner API for Product Fees

    The Selling Partner API for Product Fees lets you programmatically retrieve estimated fees for a product. You can then account for those fees in your pricing.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class FeesEstimateIdentifier(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'marketplace_id': 'str',
        'seller_id': 'str',
        'id_type': 'str',
        'id_value': 'str',
        'is_amazon_fulfilled': 'bool',
        'price_to_estimate_fees': 'PriceToEstimateFees',
        'seller_input_identifier': 'str'
    }

    attribute_map = {
        'marketplace_id': 'MarketplaceId',
        'seller_id': 'SellerId',
        'id_type': 'IdType',
        'id_value': 'IdValue',
        'is_amazon_fulfilled': 'IsAmazonFulfilled',
        'price_to_estimate_fees': 'PriceToEstimateFees',
        'seller_input_identifier': 'SellerInputIdentifier'
    }

    def __init__(self, marketplace_id=None, seller_id=None, id_type=None, id_value=None, is_amazon_fulfilled=None, price_to_estimate_fees=None, seller_input_identifier=None):  # noqa: E501
        """FeesEstimateIdentifier - a model defined in Swagger"""  # noqa: E501
        self._marketplace_id = None
        self._seller_id = None
        self._id_type = None
        self._id_value = None
        self._is_amazon_fulfilled = None
        self._price_to_estimate_fees = None
        self._seller_input_identifier = None
        self.discriminator = None
        if marketplace_id is not None:
            self.marketplace_id = marketplace_id
        if seller_id is not None:
            self.seller_id = seller_id
        if id_type is not None:
            self.id_type = id_type
        if id_value is not None:
            self.id_value = id_value
        if is_amazon_fulfilled is not None:
            self.is_amazon_fulfilled = is_amazon_fulfilled
        if price_to_estimate_fees is not None:
            self.price_to_estimate_fees = price_to_estimate_fees
        if seller_input_identifier is not None:
            self.seller_input_identifier = seller_input_identifier

    @property
    def marketplace_id(self):
        """Gets the marketplace_id of this FeesEstimateIdentifier.  # noqa: E501

        A marketplace identifier.  # noqa: E501

        :return: The marketplace_id of this FeesEstimateIdentifier.  # noqa: E501
        :rtype: str
        """
        return self._marketplace_id

    @marketplace_id.setter
    def marketplace_id(self, marketplace_id):
        """Sets the marketplace_id of this FeesEstimateIdentifier.

        A marketplace identifier.  # noqa: E501

        :param marketplace_id: The marketplace_id of this FeesEstimateIdentifier.  # noqa: E501
        :type: str
        """

        self._marketplace_id = marketplace_id

    @property
    def seller_id(self):
        """Gets the seller_id of this FeesEstimateIdentifier.  # noqa: E501

        The seller identifier.  # noqa: E501

        :return: The seller_id of this FeesEstimateIdentifier.  # noqa: E501
        :rtype: str
        """
        return self._seller_id

    @seller_id.setter
    def seller_id(self, seller_id):
        """Sets the seller_id of this FeesEstimateIdentifier.

        The seller identifier.  # noqa: E501

        :param seller_id: The seller_id of this FeesEstimateIdentifier.  # noqa: E501
        :type: str
        """

        self._seller_id = seller_id

    @property
    def id_type(self):
        """Gets the id_type of this FeesEstimateIdentifier.  # noqa: E501

        The type of item identifier specified.  # noqa: E501

        :return: The id_type of this FeesEstimateIdentifier.  # noqa: E501
        :rtype: str
        """
        return self._id_type

    @id_type.setter
    def id_type(self, id_type):
        """Sets the id_type of this FeesEstimateIdentifier.

        The type of item identifier specified.  # noqa: E501

        :param id_type: The id_type of this FeesEstimateIdentifier.  # noqa: E501
        :type: str
        """

        self._id_type = id_type

    @property
    def id_value(self):
        """Gets the id_value of this FeesEstimateIdentifier.  # noqa: E501

        The item identifier.  # noqa: E501

        :return: The id_value of this FeesEstimateIdentifier.  # noqa: E501
        :rtype: str
        """
        return self._id_value

    @id_value.setter
    def id_value(self, id_value):
        """Sets the id_value of this FeesEstimateIdentifier.

        The item identifier.  # noqa: E501

        :param id_value: The id_value of this FeesEstimateIdentifier.  # noqa: E501
        :type: str
        """

        self._id_value = id_value

    @property
    def is_amazon_fulfilled(self):
        """Gets the is_amazon_fulfilled of this FeesEstimateIdentifier.  # noqa: E501

        When true, the offer is fulfilled by Amazon.  # noqa: E501

        :return: The is_amazon_fulfilled of this FeesEstimateIdentifier.  # noqa: E501
        :rtype: bool
        """
        return self._is_amazon_fulfilled

    @is_amazon_fulfilled.setter
    def is_amazon_fulfilled(self, is_amazon_fulfilled):
        """Sets the is_amazon_fulfilled of this FeesEstimateIdentifier.

        When true, the offer is fulfilled by Amazon.  # noqa: E501

        :param is_amazon_fulfilled: The is_amazon_fulfilled of this FeesEstimateIdentifier.  # noqa: E501
        :type: bool
        """

        self._is_amazon_fulfilled = is_amazon_fulfilled

    @property
    def price_to_estimate_fees(self):
        """Gets the price_to_estimate_fees of this FeesEstimateIdentifier.  # noqa: E501


        :return: The price_to_estimate_fees of this FeesEstimateIdentifier.  # noqa: E501
        :rtype: PriceToEstimateFees
        """
        return self._price_to_estimate_fees

    @price_to_estimate_fees.setter
    def price_to_estimate_fees(self, price_to_estimate_fees):
        """Sets the price_to_estimate_fees of this FeesEstimateIdentifier.


        :param price_to_estimate_fees: The price_to_estimate_fees of this FeesEstimateIdentifier.  # noqa: E501
        :type: PriceToEstimateFees
        """

        self._price_to_estimate_fees = price_to_estimate_fees

    @property
    def seller_input_identifier(self):
        """Gets the seller_input_identifier of this FeesEstimateIdentifier.  # noqa: E501

        A unique identifier provided by the caller to track this request.  # noqa: E501

        :return: The seller_input_identifier of this FeesEstimateIdentifier.  # noqa: E501
        :rtype: str
        """
        return self._seller_input_identifier

    @seller_input_identifier.setter
    def seller_input_identifier(self, seller_input_identifier):
        """Sets the seller_input_identifier of this FeesEstimateIdentifier.

        A unique identifier provided by the caller to track this request.  # noqa: E501

        :param seller_input_identifier: The seller_input_identifier of this FeesEstimateIdentifier.  # noqa: E501
        :type: str
        """

        self._seller_input_identifier = seller_input_identifier

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FeesEstimateIdentifier, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FeesEstimateIdentifier):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
