import { IVpc, ISecurityGroup } from '@aws-cdk/aws-ec2';
import { Construct } from '@aws-cdk/core';
/**
   * Creates SecurityGroups where "sensitive" operations should be listed,
   * which only allows DNS requests to be issued within the VPC (to the local
   * Route53 resolver), as well as HTTPS (port 443) traffic to:
   * - allow-listed IP ranges
   * - endpoints within the same SecurityGroup.
   *
   * This returns MULTIPLE security groups in order to avoid hitting the maximum
   * count of rules per security group, which is relatively low, and prefix
   * lists count as their expansions.
   *
   * There is also a limit of how many security groups can be bound to a network
   * interface (defaults to 5), so there is only so much we can do here.
   *
   * @param scope the scope in which to attach new constructs.
   * @param vpc the VPC in which a SecurityGroup is to be added.
   */
export declare function createRestrictedSecurityGroups(scope: Construct, vpc: IVpc): ISecurityGroup[];
/**
 * Parses the PrefixList in the designated path.
 *
 * @param filePath the file containing the prefix list.
 */
export declare function parsePrefixList(filePath: string): CidrBlock[];
interface CidrBlock {
    readonly cidr: string;
}
export {};
