var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, copyDefault, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && (copyDefault || key !== "default"))
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toESM = (module2, isNodeMode) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", !isNodeMode && module2 && module2.__esModule ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};
var __toCommonJS = /* @__PURE__ */ ((cache) => {
  return (module2, temp) => {
    return cache && cache.get(module2) || (temp = __reExport(__markAsModule({}), module2, 1), cache && cache.set(module2, temp), temp);
  };
})(typeof WeakMap !== "undefined" ? /* @__PURE__ */ new WeakMap() : 0);

// src/backend/deny-list/prune-queue-handler.lambda.ts
var prune_queue_handler_lambda_exports = {};
__export(prune_queue_handler_lambda_exports, {
  handler: () => handler
});
var AWS = __toESM(require("aws-sdk"));

// src/backend/shared/env.lambda-shared.ts
var import_process = require("process");
function requireEnv(name) {
  const result = import_process.env[name];
  if (!result) {
    throw new Error(`No value specified for required environment variable: ${name}`);
  }
  return result;
}

// src/backend/deny-list/constants.ts
var ENV_DELETE_OBJECT_DATA_BUCKET_NAME = "PACKAGE_DATA_BUCKET_NAME";

// src/backend/deny-list/prune-queue-handler.lambda.ts
var s3 = new AWS.S3();
async function handler(event) {
  console.log(JSON.stringify({ event }));
  const bucket = requireEnv(ENV_DELETE_OBJECT_DATA_BUCKET_NAME);
  const records = event.Records ?? [];
  for (const record of records) {
    const objectKey = record.body;
    console.log(`deleting s3://${bucket}/${objectKey}`);
    await s3.deleteObject({ Bucket: bucket, Key: objectKey }).promise();
  }
}
module.exports = __toCommonJS(prune_queue_handler_lambda_exports);
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
//# sourceMappingURL=index.js.map
