/*
 * The internal definitions
 *
 * Copyright (C) 2009-2020, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBFSHFS_INTERNAL_DEFINITIONS_H )
#define _LIBFSHFS_INTERNAL_DEFINITIONS_H

#include <common.h>
#include <byte_stream.h>

#include "libfshfs_libfdata.h"

#define LIBFSHFS_ENDIAN_BIG						_BYTE_STREAM_ENDIAN_BIG
#define LIBFSHFS_ENDIAN_LITTLE						_BYTE_STREAM_ENDIAN_LITTLE

/* Define HAVE_LOCAL_LIBFSHFS for local use of libfshfs
 */
#if !defined( HAVE_LOCAL_LIBFSHFS )
#include <libfshfs/definitions.h>

/* The definitions in <libfshfs/definitions.h> are copied here
 * for local use of libfshfs
 */
#else
#define LIBFSHFS_VERSION						20201017

/* The version string
 */
#define LIBFSHFS_VERSION_STRING						"20201017"

/* The file access
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBFSHFS_ACCESS_FLAGS
{
	LIBFSHFS_ACCESS_FLAG_READ					= 0x01,
/* Reserved: not supported yet */
	LIBFSHFS_ACCESS_FLAG_WRITE					= 0x02
};

/* The file access macros
 */
#define LIBFSHFS_OPEN_READ						( LIBFSHFS_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBFSHFS_OPEN_WRITE						( LIBFSHFS_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBFSHFS_OPEN_READ_WRITE					( LIBFSHFS_ACCESS_FLAG_READ | LIBFSHFS_ACCESS_FLAG_WRITE )

/* The path segment separator
 */
#define LIBFSHFS_SEPARATOR						'/'

/* The file system types
 */
enum LIBFSHFS_FILE_SYSTEM_TYPES
{
        LIBFSHFS_EXTENT_FILE_SYSTEM_TYPE_UNDEFINED,
        LIBFSHFS_EXTENT_FILE_SYSTEM_TYPE_HFS,
        LIBFSHFS_EXTENT_FILE_SYSTEM_TYPE_HFS_PLUS,
        LIBFSHFS_EXTENT_FILE_SYSTEM_TYPE_HFSX
};

#endif /* !defined( HAVE_LOCAL_LIBFSHFS ) */

/* The B-tree node types
 */
enum LIBFSHFS_BTREE_NODE_TYPES
{
        LIBFSHFS_BTREE_NODE_TYPE_INDEX_NODE				= 0x00,
        LIBFSHFS_BTREE_NODE_TYPE_HEADER_NODE				= 0x01,
        LIBFSHFS_BTREE_NODE_TYPE_MAP_NODE				= 0x02,

        LIBFSHFS_BTREE_NODE_TYPE_LEAF_NODE				= 0xff
};

/* The record types
 */
enum LIBFSHFS_RECORD_TYPES
{
        LIBFSHFS_RECORD_TYPE_HFSPLUS_DIRECTORY_RECORD			= 0x0001,
        LIBFSHFS_RECORD_TYPE_HFSPLUS_FILE_RECORD			= 0x0002,
        LIBFSHFS_RECORD_TYPE_HFSPLUS_DIRECTORY_THREAD_RECORD		= 0x0003,
        LIBFSHFS_RECORD_TYPE_HFSPLUS_FILE_THREAD_RECORD			= 0x0004,

        LIBFSHFS_RECORD_TYPE_HFS_DIRECTORY_RECORD			= 0x0100,
        LIBFSHFS_RECORD_TYPE_HFS_FILE_RECORD				= 0x0200,
        LIBFSHFS_RECORD_TYPE_HFS_DIRECTORY_THREAD_RECORD		= 0x0300,
        LIBFSHFS_RECORD_TYPE_HFS_FILE_THREAD_RECORD			= 0x0400
};

#define LIBFSHFS_ROOT_DIRECTORY_IDENTIFIER				2

/* The maximum number of cache entries definitions
 */
#define LIBFSHFS_MAXIMUM_CACHE_ENTRIES_BTREE_FILE_ALLOCATION_BLOCKS	4

#define LIBFSHFS_MAXIMUM_BTREE_NODE_RECURSION_DEPTH			256

#endif /* !defined( _LIBFSHFS_INTERNAL_DEFINITIONS_H ) */

