# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['django_flatpickr']

package_data = \
{'': ['*'],
 'django_flatpickr': ['static/django_flatpickr/js/*',
                      'templates/django_flatpickr/*']}

install_requires = \
['Django>=2,<5', 'pydantic', 'typing-extensions']

setup_kwargs = {
    'name': 'django-flatpickr',
    'version': '2.0.0',
    'description': 'Flatpickr based DatePickerInput, TimePickerInput and DateTimePickerInput with date-range-picker functionality for django >= 2.0',
    'long_description': 'django-flatpickr\n================\n\nThis django widget contains Date-Picker, Time-Picker, DateTime-Picker input\nwidgets with date-range-picker functionality for django version >= 2.0.\nThe widget implements `flatpickr <https://github.com/flatpickr/flatpickr>`_\nto display date-pickers in django model forms and custom forms which can be\nconfigured easily for date-range selection. For Bootstrap date-picker see\n`django-bootstrap-datepicker-plus <https://github.com/monim67/django-bootstrap-datepicker-plus>`_.\n\n\n|  |ci-status| |coverage| |pyversions| |djversions|\n\n|  |flatpickr-red-theme| |flatpickr-default-theme| |flatpickr-dark-theme|\n\n\n\nDemo\n----\n-  `Custom Form <demo_custom_form_>`_.\n-  `Model Form <demo_model_form_>`_.\n-  `Generic View (without Model Form) <demo_generic_view_>`_.\n-  `With django-crispy-forms <demo_crispy_form_>`_.\n-  `With django-filter <demo_django_filter_>`_.\n-  `With dynamic formsets <demo_dynamic_formset_>`_.\n\n\n\nGetting Started\n---------------\n\n\nPrerequisites\n^^^^^^^^^^^^^\n-  Python >= 3.7\n-  Django >= 2.0\n\n\nInstalling\n^^^^^^^^^^\nInstall the PyPI package via pip.\n\n::\n\n    pip install django-flatpickr\n\nAdd ``django_flatpickr`` to ``INSTALLED_APPS`` in your ``settings.py`` file.\n\n.. code:: python\n\n    INSTALLED_APPS = [\n        # Add the following\n        "django_flatpickr",\n    ]\n\n\n\nUsage\n-----\n\nThe HTML template must have the following to render the flatpickr widget.\nA better example is `here <file_custom_form_html_>`_.\n\n.. code:: html\n\n    <!-- File: myapp/custom-form.html -->\n    {{ form.media }}  {# Adds all flatpickr JS/CSS files from CDN #}\n    {{ form.as_p }}   {# Renders the form #}\n\n\nYou can use it `with generic views without a model form <generic_view_block_>`_.\nIt can also be used with custom forms and model forms as below.\n\n\nUsage in Custom Form\n^^^^^^^^^^^^^^^^^^^^\n\n.. code:: python\n\n    # File: forms.py\n    from django_flatpickr.widgets import DatePickerInput, TimePickerInput, DateTimePickerInput\n    from .models import Event\n    from django import forms\n\n    class ToDoForm(forms.Form):\n        todo = forms.CharField(widget=forms.TextInput())\n        date = forms.DateField(widget=DatePickerInput())\n        time = forms.TimeField(widget=TimePickerInput())\n        datetime = forms.DateTimeField(widget=DateTimePickerInput())\n\n\n    # File: views.py\n    class CustomFormView(generic.FormView):\n        template_name = "myapp/custom-form.html"\n        form_class = ToDoForm\n\n\nSee `models.py <file_models_py_>`_, `forms.py <file_forms_py_>`_,\n`views.py <file_views_py_>`_, `custom-form.html <file_custom_form_html_>`_\nfor more details.\n\nUsage in Model Form\n^^^^^^^^^^^^^^^^^^^^\n\n.. code:: python\n\n    # File: forms.py\n    from django_flatpickr.widgets import DatePickerInput, TimePickerInput, DateTimePickerInput\n    from .models import Event\n    from django import forms\n\n    class EventForm(forms.ModelForm):\n        class Meta:\n            model = Event\n            fields = ["name", "start_date", "start_time", "start_datetime"]\n            widgets = {\n                "start_date": DatePickerInput(),\n                "start_time": TimePickerInput(),\n                "start_datetime": DateTimePickerInput(),\n            }\n\n\n    # File: views.py\n    class UpdateView(generic.edit.UpdateView):\n        model = Event\n        form_class = EventForm\n\n\nSee `models.py <file_models_py_>`_, `forms.py <file_forms_py_>`_,\n`views.py <file_views_py_>`_, `event_form.html <file_event_form_html_>`_\nfor more details.\n\nImplement date-range-picker\n^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nDatePickers can be linked together to select a date-range, time-range or\ndate-time-range **without writing a single line of JavaScript**.\n\n.. code:: python\n\n    # File: forms.py\n    from django_flatpickr.widgets import DatePickerInput, TimePickerInput\n    from django import forms\n\n    class EventForm(forms.ModelForm):\n        class Meta:\n            model = Event\n            fields = ["name", "start_date", "end_date", "start_time", "end_time"]\n            widgets = {\n                "start_date": DatePickerInput(),\n                "end_date": DatePickerInput(range_from="start_date"),\n                "start_time": TimePickerInput(),\n                "end_time": TimePickerInput(range_from="start_time"),\n            }\n\n\n\nCustomization\n-------------\n\nTo customize the look and features of flatpickr widget copy the\n`settings block <settings_block_>`_ to your settings.py file and customize it.\nSettings applies globally to all flatpickr widgets used in your site.\n\nYou can set date and event hook options using JavaScript.\n\n.. code:: javascript\n\n    window.djangoFlatpickrOptions = {\n        onChange: function (selectedDates) { console.log(selectedDates) }\n    }\n\n\nCustomize single input\n^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n.. code:: python\n\n    from django_flatpickr.schemas import FlatpickrOptions\n\n    class ToDoForm(forms.Form):\n        todo = forms.CharField(widget=forms.TextInput())\n        start_date = forms.DateField(widget=DatePickerInput(\n            attrs = {"class": "my-custom-class"}, # input element attributes\n            options=FlatpickrOptions(altFormat="m/d/Y"),\n        ))\n\nSimilarly set date and event hook options using JavaScript.\n\n.. code:: javascript\n\n    window.djangoFlatpickrOptions_start_date = {\n        onChange: function (selectedDates) { console.log(selectedDates) }\n    }\n\n\nLocalization\n^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nUse locale option, see `available localization options <https://flatpickr.js.org/localization/>`_.\n\n\nLicense\n-------\n\n- `MIT LICENSE <https://github.com/monim67/django-flatpickr/blob/master/LICENSE>`_.\n- `CONTRIBUTING <https://github.com/monim67/django-flatpickr/blob/master/.github/CONTRIBUTING.md>`_.\n- `CODE_OF_CONDUCT <https://github.com/monim67/django-flatpickr/blob/master/.github/CODE_OF_CONDUCT.md>`_.\n\n\n.. |flatpickr-red-theme| image:: https://cloud.githubusercontent.com/assets/11352152/14549374/3cc01102-028d-11e6-9ff4-0cf208a310c4.PNG\n    :alt: Flatpickr Red Theme\n\n.. |flatpickr-default-theme| image:: https://cloud.githubusercontent.com/assets/11352152/14549370/3cadb750-028d-11e6-818d-c6a1bc6349fc.PNG\n    :alt: Flatpickr Default Theme\n\n.. |flatpickr-dark-theme| image:: https://cloud.githubusercontent.com/assets/11352152/14549372/3cbc8514-028d-11e6-8daf-ec1ba01c9d7e.PNG\n    :alt: Flatpickr Dark Theme\n\n\n.. |ci-status| image:: https://travis-ci.org/monim67/django-flatpickr.svg?branch=master\n    :target: https://travis-ci.org/monim67/django-flatpickr\n    :alt: Build Status\n\n.. |coverage| image:: https://coveralls.io/repos/github/monim67/django-flatpickr/badge.svg?branch=master\n    :target: https://coveralls.io/github/monim67/django-flatpickr?branch=master\n    :alt: Coverage Status\n\n.. |pyversions| image:: https://img.shields.io/pypi/pyversions/django-flatpickr.svg\n    :target: https://pypi.python.org/pypi/django-flatpickr\n    :alt: Python Versions\n\n.. |djversions| image:: https://img.shields.io/pypi/djversions/django-flatpickr.svg\n    :target: https://pypi.python.org/pypi/django-flatpickr\n    :alt: DJango Versions\n\n\n\n.. _demo_custom_form: https://monim67.github.io/django-flatpickr/demo/custom-form.html\n.. _demo_model_form: https://monim67.github.io/django-flatpickr/demo/generic-view-with-model-form-1.html\n.. _demo_generic_view: https://monim67.github.io/django-flatpickr/demo/generic-view.html\n.. _demo_crispy_form: https://monim67.github.io/django-flatpickr/demo/crispy-form.html\n.. _demo_django_filter: https://monim67.github.io/django-flatpickr/demo/django-filter.html\n.. _demo_dynamic_formset: https://monim67.github.io/django-flatpickr/demo/dynamic-formset.html\n\n.. _generic_view_block: https://github.com/monim67/django-flatpickr/blob/2.0.0/dev/myapp/views.py#L31\n.. _settings_block: https://github.com/monim67/django-flatpickr/blob/2.0.0/dev/mysite/settings.py#L143-L200\n\n.. _file_custom_form_html: https://github.com/monim67/django-flatpickr/blob/2.0.0/dev/myapp/templates/myapp/custom-form.html\n.. _file_event_form_html: https://github.com/monim67/django-flatpickr/blob/2.0.0/dev/myapp/templates/myapp/event_form.html\n.. _file_forms_py: https://github.com/monim67/django-flatpickr/blob/2.0.0/dev/myapp/forms.py\n.. _file_views_py: https://github.com/monim67/django-flatpickr/blob/2.0.0/dev/myapp/views.py\n.. _file_models_py: https://github.com/monim67/django-flatpickr/blob/2.0.0/dev/myapp/models.py\n',
    'author': 'Munim Munna',
    'author_email': '6266677+monim67@users.noreply.github.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/monim67/django-flatpickr',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
