import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


class Object3D(ThreeWidget):
    """Object3D

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/core/Object3D
    """

    def __init__(self, **kwargs):
        super(Object3D, self).__init__(**kwargs)

    _model_name = Unicode('Object3DModel').tag(sync=True)

    name = Unicode("", allow_none=False).tag(sync=True)

    type = Unicode("Object3D", allow_none=False).tag(sync=True)

    children = Tuple().tag(sync=True, **widget_serialization)

    up = Vector3(default_value=[0, 1, 0]).tag(sync=True)

    position = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    rotation = Euler(default_value=[0, 0, 0, "XYZ"]).tag(sync=True)

    quaternion = Vector4(default_value=[0, 0, 0, 1]).tag(sync=True)

    scale = Vector3(default_value=[1, 1, 1]).tag(sync=True)

    modelViewMatrix = Matrix4(default_value=[1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]).tag(sync=True)

    normalMatrix = Matrix3(default_value=[1, 0, 0, 0, 1, 0, 0, 0, 1]).tag(sync=True)

    matrix = Matrix4(default_value=[1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]).tag(sync=True)

    matrixWorld = Matrix4(default_value=[1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]).tag(sync=True)

    matrixAutoUpdate = Bool(True, allow_none=False).tag(sync=True)

    matrixWorldNeedsUpdate = Bool(False, allow_none=False).tag(sync=True)

    visible = Bool(True, allow_none=False).tag(sync=True)

    castShadow = Bool(False, allow_none=False).tag(sync=True)

    receiveShadow = Bool(False, allow_none=False).tag(sync=True)

    frustumCulled = Bool(True, allow_none=False).tag(sync=True)

    renderOrder = CInt(0, allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Object3D.__signature__ = inspect.signature(Object3D.__init__)
